/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.client;

import com.google_voltpatches.common.base.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.InflaterOutputStream;
import org.apache.cassandra_voltpatches.MurmurHash3;
import org.voltcore.utils.Bits;
import org.voltcore.utils.Pair;
import org.voltdb.VoltType;
import org.voltdb.VoltTypeException;

public class HashinatorLite {
    private int catalogPartitionCount;
    private long m_etokens = 0L;
    private int m_etokenCount;

    public static byte[] getLegacyConfigureBytes(int catalogPartitionCount) {
        ByteBuffer buf = ByteBuffer.allocate(4);
        buf.putInt(catalogPartitionCount);
        return buf.array();
    }

    public HashinatorLite(byte[] configBytes, boolean cooked) {
        Pair<Long, Integer> p = cooked ? this.updateCooked(configBytes) : this.updateRaw(configBytes);
        this.m_etokens = p.getFirst();
        this.m_etokenCount = p.getSecond();
    }

    public HashinatorLite(int numPartitions) {
        this(HashinatorLite.getLegacyConfigureBytes(numPartitions), false);
    }

    public void finalize() {
        if (this.m_etokens != 0L) {
            Bits.unsafe.freeMemory(this.m_etokens);
        }
    }

    private Pair<Long, Integer> updateCooked(byte[] compressedData) {
        int ii;
        byte[] cookedBytes;
        try {
            cookedBytes = HashinatorLite.gunzipBytes(compressedData);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to decompress elastic hashinator data.");
        }
        int numEntries = cookedBytes.length >= 4 ? ByteBuffer.wrap(cookedBytes).getInt() : 0;
        int tokensSize = 4 * numEntries;
        int partitionsSize = 4 * numEntries;
        if (numEntries <= 0 || cookedBytes.length != 4 + tokensSize + partitionsSize) {
            throw new RuntimeException("Bad elastic hashinator cooked config size.");
        }
        long tokens = Bits.unsafe.allocateMemory(8 * numEntries);
        ByteBuffer tokenBuf = ByteBuffer.wrap(cookedBytes, 4, tokensSize);
        ByteBuffer partitionBuf = ByteBuffer.wrap(cookedBytes, 4 + tokensSize, partitionsSize);
        int[] tokensArray = new int[numEntries];
        for (int zz = 3; zz >= 0; --zz) {
            for (ii = 0; ii < numEntries; ++ii) {
                int value = tokenBuf.get();
                value = value << zz * 8 & 255 << zz * 8;
                tokensArray[ii] = tokensArray[ii] | value;
            }
        }
        int lastToken = Integer.MIN_VALUE;
        for (ii = 0; ii < numEntries; ++ii) {
            int token = tokensArray[ii];
            Preconditions.checkArgument(token >= lastToken);
            lastToken = token;
            long ptr = tokens + (long)(ii * 8);
            Bits.unsafe.putInt(ptr, token);
            int partitionId = partitionBuf.getInt();
            Bits.unsafe.putInt(ptr + 4L, partitionId);
        }
        return Pair.of(tokens, numEntries);
    }

    private Pair<Long, Integer> updateRaw(byte[] configBytes) {
        ByteBuffer buf = ByteBuffer.wrap(configBytes);
        int numEntries = buf.getInt();
        if (numEntries < 0) {
            throw new RuntimeException("Bad elastic hashinator config");
        }
        long tokens = Bits.unsafe.allocateMemory(8 * numEntries);
        int lastToken = Integer.MIN_VALUE;
        for (int ii = 0; ii < numEntries; ++ii) {
            long ptr = tokens + (long)(ii * 8);
            int token = buf.getInt();
            Preconditions.checkArgument(token >= lastToken);
            lastToken = token;
            Bits.unsafe.putInt(ptr, token);
            int partitionId = buf.getInt();
            Bits.unsafe.putInt(ptr + 4L, partitionId);
        }
        return Pair.of(tokens, numEntries);
    }

    int hashinateLong(long value) {
        if (value == Long.MIN_VALUE) {
            return 0;
        }
        return this.partitionForToken(MurmurHash3.hash3_x64_128(value));
    }

    public int partitionForToken(int hash) {
        long token = this.getTokenPtr(hash);
        return Bits.unsafe.getInt(token + 4L);
    }

    private int hashinateBytes(Object obj) {
        byte[] bytes = VoltType.valueToBytes(obj);
        if (bytes == null) {
            return 0;
        }
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        int hash = MurmurHash3.hash3_x64_128(buf, 0, bytes.length, 0L);
        long token = this.getTokenPtr(hash);
        return Bits.unsafe.getInt(token + 4L);
    }

    private long getTokenPtr(int hash) {
        int min = 0;
        int max = this.m_etokenCount - 1;
        while (min <= max) {
            int mid = min + max >>> 1;
            long midPtr = this.m_etokens + (long)(8 * mid);
            int midval = Bits.unsafe.getInt(midPtr);
            if (midval < hash) {
                min = mid + 1;
                continue;
            }
            if (midval > hash) {
                max = mid - 1;
                continue;
            }
            return midPtr;
        }
        return this.m_etokens + (long)((min - 1) * 8);
    }

    private int hashToPartition(VoltType type, Object obj) {
        return this.hashinateBytes(obj);
    }

    public int getHashedPartitionForParameter(int partitionParameterType, Object partitionValue) throws VoltTypeException {
        VoltType partitionParamType = VoltType.get((byte)partitionParameterType);
        if (partitionValue != null && partitionParamType.isAnyIntegerType()) {
            if (partitionValue.getClass() == String.class) {
                try {
                    partitionValue = Long.parseLong((String)partitionValue);
                }
                catch (NumberFormatException nfe) {
                    throw new VoltTypeException("getHashedPartitionForParameter: Unable to convert string " + (String)partitionValue + " to " + partitionParamType.getMostCompatibleJavaTypeName() + " target parameter ");
                }
            } else if (partitionValue.getClass() == byte[].class) {
                partitionValue = partitionParamType.bytesToValue((byte[])partitionValue);
            }
        }
        return this.hashToPartition(partitionParamType, partitionValue);
    }

    public static byte[] gunzipBytes(byte[] compressedBytes) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream((int)((double)compressedBytes.length * 1.5));
        InflaterOutputStream dos = new InflaterOutputStream(bos);
        dos.write(compressedBytes);
        dos.close();
        return bos.toByteArray();
    }
}

