/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.client;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.voltdb.ParameterSet;
import org.voltdb.client.ProcedureInvocationExtensions;
import org.voltdb.client.ProcedureInvocationType;
import org.voltdb.utils.SerializationHelper;

public class ProcedureInvocation {
    public static final byte CURRENT_MOST_RECENT_VERSION = ProcedureInvocationType.VERSION2.getValue();
    private final long m_clientHandle;
    private final String m_procName;
    private byte[] m_procNameBytes = null;
    private final int m_batchTimeout;
    private final ParameterSet m_parameters;
    private final int m_partitionDestination;
    private static final Charset UTF8Encoding = Charset.forName("UTF-8");

    public ProcedureInvocation(long handle, String procName, Object ... parameters) {
        this(handle, -1, -1, procName, parameters);
    }

    public ProcedureInvocation(long handle, int batchTimeout, String procName, Object ... parameters) {
        this(handle, batchTimeout, -1, procName, parameters);
    }

    public ProcedureInvocation(long handle, int batchTimeout, int partitionDestination, String procName, Object ... parameters) {
        if (batchTimeout < 0 && batchTimeout != -1) {
            throw new IllegalArgumentException("Timeout value can't be negative.");
        }
        this.m_clientHandle = handle;
        this.m_procName = procName;
        this.m_parameters = parameters != null ? ParameterSet.fromArrayWithCopy(parameters) : ParameterSet.emptyParameterSet();
        this.m_batchTimeout = batchTimeout;
        this.m_partitionDestination = partitionDestination;
    }

    long getHandle() {
        return this.m_clientHandle;
    }

    public String getProcName() {
        return this.m_procName;
    }

    public int getPassedParamCount() {
        return this.m_parameters.size();
    }

    public Object getPartitionParamValue(int index) {
        return this.m_parameters.getParam(index);
    }

    public long getClientHandle() {
        return this.m_clientHandle;
    }

    public int getBatchTimeout() {
        return this.m_batchTimeout;
    }

    public boolean hasPartitionDestination() {
        return this.m_partitionDestination != -1;
    }

    public int getPartitionDestination() {
        return this.m_partitionDestination;
    }

    public int getSerializedSize() {
        if (this.m_procNameBytes == null) {
            this.m_procNameBytes = this.m_procName.getBytes(UTF8Encoding);
        }
        int batchExtensionSize = this.m_batchTimeout != -1 ? 6 : 0;
        int partitionDestinationSize = this.hasPartitionDestination() ? 8 : 0;
        int size = 5 + this.m_procNameBytes.length + 8 + 1 + batchExtensionSize + partitionDestinationSize + this.m_parameters.getSerializedSize();
        assert (size > 0);
        return size;
    }

    public ByteBuffer flattenToBuffer(ByteBuffer buf) throws IOException {
        if (this.m_procNameBytes == null) {
            this.m_procNameBytes = this.m_procName.getBytes(UTF8Encoding);
        }
        buf.put(CURRENT_MOST_RECENT_VERSION);
        SerializationHelper.writeVarbinary(this.m_procNameBytes, buf);
        buf.putLong(this.m_clientHandle);
        byte extensionCount = 0;
        if (this.m_batchTimeout != -1) {
            extensionCount = (byte)(extensionCount + 1);
        }
        if (this.hasPartitionDestination()) {
            extensionCount = (byte)(extensionCount + 2);
        }
        buf.put(extensionCount);
        if (this.m_batchTimeout != -1) {
            ProcedureInvocationExtensions.writeBatchTimeoutWithTypeByte(buf, this.m_batchTimeout);
        }
        if (this.hasPartitionDestination()) {
            ProcedureInvocationExtensions.writeAllPartitionWithTypeByte(buf);
            ProcedureInvocationExtensions.writePartitionDestinationWithTypeByte(buf, this.m_partitionDestination);
        }
        this.m_parameters.flattenToBuffer(buf);
        return buf;
    }
}

