/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.client;

import java.nio.ByteBuffer;

public abstract class ProcedureInvocationExtensions {
    public static final byte BATCH_TIMEOUT = 1;
    public static final byte ALL_PARTITION = 2;
    public static final byte PARTITION_DESTINATION = 3;
    private static final int INTEGER_SIZE = 4;

    public static byte readNextType(ByteBuffer buf) {
        return buf.get();
    }

    public static void writeBatchTimeoutWithTypeByte(ByteBuffer buf, int timeoutValue) {
        buf.put((byte)1);
        ProcedureInvocationExtensions.writeLength(buf, 4);
        buf.putInt(timeoutValue);
    }

    public static int readBatchTimeout(ByteBuffer buf) {
        int timeout = ProcedureInvocationExtensions.readInt(buf, "Batch timeout");
        if (timeout < 0 && timeout != -1) {
            throw new IllegalStateException("Invalid timeout value deserialized: " + timeout);
        }
        return timeout;
    }

    public static void writeAllPartitionWithTypeByte(ByteBuffer buf) {
        buf.put((byte)2);
        ProcedureInvocationExtensions.writeLength(buf, 0);
    }

    public static boolean readAllPartition(ByteBuffer buf) {
        int len = ProcedureInvocationExtensions.readLength(buf);
        if (len != 0) {
            throw new IllegalStateException("All-Partition extension serialization length expected to be 0");
        }
        return true;
    }

    public static void writePartitionDestinationWithTypeByte(ByteBuffer buf, int partitionDestination) {
        buf.put((byte)3);
        ProcedureInvocationExtensions.writeLength(buf, 4);
        buf.putInt(partitionDestination);
    }

    public static int readPartitionDestination(ByteBuffer buf) {
        int partitionDestination = ProcedureInvocationExtensions.readInt(buf, "Partition destination");
        if (partitionDestination < 0) {
            throw new IllegalStateException("Invalid partition destination deserialized: " + partitionDestination);
        }
        return partitionDestination;
    }

    public static void skipUnknownExtension(ByteBuffer buf) {
        int len = ProcedureInvocationExtensions.readLength(buf);
        buf.position(buf.position() + len);
    }

    private static void writeLength(ByteBuffer buf, int length) {
        assert (length >= 0);
        assert (length == (length & ~length + 1));
        byte log2size = (byte)(32 - Integer.numberOfLeadingZeros(length));
        buf.put(log2size);
    }

    private static int readLength(ByteBuffer buf) {
        byte log2size = buf.get();
        if (log2size == 0) {
            return 0;
        }
        return 1 << log2size - 1;
    }

    private static int readInt(ByteBuffer buf, String extenstion) {
        int len = ProcedureInvocationExtensions.readLength(buf);
        if (len != 4) {
            throw new IllegalStateException(extenstion + " extension serialization length expected to be 4");
        }
        return buf.getInt();
    }
}

