/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.client;

import com.google_voltpatches.common.base.Throwables;
import java.util.ArrayDeque;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class RateLimiter {
    final int BLOCK_SIZE = 100;
    final int HISTORY_SIZE = 25;
    final int RECENT_HISTORY_SIZE = 5;
    final int MINIMUM_MOVEMENT = 5;
    protected boolean m_doesAnyTuning = false;
    protected boolean m_autoTune = false;
    protected int m_targetTxnsPerSecond = Integer.MAX_VALUE;
    protected int m_latencyTarget = 5;
    protected int m_currentBlockSendCount = 0;
    protected int m_currentBlockRecvSuccessCount = 0;
    protected int m_outstandingTxns = 0;
    protected Semaphore m_outstandingTxnsSemaphore = new Semaphore(10);
    protected int m_maxOutstandingTxns = 10;
    protected long m_currentBlockTimestamp = -1L;
    protected long m_currentBlockTotalInternalLatency = 0L;
    protected ArrayDeque<Double> m_prevInternalLatencyAvgs = new ArrayDeque();

    RateLimiter() {
    }

    protected void autoTuneTargetFromHistory() {
        double recentLatency = 0.0;
        double mediumTermLatency = 0.0;
        if (this.m_prevInternalLatencyAvgs.size() > 0) {
            int i = 0;
            for (double value : this.m_prevInternalLatencyAvgs) {
                if (i < 5) {
                    recentLatency += value;
                }
                mediumTermLatency += value;
                ++i;
            }
            recentLatency /= (double)Math.min(this.m_prevInternalLatencyAvgs.size(), 5);
            mediumTermLatency /= (double)this.m_prevInternalLatencyAvgs.size();
        }
        this.m_maxOutstandingTxns = mediumTermLatency > (double)this.m_latencyTarget && recentLatency > (double)this.m_latencyTarget ? (int)((double)this.m_maxOutstandingTxns - Math.max(0.1 * (double)this.m_maxOutstandingTxns, 5.0)) : (mediumTermLatency < (double)this.m_latencyTarget && recentLatency > (double)this.m_latencyTarget ? --this.m_maxOutstandingTxns : (mediumTermLatency > (double)this.m_latencyTarget && recentLatency < (double)this.m_latencyTarget ? ++this.m_maxOutstandingTxns : (int)((double)this.m_maxOutstandingTxns + Math.max(0.1 * (double)this.m_maxOutstandingTxns, 5.0))));
        if (this.m_maxOutstandingTxns <= 0) {
            this.m_maxOutstandingTxns = 1;
        }
    }

    protected void ensureCurrentBlockIsKosher(long timestamp) {
        long thisBlock = timestamp - timestamp % 100L;
        if (this.m_currentBlockTimestamp == -1L) {
            this.m_currentBlockTimestamp = thisBlock;
        }
        if (thisBlock < this.m_currentBlockTimestamp) {
            thisBlock = this.m_currentBlockTimestamp;
        }
        if (thisBlock > this.m_currentBlockTimestamp) {
            this.m_currentBlockTimestamp = thisBlock;
            this.m_prevInternalLatencyAvgs.addFirst((double)this.m_currentBlockTotalInternalLatency / (double)this.m_currentBlockRecvSuccessCount);
            while (this.m_prevInternalLatencyAvgs.size() > 25) {
                this.m_prevInternalLatencyAvgs.pollLast();
            }
            this.m_currentBlockSendCount = 0;
            this.m_currentBlockRecvSuccessCount = 0;
            this.m_currentBlockTotalInternalLatency = 0L;
            if (this.m_autoTune) {
                this.autoTuneTargetFromHistory();
            }
        }
    }

    synchronized void enableAutoTuning(int latencyTarget) {
        this.m_autoTune = true;
        this.m_doesAnyTuning = true;
        this.m_targetTxnsPerSecond = Integer.MAX_VALUE;
        this.m_maxOutstandingTxns = 20;
        this.m_latencyTarget = latencyTarget;
    }

    synchronized void setLimits(int txnsPerSec, int maxOutstanding) {
        this.m_autoTune = false;
        if (txnsPerSec < 0x3FFFFFFF) {
            this.m_doesAnyTuning = true;
        }
        this.m_targetTxnsPerSecond = txnsPerSec;
        this.m_maxOutstandingTxns = maxOutstanding;
        this.m_outstandingTxnsSemaphore.drainPermits();
        this.m_outstandingTxnsSemaphore.release(maxOutstanding);
    }

    synchronized int[] getLimits() {
        int[] limits = new int[]{this.m_targetTxnsPerSecond, this.m_maxOutstandingTxns};
        return limits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void transactionResponseReceived(long timestampNanos, int internalLatency, boolean ignoreBackpressure) {
        if (this.m_doesAnyTuning) {
            RateLimiter rateLimiter = this;
            synchronized (rateLimiter) {
                this.ensureCurrentBlockIsKosher(TimeUnit.NANOSECONDS.toMillis(timestampNanos));
                --this.m_outstandingTxns;
                assert (this.m_outstandingTxns >= 0);
                if (internalLatency != -1) {
                    ++this.m_currentBlockRecvSuccessCount;
                    this.m_currentBlockTotalInternalLatency += (long)internalLatency;
                }
            }
        } else {
            if (ignoreBackpressure) {
                return;
            }
            this.m_outstandingTxnsSemaphore.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long sendTxnWithOptionalBlockAndReturnCurrentTime(long timestampNanos, long timeoutNanos, boolean ignoreBackpressure) throws TimeoutException {
        block16: {
            if (this.m_doesAnyTuning) {
                long timestamp = TimeUnit.NANOSECONDS.toMillis(timestampNanos);
                while (true) {
                    RateLimiter rateLimiter = this;
                    synchronized (rateLimiter) {
                        this.ensureCurrentBlockIsKosher(timestamp);
                        assert (timestamp - this.m_currentBlockTimestamp <= 100L);
                        long faketime = timestamp < this.m_currentBlockTimestamp ? this.m_currentBlockTimestamp : timestamp;
                        long targetTxnsPerBlock = this.m_targetTxnsPerSecond / 10;
                        double expectedTxnsSent = (double)targetTxnsPerBlock * ((double)(faketime - this.m_currentBlockTimestamp) + 1.0) / 100.0;
                        expectedTxnsSent = Math.ceil(expectedTxnsSent);
                        assert (expectedTxnsSent <= (double)targetTxnsPerBlock);
                        assert (expectedTxnsSent >= 1.0 || targetTxnsPerBlock == 0L);
                        if ((double)this.m_currentBlockSendCount < expectedTxnsSent && this.m_outstandingTxns < this.m_maxOutstandingTxns || ignoreBackpressure) {
                            ++this.m_currentBlockSendCount;
                            ++this.m_outstandingTxns;
                            break block16;
                        }
                    }
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    timestampNanos = System.nanoTime();
                    timestamp = TimeUnit.NANOSECONDS.toMillis(timestampNanos);
                }
            }
            if (ignoreBackpressure) {
                return timestampNanos;
            }
            boolean acquired = this.m_outstandingTxnsSemaphore.tryAcquire();
            if (!acquired) {
                try {
                    if (!this.m_outstandingTxnsSemaphore.tryAcquire(timeoutNanos, TimeUnit.NANOSECONDS)) {
                        throw new TimeoutException();
                    }
                }
                catch (InterruptedException e) {
                    Throwables.propagate(e);
                }
                return System.nanoTime();
            }
        }
        return timestampNanos;
    }

    public synchronized void debug() {
        System.out.printf("Target throughput/s is %d and max outstanding txns is %d\n", this.m_targetTxnsPerSecond, this.m_maxOutstandingTxns);
        System.out.printf("Current outstanding is %d and recent internal latency is %.2f\n", this.m_outstandingTxns, this.m_prevInternalLatencyAvgs.peekFirst());
    }
}

