/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.client;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.voltcore.logging.VoltLogger;
import org.voltdb.client.Client;
import org.voltdb.client.ClientStatusListenerExt;

public class ReconnectStatusListener
extends ClientStatusListenerExt {
    private static final VoltLogger LOG = new VoltLogger("HOST");
    private final ExecutorService executor = Executors.newCachedThreadPool(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable, "Retry Connection");
            thread.setDaemon(true);
            return thread;
        }
    });
    private final Client m_client;
    private final long m_initialRetryIntervalMS;
    private final long m_maxRetryIntervalMS;
    private final AtomicBoolean m_shouldContinue = new AtomicBoolean(true);

    protected ReconnectStatusListener(Client client, long initialRetryIntervalMS, long maxRetryIntervalMS) {
        if (initialRetryIntervalMS < 1L) {
            throw new IllegalArgumentException("initial connection retry interval must be greater than 0, " + initialRetryIntervalMS + " was specified");
        }
        if (maxRetryIntervalMS < 1L) {
            throw new IllegalArgumentException("max connection retry interval must be greater than 0, " + maxRetryIntervalMS + " was specified");
        }
        if (maxRetryIntervalMS < initialRetryIntervalMS) {
            throw new IllegalArgumentException("max connection retry interval can't be less than initial connection retry interval");
        }
        this.m_client = client;
        this.m_initialRetryIntervalMS = initialRetryIntervalMS;
        this.m_maxRetryIntervalMS = maxRetryIntervalMS;
    }

    @Override
    public void connectionLost(final String hostname, final int port, int connectionsLeft, ClientStatusListenerExt.DisconnectCause cause) {
        LOG.warn(String.format("Connection to VoltDB node at: %s:%d was lost.", hostname, port));
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                ReconnectStatusListener.this.connectToOneServerWithRetry(hostname, port);
            }
        });
    }

    public void close() {
        this.m_shouldContinue.set(false);
        this.executor.shutdownNow();
        try {
            this.executor.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void connectToOneServerWithRetry(String hostname, int port) {
        long sleep = this.m_initialRetryIntervalMS;
        while (this.m_shouldContinue.get()) {
            try {
                this.m_client.createConnection(hostname, port);
                LOG.info(String.format("Connected to VoltDB node at %s:%d.", hostname, port));
                break;
            }
            catch (Exception e) {
                LOG.warn(String.format("Connection to VoltDB node at %s:%d failed - retrying in %d second(s).", hostname, port, TimeUnit.MILLISECONDS.toSeconds(sleep)));
                try {
                    Thread.sleep(sleep);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (sleep >= this.m_maxRetryIntervalMS) continue;
                sleep = Math.min(sleep + sleep, this.m_maxRetryIntervalMS);
            }
        }
    }
}

