/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.client;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;

public class TLSHandshaker {
    private ByteBuffer m_rxNetData;
    private final SSLEngine m_eng;
    private final SocketChannel m_sc;
    private final int m_appsz;

    public TLSHandshaker(SocketChannel socketChan, SSLEngine engine) {
        this.m_sc = socketChan;
        this.m_eng = engine;
        SSLSession dummySession = engine.getSession();
        int appsz = engine.getSession().getApplicationBufferSize() + 2048;
        this.m_appsz = Integer.highestOneBit(appsz) < appsz ? Integer.highestOneBit(appsz) << 1 : appsz;
        this.m_rxNetData = (ByteBuffer)ByteBuffer.allocate(dummySession.getPacketBufferSize()).clear();
        dummySession.invalidate();
    }

    boolean canread(Selector selector) {
        Iterator<SelectionKey> keyIterator = selector.selectedKeys().iterator();
        boolean can = false;
        while (keyIterator.hasNext()) {
            SelectionKey key = keyIterator.next();
            if (key.isReadable()) {
                can = true;
            }
            keyIterator.remove();
        }
        return can;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handshake() throws IOException {
        ByteBuffer txNetData = (ByteBuffer)ByteBuffer.allocate(this.m_appsz).clear();
        ByteBuffer clearData = (ByteBuffer)ByteBuffer.allocate(16384).clear();
        SSLEngineResult result = null;
        this.m_eng.beginHandshake();
        SSLEngineResult.HandshakeStatus status = this.m_eng.getHandshakeStatus();
        boolean isBlocked = this.m_sc.isBlocking();
        Object object = this.m_sc.blockingLock();
        synchronized (object) {
            isBlocked = this.m_sc.isBlocking();
            if (isBlocked) {
                this.m_sc.configureBlocking(false);
            }
        }
        Selector selector = Selector.open();
        this.m_sc.register(selector, 1);
        try {
            block45: while (status != SSLEngineResult.HandshakeStatus.FINISHED && status != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                boolean waitForData = true;
                switch (status) {
                    case NEED_UNWRAP: {
                        if (waitForData && selector.select(2L) == 1 && this.canread(selector) && this.m_sc.read(this.m_rxNetData) < 0) {
                            if (this.m_eng.isInboundDone() && this.m_eng.isOutboundDone()) {
                                boolean bl = false;
                                return bl;
                            }
                            try {
                                this.m_eng.closeInbound();
                            }
                            catch (SSLException sSLException) {
                                // empty catch block
                            }
                            this.m_eng.closeOutbound();
                            status = this.m_eng.getHandshakeStatus();
                            continue block45;
                        }
                        this.m_rxNetData.flip();
                        try {
                            result = this.m_eng.unwrap(this.m_rxNetData, clearData);
                            this.m_rxNetData.compact();
                            waitForData = this.m_rxNetData.position() == 0;
                            status = result.getHandshakeStatus();
                        }
                        catch (SSLException e) {
                            this.m_eng.closeOutbound();
                            throw e;
                        }
                        switch (result.getStatus()) {
                            case OK: {
                                continue block45;
                            }
                            case BUFFER_OVERFLOW: {
                                clearData = TLSHandshaker.expand(clearData, false);
                                continue block45;
                            }
                            case BUFFER_UNDERFLOW: {
                                waitForData = true;
                                continue block45;
                            }
                            case CLOSED: {
                                if (this.m_eng.isOutboundDone()) {
                                    boolean e = false;
                                    return e;
                                }
                                this.m_eng.closeOutbound();
                                status = this.m_eng.getHandshakeStatus();
                                continue block45;
                            }
                        }
                        throw new IllegalStateException("Invalid SSL status: " + (Object)((Object)result.getStatus()));
                    }
                    case NEED_WRAP: {
                        txNetData.clear();
                        try {
                            result = this.m_eng.wrap(clearData, txNetData);
                            status = result.getHandshakeStatus();
                        }
                        catch (SSLException e) {
                            this.m_eng.closeOutbound();
                            throw e;
                        }
                        switch (result.getStatus()) {
                            case OK: {
                                txNetData.flip();
                                while (txNetData.hasRemaining()) {
                                    this.m_sc.write(txNetData);
                                }
                                continue block45;
                            }
                            case BUFFER_OVERFLOW: {
                                txNetData = TLSHandshaker.expand(txNetData, false);
                                continue block45;
                            }
                            case BUFFER_UNDERFLOW: {
                                throw new SSLException("Buffer underflow occured after a wrap");
                            }
                            case CLOSED: {
                                txNetData.flip();
                                while (txNetData.hasRemaining()) {
                                    this.m_sc.write(txNetData);
                                }
                                this.m_rxNetData.clear();
                                status = this.m_eng.getHandshakeStatus();
                                continue block45;
                            }
                        }
                        throw new IllegalStateException("Invalid SSL status: " + (Object)((Object)result.getStatus()));
                    }
                    case NEED_TASK: {
                        Runnable task;
                        while ((task = this.m_eng.getDelegatedTask()) != null) {
                            task.run();
                        }
                        status = this.m_eng.getHandshakeStatus();
                        continue block45;
                    }
                    case FINISHED: {
                        continue block45;
                    }
                    case NOT_HANDSHAKING: {
                        continue block45;
                    }
                }
                throw new IllegalStateException("Invalid SSL handshake status" + (Object)((Object)status));
            }
        }
        finally {
            SelectionKey sk = this.m_sc.keyFor(selector);
            sk.cancel();
            selector.close();
            if (isBlocked) {
                Object object2 = this.m_sc.blockingLock();
                synchronized (object2) {
                    this.m_sc.configureBlocking(isBlocked);
                }
            }
        }
        this.m_rxNetData.flip();
        return true;
    }

    public ByteBuffer getRemnant() throws IOException {
        if (!this.m_rxNetData.hasRemaining()) {
            return this.m_rxNetData.slice();
        }
        ByteBuffer remnant = ByteBuffer.allocate(this.m_eng.getSession().getApplicationBufferSize());
        SSLEngineResult result = this.m_eng.unwrap(this.m_rxNetData, remnant);
        switch (result.getStatus()) {
            case OK: {
                assert (!this.m_rxNetData.hasRemaining()) : "there are unexpected additional remnants";
                return ((ByteBuffer)remnant.flip()).slice().asReadOnlyBuffer();
            }
            case BUFFER_OVERFLOW: {
                throw new IOException("buffer underflow while decrypting handshake remnant");
            }
            case BUFFER_UNDERFLOW: {
                throw new IOException("buffer overflow while decrypting handshake remnant");
            }
            case CLOSED: {
                throw new IOException("ssl engine closed while decrypting handshake remnant");
            }
        }
        return null;
    }

    public boolean hasRemnant() {
        return this.m_rxNetData.hasRemaining();
    }

    public SSLEngine getSslEngine() {
        return this.m_eng;
    }

    private static ByteBuffer expand(ByteBuffer bb, boolean copy) {
        ByteBuffer expanded = (ByteBuffer)ByteBuffer.allocate(bb.capacity() << 1).clear();
        if (copy) {
            expanded.put((ByteBuffer)bb.flip());
        }
        return expanded;
    }
}

