/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.client.exampleutils;

import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.voltdb.client.exampleutils.ClientConnection;
import org.voltdb.client.exampleutils.PerfCounterMap;

public class ClientConnectionPool {
    private static final ConcurrentHashMap<String, PerfCounterMap> Statistics = new ConcurrentHashMap();
    private static final HashMap<String, ClientConnection> ClientConnections = new HashMap();

    private ClientConnectionPool() {
    }

    public static ClientConnection get(String servers, int port) throws Exception {
        return ClientConnectionPool.get(servers.split(","), port, "", "", false, 0);
    }

    public static ClientConnection getWithRetry(String servers, int port) throws Exception {
        return ClientConnectionPool.getWithRetry(servers.split(","), port, "", "", false, 0);
    }

    public static ClientConnection get(String[] servers, int port) throws Exception {
        return ClientConnectionPool.get(servers, port, "", "", false, 0);
    }

    public static ClientConnection getWithRetry(String[] servers, int port) throws Exception {
        return ClientConnectionPool.getWithRetry(servers, port, "", "", false, 0);
    }

    public static ClientConnection get(String servers, int port, String user, String password, boolean isHeavyWeight, int maxOutstandingTxns) throws Exception {
        return ClientConnectionPool.get(servers.split(","), port, user, password, isHeavyWeight, maxOutstandingTxns);
    }

    public static ClientConnection getWithRetry(String servers, int port, String user, String password, boolean isHeavyWeight, int maxOutstandingTxns) throws Exception {
        return ClientConnectionPool.getWithRetry(servers.split(","), port, user, password, isHeavyWeight, maxOutstandingTxns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClientConnection get(String[] servers, int port, String user, String password, boolean isHeavyWeight, int maxOutstandingTxns) throws Exception {
        String clientConnectionKeyBase;
        String clientConnectionKey = clientConnectionKeyBase = ClientConnectionPool.getClientConnectionKeyBase(servers, port, user, password, isHeavyWeight, maxOutstandingTxns);
        HashMap<String, ClientConnection> hashMap = ClientConnections;
        synchronized (hashMap) {
            if (!ClientConnections.containsKey(clientConnectionKey)) {
                ClientConnections.put(clientConnectionKey, new ClientConnection(clientConnectionKeyBase, clientConnectionKey, servers, port, user, password, isHeavyWeight, maxOutstandingTxns));
            }
            return ClientConnections.get(clientConnectionKey).use();
        }
    }

    public static ClientConnection getWithRetry(String[] servers, int port, String user, String password, boolean isHeavyWeight, int maxOutstandingTxns) throws Exception {
        ClientConnection con = null;
        System.out.println("Connecting to servers: ");
        for (String server : servers) {
            System.out.printf(" - %s:%d\n", server, port);
        }
        System.out.printf("Credentials:\n%s\nOptions:\n - Heavyweight: %s\n - MaxTxnQueue: %s\n", user == "" ? " - None" : " - User: " + user + "\n - Password: ********", isHeavyWeight ? "yes" : "no", maxOutstandingTxns == 0 ? "(default)" : String.format("%,d", maxOutstandingTxns));
        int sleep = 1000;
        while (true) {
            try {
                con = ClientConnectionPool.get(servers, port);
            }
            catch (Exception e) {
                System.err.printf("Connection failed - retrying in %d second(s).\n", sleep / 1000);
                try {
                    Thread.sleep(sleep);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (sleep >= 8000) continue;
                sleep += sleep;
                continue;
            }
            break;
        }
        System.out.println("Connected.");
        return con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dispose(ClientConnection connection) {
        HashMap<String, ClientConnection> hashMap = ClientConnections;
        synchronized (hashMap) {
            connection.dispose();
            if (connection.Users == 0) {
                ClientConnections.remove(connection.Key);
            }
        }
    }

    public static PerfCounterMap getStatistics(ClientConnection connection) {
        return ClientConnectionPool.getStatistics(connection.KeyBase);
    }

    public static PerfCounterMap getStatistics(String servers, int port) {
        return ClientConnectionPool.getStatistics(ClientConnectionPool.getClientConnectionKeyBase(servers.split(","), port, "", "", false, 0));
    }

    public static PerfCounterMap getStatistics(String[] servers, int port) {
        return ClientConnectionPool.getStatistics(ClientConnectionPool.getClientConnectionKeyBase(servers, port, "", "", false, 0));
    }

    public static PerfCounterMap getStatistics(String servers, int port, String user, String password, boolean isHeavyWeight, int maxOutstandingTxns) {
        return ClientConnectionPool.getStatistics(ClientConnectionPool.getClientConnectionKeyBase(servers.split(","), port, user, password, isHeavyWeight, maxOutstandingTxns));
    }

    public static PerfCounterMap getStatistics(String[] servers, int port, String user, String password, boolean isHeavyWeight, int maxOutstandingTxns) {
        return ClientConnectionPool.getStatistics(ClientConnectionPool.getClientConnectionKeyBase(servers, port, user, password, isHeavyWeight, maxOutstandingTxns));
    }

    protected static PerfCounterMap getStatistics(String clientConnectionKeyBase) {
        if (!Statistics.containsKey(clientConnectionKeyBase)) {
            Statistics.put(clientConnectionKeyBase, new PerfCounterMap());
        }
        return Statistics.get(clientConnectionKeyBase);
    }

    private static String getClientConnectionKeyBase(String[] servers, int port, String user, String password, boolean isHeavyWeight, int maxOutstandingTxns) {
        String clientConnectionKeyBase = user + ":" + password + "@";
        for (int i = 0; i < servers.length; ++i) {
            clientConnectionKeyBase = clientConnectionKeyBase + servers[i].trim() + ",";
        }
        clientConnectionKeyBase = clientConnectionKeyBase + ":" + Integer.toString(port) + "{" + Boolean.toString(isHeavyWeight) + ":" + Integer.toString(maxOutstandingTxns) + "}";
        return clientConnectionKeyBase;
    }
}

