/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.jdbc;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.voltcore.utils.ssl.SSLConfiguration;
import org.voltdb.client.Client;
import org.voltdb.client.ClientConfig;
import org.voltdb.client.ClientFactory;
import org.voltdb.client.ClientImpl;
import org.voltdb.client.ClientResponse;
import org.voltdb.client.ClientStats;
import org.voltdb.client.ClientStatsContext;
import org.voltdb.client.NoConnectionsException;
import org.voltdb.client.ProcCallException;
import org.voltdb.client.ProcedureCallback;
import org.voltdb.jdbc.JDBC4ClientConnectionPool;
import org.voltdb.jdbc.JDBC4ExecutionFuture;

public class JDBC4ClientConnection
implements Closeable {
    private final ArrayList<String> servers;
    private final ClientConfig config;
    private AtomicReference<Client> client = new AtomicReference();
    protected final String keyBase;
    protected final String key;
    protected short users = 0;
    protected long defaultAsyncTimeout = 60000L;

    protected JDBC4ClientConnection(String clientConnectionKeyBase, String clientConnectionKey, String[] servers, String user, String password, boolean isHeavyWeight, int maxOutstandingTxns, boolean reconnectOnConnectionLoss) throws UnknownHostException, IOException {
        this(clientConnectionKeyBase, clientConnectionKey, servers, user, password, isHeavyWeight, maxOutstandingTxns, reconnectOnConnectionLoss, null, null);
    }

    protected JDBC4ClientConnection(String clientConnectionKeyBase, String clientConnectionKey, String[] servers, String user, String password, boolean isHeavyWeight, int maxOutstandingTxns, boolean reconnectOnConnectionLoss, SSLConfiguration.SslConfig sslConfig, String kerberosConfig) throws UnknownHostException, IOException {
        this.servers = new ArrayList(servers.length);
        for (String server : servers) {
            if ((server = server.trim()).isEmpty()) continue;
            this.servers.add(server);
        }
        if (this.servers.isEmpty()) {
            throw new UnknownHostException("JDBC4ClientConnection: no servers provided");
        }
        this.keyBase = clientConnectionKeyBase;
        this.key = clientConnectionKey;
        boolean enableSSL = sslConfig != null;
        this.config = new ClientConfig(user, password);
        this.config.setHeavyweight(isHeavyWeight);
        if (maxOutstandingTxns > 0) {
            this.config.setMaxOutstandingTxns(maxOutstandingTxns);
        }
        this.config.setReconnectOnConnectionLoss(reconnectOnConnectionLoss);
        if (enableSSL) {
            if (sslConfig.trustStorePath != null && sslConfig.trustStorePath.trim().length() > 0) {
                this.config.setTrustStore(sslConfig.trustStorePath, sslConfig.trustStorePassword);
            }
            this.config.enableSSL();
        }
        if (kerberosConfig != null) {
            this.config.enableKerberosAuthentication(kerberosConfig.trim());
        }
        this.createClientAndConnect();
    }

    private ClientImpl createClientAndConnect() throws UnknownHostException, IOException {
        ClientImpl clientTmp = (ClientImpl)ClientFactory.createClient(this.config);
        boolean connectedAnything = false;
        for (String server : this.servers) {
            try {
                clientTmp.createConnection(server);
                connectedAnything = true;
            }
            catch (UnknownHostException unknownHostException) {
            }
            catch (IOException iOException) {}
        }
        if (!connectedAnything) {
            try {
                clientTmp.close();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            throw new IOException("Unable to connect to VoltDB cluster with servers: " + this.servers);
        }
        this.client.set(clientTmp);
        this.users = (short)(this.users + 1);
        return clientTmp;
    }

    protected synchronized ClientImpl getClient() throws UnknownHostException, IOException {
        ClientImpl retClient = (ClientImpl)this.client.get();
        if (retClient != null) {
            return retClient;
        }
        return this.createClientAndConnect();
    }

    protected synchronized JDBC4ClientConnection use() {
        this.users = (short)(this.users + 1);
        return this;
    }

    protected synchronized void dispose() {
        this.users = (short)(this.users - 1);
        if (this.users == 0) {
            try {
                Client currentClient = this.client.get();
                if (currentClient != null) {
                    currentClient.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected synchronized void dropClient(ClientImpl clientToDrop) {
        Client currentClient = this.client.get();
        if (currentClient != null && currentClient == clientToDrop) {
            try {
                currentClient.close();
                this.client.set(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.users = 0;
    }

    @Override
    public void close() {
        JDBC4ClientConnectionPool.dispose(this);
    }

    public ClientResponse execute(String procedure, long timeout, TimeUnit unit, Object ... parameters) throws NoConnectionsException, IOException, ProcCallException {
        ClientImpl currentClient = this.getClient();
        if (unit == null) {
            unit = TimeUnit.SECONDS;
        }
        try {
            ClientResponse response = currentClient.callProcedureWithClientTimeout(-1, procedure, timeout, unit, parameters);
            return response;
        }
        catch (ProcCallException pce) {
            throw pce;
        }
        catch (NoConnectionsException e) {
            this.dropClient(currentClient);
            throw e;
        }
    }

    public boolean executeAsync(ProcedureCallback callback, String procedure, Object ... parameters) throws NoConnectionsException, IOException {
        ClientImpl currentClient = this.getClient();
        try {
            return currentClient.callProcedure((ProcedureCallback)new TrackingCallback(this, procedure, callback), procedure, parameters);
        }
        catch (NoConnectionsException e) {
            this.dropClient(currentClient);
            throw e;
        }
    }

    public Future<ClientResponse> executeAsync(String procedure, Object ... parameters) throws NoConnectionsException, IOException {
        ClientImpl currentClient = this.getClient();
        final JDBC4ExecutionFuture future = new JDBC4ExecutionFuture(this.defaultAsyncTimeout);
        try {
            currentClient.callProcedure((ProcedureCallback)new TrackingCallback(this, procedure, new ProcedureCallback(){
                final JDBC4ExecutionFuture result;
                {
                    this.result = future;
                }

                @Override
                public void clientCallback(ClientResponse response) throws Exception {
                    future.set(response);
                }
            }), procedure, parameters);
        }
        catch (NoConnectionsException e) {
            this.dropClient(currentClient);
            throw e;
        }
        return future;
    }

    public ClientStatsContext getClientStatsContext() {
        if (this.client.get() == null) {
            return null;
        }
        return this.client.get().createStatsContext();
    }

    public void saveStatistics(ClientStats stats, String file) throws IOException {
        this.client.get().writeSummaryCSV(stats, file);
    }

    void writeSummaryCSV(ClientStats stats, String path) throws IOException {
        if (this.client.get() == null) {
            throw new IOException("Client is unavailable for writing summary CSV.");
        }
        this.client.get().writeSummaryCSV(stats, path);
    }

    public void drain() throws InterruptedException, IOException {
        ClientImpl currentClient = this.getClient();
        if (currentClient == null) {
            throw new IOException("Client is unavailable for drain().");
        }
        currentClient.drain();
    }

    public void backpressureBarrier() throws InterruptedException, IOException {
        ClientImpl currentClient = this.getClient();
        if (currentClient == null) {
            throw new IOException("Client is unavailable for backpressureBarrier().");
        }
        currentClient.backpressureBarrier();
    }

    public ClientResponse updateApplicationCatalog(File catalogPath, File deploymentPath) throws IOException, NoConnectionsException, ProcCallException {
        ClientImpl currentClient = this.getClient();
        try {
            return currentClient.updateApplicationCatalog(catalogPath, deploymentPath);
        }
        catch (NoConnectionsException e) {
            this.dropClient(currentClient);
            throw e;
        }
    }

    private static class TrackingCallback
    implements ProcedureCallback {
        private final JDBC4ClientConnection Owner;
        private final String Procedure;
        private final ProcedureCallback UserCallback;

        public TrackingCallback(JDBC4ClientConnection owner, String procedure, ProcedureCallback userCallback) {
            this.Owner = owner;
            this.Procedure = procedure;
            this.UserCallback = userCallback;
        }

        @Override
        public void clientCallback(ClientResponse response) throws Exception {
            if (this.UserCallback != null) {
                this.UserCallback.clientCallback(response);
            }
        }
    }
}

