/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.jdbc;

import java.util.HashMap;
import org.voltcore.utils.ssl.SSLConfiguration;
import org.voltdb.jdbc.JDBC4ClientConnection;

public class JDBC4ClientConnectionPool {
    private static final HashMap<String, JDBC4ClientConnection> ClientConnections = new HashMap();

    private JDBC4ClientConnectionPool() {
    }

    public static JDBC4ClientConnection get(String[] servers, String user, String password, boolean isHeavyWeight, int maxOutstandingTxns, boolean reconnectOnConnectionLoss) throws Exception {
        return JDBC4ClientConnectionPool.get(servers, user, password, isHeavyWeight, maxOutstandingTxns, reconnectOnConnectionLoss, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JDBC4ClientConnection get(String[] servers, String user, String password, boolean isHeavyWeight, int maxOutstandingTxns, boolean reconnectOnConnectionLoss, SSLConfiguration.SslConfig sslConfig, String kerberosConfig) throws Exception {
        String clientConnectionKeyBase;
        String clientConnectionKey = clientConnectionKeyBase = JDBC4ClientConnectionPool.getClientConnectionKeyBase(servers, user, password, isHeavyWeight, maxOutstandingTxns, reconnectOnConnectionLoss);
        HashMap<String, JDBC4ClientConnection> hashMap = ClientConnections;
        synchronized (hashMap) {
            if (!ClientConnections.containsKey(clientConnectionKey)) {
                ClientConnections.put(clientConnectionKey, new JDBC4ClientConnection(clientConnectionKeyBase, clientConnectionKey, servers, user, password, isHeavyWeight, maxOutstandingTxns, reconnectOnConnectionLoss, sslConfig, kerberosConfig));
            }
            return ClientConnections.get(clientConnectionKey).use();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dispose(JDBC4ClientConnection connection) {
        HashMap<String, JDBC4ClientConnection> hashMap = ClientConnections;
        synchronized (hashMap) {
            connection.dispose();
            if (connection.users == 0) {
                ClientConnections.remove(connection.key);
            }
        }
    }

    private static String getClientConnectionKeyBase(String[] servers, String user, String password, boolean isHeavyWeight, int maxOutstandingTxns, boolean reconnectOnConnectionLoss) {
        String clientConnectionKeyBase = user + ":" + password + "@";
        for (int i = 0; i < servers.length; ++i) {
            clientConnectionKeyBase = clientConnectionKeyBase + servers[i].trim() + ",";
        }
        clientConnectionKeyBase = clientConnectionKeyBase + "{" + Boolean.toString(isHeavyWeight) + ":" + Integer.toString(maxOutstandingTxns) + ":" + Boolean.toString(reconnectOnConnectionLoss) + "}";
        return clientConnectionKeyBase;
    }
}

