/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.voltdb.VoltType;
import org.voltdb.jdbc.JDBC4Connection;
import org.voltdb.jdbc.JDBC4ParameterMetaData;
import org.voltdb.jdbc.JDBC4Statement;
import org.voltdb.jdbc.SQLError;

public class JDBC4PreparedStatement
extends JDBC4Statement
implements PreparedStatement {
    private final JDBC4Statement.VoltSQL Query;
    private Object[] parameters;
    private final JDBC4ParameterMetaData parameterMetaData;

    JDBC4PreparedStatement(JDBC4Connection connection, String sql) throws SQLException {
        super(connection);
        JDBC4Statement.VoltSQL query;
        this.Query = query = JDBC4Statement.VoltSQL.parseSQL(sql);
        this.parameters = this.Query.getParameterArray();
        this.parameterMetaData = new JDBC4ParameterMetaData(this, this.Query.getParameterCount());
    }

    protected JDBC4PreparedStatement(JDBC4Connection connection, String sql, boolean isCallableStatement) throws SQLException {
        super(connection);
        JDBC4Statement.VoltSQL query = null;
        if (isCallableStatement) {
            query = JDBC4Statement.VoltSQL.parseCall(sql);
            if (!query.isOfType(3)) {
                throw SQLError.get("s1010", sql);
            }
        } else {
            query = JDBC4Statement.VoltSQL.parseSQL(sql);
        }
        this.Query = query;
        this.parameters = this.Query.getParameterArray();
        this.parameterMetaData = new JDBC4ParameterMetaData(this, this.Query.getParameterCount());
    }

    protected synchronized void checkParameterBounds(int parameterIndex) throws SQLException {
        this.checkClosed();
        if (parameterIndex < 1 || parameterIndex > this.Query.getParameterCount()) {
            throw SQLError.get("42S23", parameterIndex, this.Query.getParameterCount());
        }
    }

    @Override
    public void addBatch() throws SQLException {
        this.checkClosed();
        if (this.Query.isOfType(3, 1)) {
            throw SQLError.get("s1010", this.Query.toSqlString());
        }
        this.addBatch(this.Query.getExecutableQuery(this.parameters));
        this.parameters = this.Query.getParameterArray();
    }

    @Override
    public void clearParameters() throws SQLException {
        this.checkClosed();
        this.parameters = this.Query.getParameterArray();
    }

    @Override
    public boolean execute() throws SQLException {
        this.checkClosed();
        boolean result = this.execute(this.Query.getExecutableQuery(this.parameters));
        this.parameters = this.Query.getParameterArray();
        return result;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.checkClosed();
        if (!this.Query.isOfType(3, 1)) {
            throw SQLError.get("s1010", this.Query.toSqlString());
        }
        ResultSet result = this.executeQuery(this.Query.getExecutableQuery(this.parameters));
        this.parameters = this.Query.getParameterArray();
        return result;
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.checkClosed();
        if (!this.Query.isOfType(3, 2)) {
            throw SQLError.get("s1010", this.Query.toSqlString());
        }
        int result = this.executeUpdate(this.Query.getExecutableQuery(this.parameters));
        this.parameters = this.Query.getParameterArray();
        return result;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.checkClosed();
        return this.parameterMetaData;
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        this.checkParameterBounds(parameterIndex);
        throw SQLError.noSupport();
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.checkParameterBounds(parameterIndex);
        throw SQLError.noSupport();
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkParameterBounds(parameterIndex);
        throw SQLError.noSupport();
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.checkParameterBounds(parameterIndex);
        throw SQLError.noSupport();
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.checkParameterBounds(parameterIndex);
        this.parameters[parameterIndex - 1] = x == null ? VoltType.NULL_DECIMAL : x;
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.checkParameterBounds(parameterIndex);
        throw SQLError.noSupport();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkParameterBounds(parameterIndex);
        throw SQLError.noSupport();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.checkParameterBounds(parameterIndex);
        throw SQLError.noSupport();
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.checkParameterBounds(parameterIndex);
        throw SQLError.noSupport();
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.checkParameterBounds(parameterIndex);
        throw SQLError.noSupport();
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.checkParameterBounds(parameterIndex);
        throw SQLError.noSupport();
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.checkParameterBounds(parameterIndex);
        throw SQLError.noSupport();
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.checkParameterBounds(parameterIndex);
        this.parameters[parameterIndex - 1] = x;
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.checkParameterBounds(parameterIndex);
        this.parameters[parameterIndex - 1] = x;
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.checkParameterBounds(parameterIndex);
        throw SQLError.noSupport();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.checkParameterBounds(parameterIndex);
        throw SQLError.noSupport();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.checkParameterBounds(parameterIndex);
        throw SQLError.noSupport();
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.checkParameterBounds(parameterIndex);
        throw SQLError.noSupport();
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.checkParameterBounds(parameterIndex);
        throw SQLError.noSupport();
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.checkParameterBounds(parameterIndex);
        throw SQLError.noSupport();
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.checkParameterBounds(parameterIndex);
        throw SQLError.noSupport();
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.checkParameterBounds(parameterIndex);
        throw SQLError.noSupport();
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.checkParameterBounds(parameterIndex);
        this.parameters[parameterIndex - 1] = x;
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.checkParameterBounds(parameterIndex);
        this.parameters[parameterIndex - 1] = (double)x;
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.checkParameterBounds(parameterIndex);
        this.parameters[parameterIndex - 1] = x;
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.checkParameterBounds(parameterIndex);
        this.parameters[parameterIndex - 1] = x;
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.checkParameterBounds(parameterIndex);
        throw SQLError.noSupport();
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.checkParameterBounds(parameterIndex);
        throw SQLError.noSupport();
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.checkParameterBounds(parameterIndex);
        throw SQLError.noSupport();
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.checkParameterBounds(parameterIndex);
        throw SQLError.noSupport();
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.checkParameterBounds(parameterIndex);
        throw SQLError.noSupport();
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.checkParameterBounds(parameterIndex);
        throw SQLError.noSupport();
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.checkParameterBounds(parameterIndex);
        switch (sqlType) {
            case -6: {
                this.parameters[parameterIndex - 1] = (byte)-128;
                break;
            }
            case 5: {
                this.parameters[parameterIndex - 1] = (short)Short.MIN_VALUE;
                break;
            }
            case 4: {
                this.parameters[parameterIndex - 1] = Integer.MIN_VALUE;
                break;
            }
            case -5: {
                this.parameters[parameterIndex - 1] = Long.MIN_VALUE;
                break;
            }
            case 8: {
                this.parameters[parameterIndex - 1] = -1.7E308;
                break;
            }
            case 3: {
                this.parameters[parameterIndex - 1] = VoltType.NULL_DECIMAL;
                break;
            }
            case 93: {
                this.parameters[parameterIndex - 1] = VoltType.NULL_TIMESTAMP;
                break;
            }
            case -9: 
            case -3: 
            case 0: 
            case 12: 
            case 1111: {
                this.parameters[parameterIndex - 1] = VoltType.NULL_STRING_OR_VARBINARY;
                break;
            }
            default: {
                throw SQLError.get("s1009");
            }
        }
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.setNull(parameterIndex, sqlType);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.checkParameterBounds(parameterIndex);
        this.parameters[parameterIndex - 1] = x;
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.checkParameterBounds(parameterIndex);
        switch (targetSqlType) {
            case -6: {
                this.setByte(parameterIndex, (Byte)x);
                break;
            }
            case 5: {
                this.setShort(parameterIndex, (Short)x);
                break;
            }
            case 4: {
                this.setInt(parameterIndex, (Integer)x);
                break;
            }
            case -5: {
                this.setLong(parameterIndex, (Long)x);
                break;
            }
            case 8: {
                this.setDouble(parameterIndex, (Double)x);
                break;
            }
            case 3: {
                this.setBigDecimal(parameterIndex, (BigDecimal)x);
                break;
            }
            case 93: {
                this.setTimestamp(parameterIndex, (Timestamp)x);
                break;
            }
            case -9: 
            case -3: 
            case 12: {
                this.setString(parameterIndex, (String)x);
                break;
            }
            case 1111: {
                this.setObject(parameterIndex, x);
                break;
            }
            default: {
                throw SQLError.get("s1009");
            }
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.checkParameterBounds(parameterIndex);
        throw SQLError.noSupport();
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        this.checkParameterBounds(parameterIndex);
        throw SQLError.noSupport();
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        this.checkParameterBounds(parameterIndex);
        throw SQLError.noSupport();
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.checkParameterBounds(parameterIndex);
        this.parameters[parameterIndex - 1] = x;
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.checkParameterBounds(parameterIndex);
        throw SQLError.noSupport();
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.checkParameterBounds(parameterIndex);
        this.parameters[parameterIndex - 1] = x == null ? VoltType.NULL_STRING_OR_VARBINARY : x;
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.checkParameterBounds(parameterIndex);
        throw SQLError.noSupport();
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.checkParameterBounds(parameterIndex);
        throw SQLError.noSupport();
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.checkParameterBounds(parameterIndex);
        this.parameters[parameterIndex - 1] = x == null ? VoltType.NULL_TIMESTAMP : x;
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.checkParameterBounds(parameterIndex);
        throw SQLError.noSupport();
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkParameterBounds(parameterIndex);
        throw SQLError.noSupport();
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.checkParameterBounds(parameterIndex);
        this.parameters[parameterIndex - 1] = x == null ? VoltType.NULL_STRING_OR_VARBINARY : x.toString();
    }
}

