/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.jdbc;

import java.io.IOException;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.voltdb.VoltTable;
import org.voltdb.VoltType;
import org.voltdb.client.ClientResponse;
import org.voltdb.client.ProcCallException;
import org.voltdb.jdbc.JDBC4ClientConnection;
import org.voltdb.jdbc.JDBC4Connection;
import org.voltdb.jdbc.JDBC4ResultSet;
import org.voltdb.jdbc.SQLError;
import org.voltdb.parser.JDBCParser;
import org.voltdb.parser.SQLLexer;

public class JDBC4Statement
implements Statement {
    private int m_timeout = Integer.MAX_VALUE;
    private ArrayList<VoltSQL> batch = null;
    protected boolean isClosed = false;
    private int fetchDirection = 1000;
    private int fetchSize = 0;
    private final int maxFieldSize = 0x100000;
    private int maxRows = 0x500000;
    protected JDBC4Connection sourceConnection;
    private boolean isPoolable = false;
    protected VoltTable[] tableResults = null;
    protected int tableResultIndex = -1;
    protected int lastUpdateCount = -1;
    protected Set<JDBC4ResultSet> openResults = new HashSet<JDBC4ResultSet>();
    protected JDBC4ResultSet result = null;

    public JDBC4Statement(JDBC4Connection connection) {
        this.sourceConnection = connection;
    }

    protected void checkClosed() throws SQLException {
        if (this.isClosed()) {
            throw SQLError.get("08003");
        }
    }

    private void closeCurrentResult() throws SQLException {
        this.lastUpdateCount = -1;
        if (this.result != null) {
            this.result.close();
        }
        this.result = null;
    }

    private JDBC4ResultSet createTrimmedResultSet(VoltTable input) throws SQLException {
        VoltTable result = input;
        if (this.maxRows > 0 && input.getRowCount() > this.maxRows) {
            VoltTable trimmed = new VoltTable(input.getTableSchema());
            input.resetRowPosition();
            for (int i = 0; i < this.maxRows; ++i) {
                input.advanceRow();
                trimmed.add(input.cloneRow());
            }
            result = trimmed;
        }
        return new JDBC4ResultSet(this, result);
    }

    private void setCurrentResult(VoltTable[] tables, int updateCount) throws SQLException {
        this.tableResults = tables;
        this.tableResultIndex = -1;
        this.lastUpdateCount = updateCount;
        if (this.result != null) {
            this.result.close();
        }
        if (this.tableResults == null || this.tableResults.length == 0) {
            return;
        }
        this.tableResultIndex = 0;
        this.result = this.createTrimmedResultSet(this.tableResults[this.tableResultIndex]);
    }

    private void closeAllOpenResults() throws SQLException {
        if (this.openResults != null) {
            for (JDBC4ResultSet element : this.openResults) {
                try {
                    element.close();
                }
                catch (SQLException sQLException) {}
            }
            this.openResults.clear();
        }
    }

    protected void addBatch(VoltSQL query) throws SQLException {
        if (this.batch == null) {
            this.batch = new ArrayList();
        }
        this.batch.add(query);
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.checkClosed();
        VoltSQL query = VoltSQL.parseSQL(sql);
        if (query.isOfType(1)) {
            throw SQLError.get("s1010", sql);
        }
        this.addBatch(query);
    }

    @Override
    public void cancel() throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public void clearBatch() throws SQLException {
        this.checkClosed();
        this.batch = null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkClosed();
    }

    @Override
    public void close() throws SQLException {
        this.isClosed = true;
    }

    protected boolean execute(VoltSQL query) throws SQLException {
        this.checkClosed();
        if (query.isQueryOfType(1, 3)) {
            this.setCurrentResult(query.execute(this.sourceConnection.NativeConnection, this.m_timeout, this.sourceConnection.queryTimeOutUnit), -1);
            return true;
        }
        this.setCurrentResult(null, (int)query.execute(this.sourceConnection.NativeConnection, this.m_timeout, this.sourceConnection.queryTimeOutUnit)[0].fetchRow(0).getLong(0));
        return false;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.checkClosed();
        VoltSQL query = VoltSQL.parseSQL(sql);
        return this.execute(query);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        int i;
        this.checkClosed();
        this.closeCurrentResult();
        if (this.batch == null || this.batch.size() == 0) {
            return new int[0];
        }
        int[] updateCounts = new int[this.batch.size()];
        int runningUpdateCount = 0;
        try {
            for (i = 0; i < this.batch.size(); ++i) {
                this.setCurrentResult(null, (int)this.batch.get(i).execute(this.sourceConnection.NativeConnection, this.m_timeout, this.sourceConnection.queryTimeOutUnit)[0].fetchRow(0).getLong(0));
                updateCounts[i] = this.lastUpdateCount;
                runningUpdateCount += this.lastUpdateCount;
            }
        }
        catch (SQLException x) {
            updateCounts[i] = -3;
            throw new BatchUpdateException(Arrays.copyOf(updateCounts, i + 1), (Throwable)x);
        }
        finally {
            this.clearBatch();
        }
        this.lastUpdateCount = runningUpdateCount;
        return updateCounts;
    }

    protected ResultSet executeQuery(VoltSQL query) throws SQLException {
        this.setCurrentResult(query.execute(this.sourceConnection.NativeConnection, this.m_timeout, this.sourceConnection.queryTimeOutUnit), -1);
        return this.result;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.checkClosed();
        VoltSQL query = VoltSQL.parseSQL(sql);
        if (!query.isOfType(1)) {
            throw SQLError.get("s1010", sql);
        }
        return this.executeQuery(query);
    }

    protected int executeUpdate(VoltSQL query) throws SQLException {
        this.setCurrentResult(null, (int)query.execute(this.sourceConnection.NativeConnection, this.m_timeout, this.sourceConnection.queryTimeOutUnit)[0].fetchRow(0).getLong(0));
        return this.lastUpdateCount;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.checkClosed();
        VoltSQL query = VoltSQL.parseSQL(sql);
        if (query.isOfType(1)) {
            throw SQLError.get("s1010", sql);
        }
        return this.executeUpdate(query);
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.checkClosed();
        return this.sourceConnection;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkClosed();
        return this.fetchDirection;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkClosed();
        return this.fetchSize;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.checkClosed();
        return this.maxFieldSize;
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.checkClosed();
        return this.maxRows;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.checkClosed();
        switch (current) {
            case 2: {
                this.openResults.add(this.result);
                this.result = null;
                this.lastUpdateCount = -1;
                break;
            }
            case 1: {
                this.closeCurrentResult();
                break;
            }
            case 3: {
                this.closeCurrentResult();
                this.closeAllOpenResults();
                break;
            }
            default: {
                throw SQLError.get("s1009", current);
            }
        }
        if (current != 3) {
            ++this.tableResultIndex;
            if (this.tableResultIndex < this.tableResults.length) {
                VoltTable table = this.tableResults[this.tableResultIndex];
                if (VoltSQL.isUpdateResult(table)) {
                    this.lastUpdateCount = (int)table.fetchRow(0).getLong(0);
                } else {
                    this.result = this.createTrimmedResultSet(table);
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.checkClosed();
        return this.m_timeout;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkClosed();
        return this.result;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.checkClosed();
        return 1007;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.checkClosed();
        return 1004;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.checkClosed();
        return this.lastUpdateCount;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.checkClosed();
        return this.isPoolable;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkClosed();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkClosed();
        if (direction != 1000 && direction != 1001 && direction != 1002) {
            throw SQLError.get("s1009", direction);
        }
        this.fetchDirection = direction;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkClosed();
        if (rows < 0) {
            throw SQLError.get("s1009", rows);
        }
        this.fetchSize = rows;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.checkClosed();
        if (max < 0) {
            throw SQLError.get("s1009", max);
        }
        throw SQLError.noSupport();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.checkClosed();
        if (max < 0) {
            throw SQLError.get("s1009", max);
        }
        this.maxRows = max;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.checkClosed();
        this.isPoolable = poolable;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.checkClosed();
        if (seconds < 0) {
            throw SQLError.get("s1009", seconds);
        }
        this.m_timeout = seconds == 0 ? Integer.MAX_VALUE : seconds;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return iface.cast(this);
        }
        catch (ClassCastException cce) {
            throw SQLError.get("s1009", iface.toString());
        }
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw SQLError.noSupport();
    }

    static class VoltSQL {
        public static final byte TYPE_SELECT = 1;
        public static final byte TYPE_UPDATE = 2;
        public static final byte TYPE_EXEC = 3;
        private final String[] sql;
        private final int parameterCount;
        private final byte type;
        private final byte queryType;
        private final Object[] parameters;

        private VoltSQL(String[] sql, int parameterCount, byte type) {
            this.sql = sql;
            this.parameterCount = parameterCount;
            this.type = this.queryType = type;
            this.parameters = null;
        }

        private VoltSQL(String[] sql, int parameterCount, byte type, Object[] parameters) {
            this(sql, parameterCount, type, type, parameters);
        }

        private VoltSQL(String[] sql, int parameterCount, byte type, byte queryType, Object[] parameters) {
            this.sql = sql;
            this.parameterCount = parameterCount;
            this.type = type;
            this.queryType = queryType;
            this.parameters = parameters;
        }

        public boolean hasParameters() {
            return this.parameterCount > 0;
        }

        public Object[] getParameterArray() throws SQLException {
            return new Object[this.parameterCount];
        }

        public int getParameterCount() {
            return this.parameterCount;
        }

        public boolean isOfType(int ... types) {
            for (int i = 0; i < types.length; ++i) {
                if (this.type != types[i]) continue;
                return true;
            }
            return false;
        }

        public boolean isQueryOfType(int ... types) {
            for (int i = 0; i < types.length; ++i) {
                if (this.queryType != types[i]) continue;
                return true;
            }
            return false;
        }

        protected VoltTable[] execute(JDBC4ClientConnection connection, long timeout, TimeUnit queryTimeOutUnit) throws SQLException {
            try {
                if (this.type == 3) {
                    return connection.execute(this.sql[0], timeout, queryTimeOutUnit, this.parameters).getResults();
                }
                return connection.execute("@AdHoc", timeout, queryTimeOutUnit, this.sql[0]).getResults();
            }
            catch (ProcCallException e) {
                ClientResponse response = e.getClientResponse();
                if (response != null) {
                    switch (response.getStatus()) {
                        case -4: {
                            throw SQLError.get(e, "08003", "CONNECTION_LOST", e.getMessage());
                        }
                        case -6: {
                            throw SQLError.get(e, "08006", "CONNECTION_TIMEOUT", e.getMessage());
                        }
                        case -5: {
                            throw SQLError.get(e, "08006", "CONNECTION_UNAVAILABLE", e.getMessage());
                        }
                        case -1: {
                            throw SQLError.get(e, "s1000", "USER_ABORT", e.getMessage());
                        }
                        case -3: {
                            throw SQLError.get(e, "s1000", "UNEXPECTED_FAILURE", e.getMessage());
                        }
                        case -2: {
                            throw SQLError.get(e, "s1000", "GRACEFUL_FAILURE", e.getMessage());
                        }
                    }
                    throw SQLError.get(e, "s1000", String.format("status=%d", response.getStatus()), e.getMessage());
                }
                throw SQLError.get(e, "s1000", e.getMessage());
            }
            catch (IOException e) {
                throw SQLError.get(e, "08006", e.getMessage());
            }
        }

        public static boolean isUpdateResult(VoltTable table) {
            return (table.getColumnName(0).length() == 0 || table.getColumnName(0).equals("modified_tuples")) && table.getRowCount() == 1 && table.getColumnCount() == 1 && table.getColumnType(0) == VoltType.BIGINT;
        }

        public String toSqlString() {
            return this.sql[0];
        }

        public VoltSQL getExecutableQuery(Object ... params) throws SQLException {
            if (params.length != this.parameterCount) {
                throw SQLError.get("s1009");
            }
            if (this.type == 3) {
                return new VoltSQL(this.sql, this.parameterCount, this.type, params);
            }
            Object[] paramsOut = new Object[params.length + 1];
            paramsOut[0] = this.sql[0];
            for (int i = 0; i < params.length; ++i) {
                paramsOut[i + 1] = params[i];
            }
            return new VoltSQL(new String[]{"@AdHoc"}, this.parameterCount, 3, this.type, paramsOut);
        }

        public static VoltSQL parseCall(String jdbcCall) throws SQLException {
            JDBCParser.ParsedCall parsedCall = JDBCParser.parseJDBCCall(jdbcCall);
            if (parsedCall == null) {
                throw SQLError.get("s1010");
            }
            return new VoltSQL(new String[]{parsedCall.sql}, parsedCall.parameterCount, 3);
        }

        public static VoltSQL parseSQL(String queryIn) throws SQLException {
            if (queryIn == null || queryIn.length() == 0) {
                throw SQLError.get("s1010");
            }
            String query = queryIn.trim();
            if (query.length() == 0) {
                throw SQLError.get("s1010");
            }
            byte type = 2;
            if (SQLLexer.isSelect(query)) {
                type = 1;
            }
            if (!query.endsWith(";")) {
                query = query + ";";
            }
            int parameterCount = 0;
            if (query.indexOf("?") > -1) {
                String[] queryParts = (query + ";").split("\\?");
                parameterCount = queryParts.length - 1;
            }
            return new VoltSQL(new String[]{query}, parameterCount, type);
        }
    }
}

