/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.jdbc;

import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import org.voltdb.jdbc.Resources;

public class SQLError {
    public static final String CONNECTION_UNSUCCESSFUL = "08001";
    public static final String CONNECTION_CLOSED = "08003";
    public static final String CONNECTION_FAILURE = "08006";
    public static final String GENERAL_ERROR = "s1000";
    public static final String ILLEGAL_ARGUMENT = "s1009";
    public static final String ILLEGAL_STATEMENT = "s1010";
    public static final String QUERY_PARSING_ERROR = "s1011";
    public static final String INVALID_QUERY_TYPE = "s1012";
    public static final String UNTERMINATED_STRING = "22024";
    public static final String COLUMN_NOT_FOUND = "42S22";
    public static final String PARAMETER_NOT_FOUND = "42S23";
    public static final String CONVERSION_NOT_FOUND = "42S72";
    public static final String TRANSLATION_NOT_FOUND = "42S82";

    public static SQLException get(String sqlState) {
        return new SQLException(Resources.getString("SQLState." + sqlState), sqlState);
    }

    public static SQLException get(String sqlState, Object ... args) {
        return new SQLException(Resources.getString("SQLState." + sqlState + "." + args.length, args), sqlState);
    }

    public static SQLException get(Throwable cause) {
        return new SQLException(GENERAL_ERROR, cause);
    }

    public static SQLException get(Throwable cause, String sqlState) {
        return new SQLException(Resources.getString("SQLState." + sqlState), sqlState, cause);
    }

    public static SQLException get(Throwable cause, String sqlState, Object ... args) {
        return new SQLException(Resources.getString("SQLState." + sqlState + "." + args.length, args), sqlState, cause);
    }

    public static SQLException noSupport() {
        return new SQLFeatureNotSupportedException();
    }

    public static boolean isConnectionError(String status) {
        return status.equals(CONNECTION_UNSUCCESSFUL) || status.equals(CONNECTION_CLOSED) || status.equals(CONNECTION_FAILURE);
    }
}

