/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.parser;

import com.google_voltpatches.common.collect.ImmutableMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.voltdb.parser.SQLLexer;
import org.voltdb.parser.SQLPatternFactory;
import org.voltdb.parser.SQLPatternPart;
import org.voltdb.parser.SQLPatternPartElement;
import org.voltdb.parser.SQLPatternPartString;
import org.voltdb.types.GeographyPointValue;
import org.voltdb.types.GeographyValue;
import org.voltdb.types.TimestampType;
import org.voltdb.utils.Encoder;

public class SQLParser
extends SQLPatternFactory {
    private static final Pattern SET_GLOBAL_PARAM = Pattern.compile("(?i)\\ASET\\s+([\\w_]+)\\s*=\\s*([\\w_]+)\\s*;\\z");
    static final Pattern SET_GLOBAL_PARAM_FOR_WHITELIST = Pattern.compile("(?i)\\ASET\\s+.*\\z");
    private static final Pattern PAT_PARTITION_ANY_PREAMBLE = SQLPatternFactory.SPF.statement(SQLPatternFactory.SPF.token("partition"), SQLPatternFactory.SPF.capture(SQLPatternFactory.SPF.tokenAlternatives("procedure", "table")), SQLPatternFactory.SPF.anyClause()).compile("PAT_PARTITION_ANY_PREAMBLE");
    private static final Pattern PAT_PARTITION_TABLE = SQLPatternFactory.SPF.statement(SQLPatternFactory.SPF.token("partition"), SQLPatternFactory.SPF.token("table"), SQLPatternFactory.SPF.capture(SQLPatternFactory.SPF.databaseObjectName()), SQLPatternFactory.SPF.token("on"), SQLPatternFactory.SPF.token("column"), SQLPatternFactory.SPF.capture(SQLPatternFactory.SPF.databaseObjectName())).compile("PAT_PARTITION_TABLE");
    private static final Pattern PAT_CREATE_EXPORT_TABLE = SQLPatternFactory.SPF.statement(SQLPatternFactory.SPF.token("create"), SQLPatternFactory.SPF.token("table"), SQLPatternFactory.SPF.capture("tableName", SQLPatternFactory.SPF.databaseObjectName()), SQLPatternFactory.SPF.token("export"), SQLPatternFactory.SPF.token("to"), SQLPatternFactory.SPF.token("target"), SQLPatternFactory.SPF.capture("migrateTargetName", SQLPatternFactory.SPF.databaseObjectName()), SQLPatternFactory.SPF.optional(SQLPatternFactory.SPF.clause(SQLPatternFactory.SPF.token("on"), SQLPatternFactory.SPF.group(true, SQLPatternFactory.SPF.commaList(SQLPatternFactory.SPF.userName())))), new SQLPatternPartString("\\s*"), SQLPatternFactory.SPF.anyColumnFields().withFlags(ADD_LEADING_SPACE_TO_CHILD), SQLPatternFactory.SPF.anythingOrNothing().withFlags(ADD_LEADING_SPACE_TO_CHILD)).compile("PAT_CREATE_EXPORT_TABLE");
    private static final Pattern PAT_CREATE_TABLE = SQLPatternFactory.SPF.statement(SQLPatternFactory.SPF.token("create"), SQLPatternFactory.SPF.token("table"), SQLPatternFactory.SPF.capture("tableName", SQLPatternFactory.SPF.databaseObjectName()), SQLPatternFactory.SPF.optional(SQLPatternFactory.SPF.clause(SQLPatternFactory.SPF.token("migrate"), SQLPatternFactory.SPF.token("to"), SQLPatternFactory.SPF.token("target"), SQLPatternFactory.SPF.capture("migrateTargetName", SQLPatternFactory.SPF.databaseObjectName()))), new SQLPatternPartString("\\s*"), SQLPatternFactory.SPF.anyColumnFields().withFlags(ADD_LEADING_SPACE_TO_CHILD), SQLPatternFactory.SPF.anythingOrNothing().withFlags(ADD_LEADING_SPACE_TO_CHILD)).compile("PAT_CREATE_TABLE");
    private static final Pattern PAT_ALTER_TTL = SQLPatternFactory.SPF.statement(SQLPatternFactory.SPF.token("alter"), SQLPatternFactory.SPF.token("table"), SQLPatternFactory.SPF.capture("name", SQLPatternFactory.SPF.databaseObjectName()), SQLPatternFactory.SPF.token("using"), SQLPatternFactory.SPF.token("TTL"), SQLPatternFactory.SPF.anythingOrNothing()).compile("PAT_ALTER_TTL");
    private static final Pattern PAT_PARTITION_PROCEDURE = SQLPatternFactory.SPF.statement(SQLPatternFactory.SPF.token("partition"), SQLPatternFactory.SPF.token("procedure"), SQLPatternFactory.SPF.capture(SQLPatternFactory.SPF.procedureName()), SQLPatternFactory.SPF.token("on"), SQLPatternFactory.SPF.token("table"), SQLPatternFactory.SPF.capture(SQLPatternFactory.SPF.databaseObjectName()), SQLPatternFactory.SPF.token("column"), SQLPatternFactory.SPF.capture(SQLPatternFactory.SPF.databaseObjectName()), SQLPatternFactory.SPF.optional(SQLPatternFactory.SPF.clause(SQLPatternFactory.SPF.token("parameter"), SQLPatternFactory.SPF.capture(SQLPatternFactory.SPF.integer())))).compile("PAT_PARTITION_PROCEDURE");
    private static final Pattern PAT_CREATE_PROCEDURE_FROM_CLASS = SQLPatternFactory.SPF.statement(SQLPatternFactory.SPF.token("create"), SQLPatternFactory.SPF.token("procedure"), SQLParser.unparsedProcedureModifierClauses(), SQLPatternFactory.SPF.token("from"), SQLPatternFactory.SPF.token("class"), SQLPatternFactory.SPF.capture(SQLPatternFactory.SPF.className())).compile("PAT_CREATE_PROCEDURE_FROM_CLASS");
    private static final Pattern PAT_CREATE_PROCEDURE_FROM_SQL = SQLPatternFactory.SPF.statement(SQLPatternFactory.SPF.token("create"), SQLPatternFactory.SPF.token("procedure"), SQLPatternFactory.SPF.capture(SQLPatternFactory.SPF.procedureName()), SQLParser.unparsedProcedureModifierClauses(), SQLPatternFactory.SPF.token("as"), SQLPatternFactory.SPF.capture(SQLPatternFactory.SPF.anyClause())).compile("PAT_CREATE_PROCEDURE_FROM_SQL");
    private static final Pattern PAT_CREATE_MULTI_STMT_PROCEDURE_FROM_SQL = SQLPatternFactory.SPF.statement(SQLPatternFactory.SPF.token("create"), SQLPatternFactory.SPF.token("procedure"), SQLPatternFactory.SPF.capture(SQLPatternFactory.SPF.procedureName()), SQLParser.unparsedProcedureModifierClauses(), SQLPatternFactory.SPF.token("as"), SQLPatternFactory.SPF.token("begin"), SQLPatternFactory.SPF.capture(SQLPatternFactory.SPF.anyClause())).compile("PAT_CREATE_MULTI_STMT_PROCEDURE_FROM_SQL");
    private static final Pattern PAT_CREATE_FUNCTION_FROM_METHOD = SQLPatternFactory.SPF.statement(SQLPatternFactory.SPF.token("create"), SQLPatternFactory.SPF.token("function"), SQLPatternFactory.SPF.capture(SQLPatternFactory.SPF.functionName()), SQLPatternFactory.SPF.token("from"), SQLPatternFactory.SPF.token("method"), SQLPatternFactory.SPF.capture(SQLPatternFactory.SPF.classPath()), SQLPatternFactory.SPF.dot().withFlags(ADD_LEADING_SPACE_TO_CHILD), SQLPatternFactory.SPF.capture(SQLPatternFactory.SPF.functionName().withFlags(ADD_LEADING_SPACE_TO_CHILD))).compile("PAT_CREATE_FUNCTION_FROM_METHOD");
    private static final Pattern PAT_CREATE_AGGREGATE_FUNCTION_FROM_CLASS = SQLPatternFactory.SPF.statement(SQLPatternFactory.SPF.token("create"), SQLPatternFactory.SPF.token("aggregate"), SQLPatternFactory.SPF.token("function"), SQLPatternFactory.SPF.capture(SQLPatternFactory.SPF.functionName()), SQLPatternFactory.SPF.token("from"), SQLPatternFactory.SPF.token("class"), SQLPatternFactory.SPF.capture(SQLPatternFactory.SPF.classPath())).compile("PAT_CREATE_AGGREGATE_FUNCTION_FROM_CLASS");
    private static final Pattern PAT_DROP_AGGREGATE_FUNCTION = SQLPatternFactory.SPF.statement(SQLPatternFactory.SPF.token("drop"), SQLPatternFactory.SPF.token("aggregate"), SQLPatternFactory.SPF.token("function"), SQLPatternFactory.SPF.capture(SQLPatternFactory.SPF.functionName()), SQLPatternFactory.SPF.optional(SQLPatternFactory.SPF.capture(SQLPatternFactory.SPF.clause(SQLPatternFactory.SPF.token("if"), SQLPatternFactory.SPF.token("exists"))))).compile("PAT_DROP_AGGREGATE_FUNCTION");
    private static final Pattern PAT_DROP_FUNCTION = SQLPatternFactory.SPF.statement(SQLPatternFactory.SPF.token("drop"), SQLPatternFactory.SPF.token("function"), SQLPatternFactory.SPF.capture(SQLPatternFactory.SPF.functionName()), SQLPatternFactory.SPF.ifExisits()).compile("PAT_DROP_FUNCTION");
    private static final Pattern PAT_CREATE_PROCEDURE_AS_SCRIPT = SQLPatternFactory.SPF.statement(SQLPatternFactory.SPF.token("create"), SQLPatternFactory.SPF.token("procedure"), SQLPatternFactory.SPF.capture(SQLPatternFactory.SPF.procedureName()), SQLParser.unparsedProcedureModifierClauses(), SQLPatternFactory.SPF.token("as"), SQLPatternFactory.SPF.delimitedCaptureBlock("###", null), SQLPatternFactory.SPF.oneOf(SQLPatternFactory.SPF.clause(SQLPatternFactory.SPF.token("language"), SQLPatternFactory.SPF.capture(SQLPatternFactory.SPF.languageName())), SQLPatternFactory.SPF.anyClause())).compile("PAT_CREATE_PROCEDURE_AS_SCRIPT");
    private static final Pattern PAT_ANY_CREATE_PROCEDURE_STATEMENT_CLAUSE = SQLParser.parsedProcedureModifierClause().compile("PAT_ANY_CREATE_PROCEDURE_STATEMENT_CLAUSE");
    private static final Pattern PAT_ANY_CREATE_STREAM_STATEMENT_CLAUSE = SQLParser.parsedStreamModifierClause().compile("PAT_ANY_CREATE_STREAM_STATEMENT_CLAUSE");
    private static final Pattern PAT_DROP_PROCEDURE = Pattern.compile("(?i)\\ADROP\\s+PROCEDURE\\s+([\\w$.]+)(\\s+IF EXISTS)?\\s*;\\z");
    private static final Pattern PAT_CREATE_ROLE = Pattern.compile("(?i)\\ACREATE\\s+ROLE\\s+([\\w.$]+)(?:\\s+WITH\\s+(\\w+(?:\\s*,\\s*\\w+)*))?;\\z");
    private static final Pattern PAT_DROP_ROLE = Pattern.compile("(?i)\\ADROP\\s+ROLE\\s+([\\w.$]+)(\\s+IF EXISTS)?;\\z");
    private static final Pattern PAT_DROP_STREAM = SQLPatternFactory.SPF.statementLeader(SQLPatternFactory.SPF.token("drop"), SQLPatternFactory.SPF.token("stream"), SQLPatternFactory.SPF.capture("name", SQLPatternFactory.SPF.databaseObjectName()), SQLPatternFactory.SPF.optional(SQLPatternFactory.SPF.clause(SQLPatternFactory.SPF.token("if"), SQLPatternFactory.SPF.token("exists")))).compile("PAT_DROP_STREAM");
    private static final Pattern PAT_CREATE_TASK = SQLPatternFactory.SPF.statement(SQLPatternFactory.SPF.token("create"), SQLPatternFactory.SPF.token("task"), SQLPatternFactory.SPF.capture("name", SQLPatternFactory.SPF.databaseObjectName()), SQLPatternFactory.SPF.oneOf(SQLPatternFactory.SPF.clause(SQLPatternFactory.SPF.token("from"), SQLPatternFactory.SPF.token("class"), SQLPatternFactory.SPF.capture("class", SQLPatternFactory.SPF.className())), SQLPatternFactory.SPF.clause(SQLPatternFactory.SPF.token("on"), SQLPatternFactory.SPF.token("SCHEDULE"), SQLPatternFactory.SPF.oneOf(SQLPatternFactory.SPF.clause(SQLPatternFactory.SPF.capture("intervalSchedule", SQLPatternFactory.SPF.oneOf("delay", "every")), SQLPatternFactory.SPF.capture("interval", SQLPatternFactory.SPF.integer()), SQLPatternFactory.SPF.capture("timeUnit", SQLPatternFactory.SPF.oneOf("milliseconds", "seconds", "minutes", "hours", "days"))), SQLPatternFactory.SPF.clause(SQLPatternFactory.SPF.token("cron"), SQLPatternFactory.SPF.capture("cron", SQLPatternFactory.SPF.clause(SQLPatternFactory.SPF.token("[0-9\\*\\-,/]+").withFlags(ADD_LEADING_SPACE_TO_CHILD), SQLPatternFactory.SPF.repeat(5, 5, SQLPatternFactory.SPF.token("[\\w\\*\\?\\-,/#]+"))).withFlags(ADD_LEADING_SPACE_TO_CHILD))), SQLPatternFactory.SPF.clause(SQLPatternFactory.SPF.token("from"), SQLPatternFactory.SPF.token("class"), SQLPatternFactory.SPF.capture("scheduleClass", SQLPatternFactory.SPF.className()), SQLPatternFactory.SPF.optional(SQLPatternFactory.SPF.clause(SQLPatternFactory.SPF.token("with"), SQLPatternFactory.SPF.token("\\(\\s*"), SQLPatternFactory.SPF.capture("scheduleParameters", SQLPatternFactory.SPF.commaList(SQLPatternFactory.SPF.token(".+"))).withFlags(ADD_LEADING_SPACE_TO_CHILD), SQLPatternFactory.SPF.token("\\s*\\)").withFlags(ADD_LEADING_SPACE_TO_CHILD))))), SQLPatternFactory.SPF.token("procedure"), SQLPatternFactory.SPF.oneOf(SQLPatternFactory.SPF.capture("procedure", SQLPatternFactory.SPF.token("@?[\\w.$]+")), SQLPatternFactory.SPF.clause(SQLPatternFactory.SPF.token("from"), SQLPatternFactory.SPF.token("class"), SQLPatternFactory.SPF.capture("generatorClass", SQLPatternFactory.SPF.className()))))), SQLPatternFactory.SPF.optional(SQLPatternFactory.SPF.clause(SQLPatternFactory.SPF.token("with"), SQLPatternFactory.SPF.token("\\(\\s*"), SQLPatternFactory.SPF.capture("parameters", SQLPatternFactory.SPF.commaList(SQLPatternFactory.SPF.token(".+"))).withFlags(ADD_LEADING_SPACE_TO_CHILD), SQLPatternFactory.SPF.token("\\s*\\)").withFlags(ADD_LEADING_SPACE_TO_CHILD))), SQLPatternFactory.SPF.optional(SQLPatternFactory.SPF.clause(SQLPatternFactory.SPF.token("on"), SQLPatternFactory.SPF.token("error"), SQLPatternFactory.SPF.capture("onError", SQLPatternFactory.SPF.oneOf(SQLPatternFactory.SPF.token("stop"), SQLPatternFactory.SPF.token("log"), SQLPatternFactory.SPF.token("ignore"))))), SQLPatternFactory.SPF.optional(SQLPatternFactory.SPF.clause(SQLPatternFactory.SPF.token("run"), SQLPatternFactory.SPF.token("on"), SQLPatternFactory.SPF.capture("scope", SQLPatternFactory.SPF.oneOf("database", "hosts", "partitions")))), SQLPatternFactory.SPF.optional(SQLPatternFactory.SPF.clause(SQLPatternFactory.SPF.token("as"), SQLPatternFactory.SPF.token("user"), SQLPatternFactory.SPF.capture("asUser", SQLPatternFactory.SPF.userName()))), SQLPatternFactory.SPF.optional(SQLPatternFactory.SPF.oneOf(SQLPatternFactory.SPF.capture("disabled", SQLPatternFactory.SPF.token("disable")), SQLPatternFactory.SPF.token("enable")))).compile("PAT_CREATE_TASK");
    private static final Pattern PAT_DROP_TASK = SQLPatternFactory.SPF.statement(SQLPatternFactory.SPF.token("drop"), SQLPatternFactory.SPF.token("task"), SQLPatternFactory.SPF.capture("name", SQLPatternFactory.SPF.databaseObjectName()), SQLPatternFactory.SPF.ifExisits()).compile("PAT_DROP_TASK");
    private static final Pattern PAT_ALTER_TASK = SQLPatternFactory.SPF.statement(SQLPatternFactory.SPF.token("alter"), SQLPatternFactory.SPF.token("task"), SQLPatternFactory.SPF.capture("name", SQLPatternFactory.SPF.databaseObjectName()), SQLPatternFactory.SPF.optional(SQLPatternFactory.SPF.capture("action", SQLPatternFactory.SPF.oneOf("enable", "disable"))), SQLPatternFactory.SPF.optional(SQLPatternFactory.SPF.clause(SQLPatternFactory.SPF.token("on"), SQLPatternFactory.SPF.token("error"), SQLPatternFactory.SPF.capture("onError", SQLPatternFactory.SPF.oneOf(SQLPatternFactory.SPF.token("stop"), SQLPatternFactory.SPF.token("log"), SQLPatternFactory.SPF.token("ignore")))))).compile("PAT_ALTER_TASK");
    private static final Pattern PAT_REPLICATE_TABLE = Pattern.compile("(?i)\\AREPLICATE\\s+TABLE\\s+([\\w$]+)\\s*;\\z");
    private static final Pattern PAT_CREATE_STREAM = SQLPatternFactory.SPF.statement(SQLPatternFactory.SPF.token("create"), SQLPatternFactory.SPF.token("stream"), SQLPatternFactory.SPF.capture("name", SQLPatternFactory.SPF.databaseObjectName()), SQLParser.unparsedStreamModifierClauses(), new SQLPatternPartString("\\s*"), SQLPatternFactory.SPF.anyColumnFields().withFlags(ADD_LEADING_SPACE_TO_CHILD)).compile("PAT_CREATE_STREAM");
    private static final Pattern PAT_ALL_VOLTDB_STATEMENT_PREAMBLES = Pattern.compile("(?i)((?<=\\ACREATE\\s{0,1024})(?:PROCEDURE|ROLE|FUNCTION|TASK|AGGREGATE)|\\ADROP|\\APARTITION|\\AREPLICATE|\\AIMPORT|\\ADR|\\ASET|\\AALTER\\s+TASK)\\s");
    private static final Pattern PAT_DR_TABLE = Pattern.compile("(?i)\\ADR\\s+TABLE\\s+([\\w.$|\\\\*]+)(?:\\s+(DISABLE))?\\s*;\\z");
    private static final String EndOfLineCommentPatternString = "(?:\\/\\/|--).*$";
    private static final Pattern OneWholeLineComment = Pattern.compile("^\\s*(?:\\/\\/|--).*$");
    public static final Pattern AnyWholeLineComments = Pattern.compile("^\\s*(?:\\/\\/|--).*$", 8);
    public static final Pattern EndOfLineComment = Pattern.compile("(?:\\/\\/|--).*$", 8);
    private static final Pattern OneWhitespace = Pattern.compile("\\s");
    private static final Pattern SingleQuotedString = Pattern.compile("'[^']*'", 8);
    private static final Pattern SingleQuotedStringContainingParameterSeparators = Pattern.compile("'[^',\\s]*[,\\s][^']*'", 8);
    private static final Pattern SingleQuotedHexLiteral = Pattern.compile("[Xx]'([0-9A-Fa-f]*)'", 8);
    private static String InitiallyForgivingDirectiveTermination = "\\s*([^;\\s]*)[;\\s]*(.*)$";
    private static final Pattern HelpToken = Pattern.compile("^\\s*help(\\W|$)\\s*([^;\\s]*)" + InitiallyForgivingDirectiveTermination, 2);
    private static final Pattern EchoToken = Pattern.compile("^\\s*echo(\\W|$)(.*)$", 2);
    private static final Pattern EchoErrorToken = Pattern.compile("^\\s*echoerror(\\W|$)(.*)$", 2);
    private static final Pattern ExitToken = Pattern.compile("^\\s*(?:exit|quit)(\\W|$)" + InitiallyForgivingDirectiveTermination, 2);
    private static final Pattern ShowToken = Pattern.compile("^\\s*(?:list|show)(\\W|$)\\s*([^;\\s]*)" + InitiallyForgivingDirectiveTermination, 2);
    private static final Pattern DescribeToken = Pattern.compile("^\\s*(?:desc|describe)(\\W|$)\\s*([^;\\s]*)" + InitiallyForgivingDirectiveTermination, 2);
    private static final Pattern RecallToken = Pattern.compile("^\\s*recall(\\W|$)\\s*([^;\\s]*)" + InitiallyForgivingDirectiveTermination, 2);
    private static final Pattern SemicolonToken = Pattern.compile("^.*;+\\s*(--)?$", 2);
    private static final Pattern FileToken = Pattern.compile("^\\s*file(?:(?=\\s|;)|$)", 2);
    private static final Pattern DashBatchToken = Pattern.compile("\\s+-batch", 2);
    private static final Pattern DashInlineBatchToken = Pattern.compile("\\s+-inlinebatch", 2);
    private static final Pattern FilenameToken = Pattern.compile("\\s*['\"]*([^;'\"]+)['\"]*\\s*;*\\s*", 2);
    private static final Pattern DelimiterToken = Pattern.compile("\\s+([^\\s;]+)\\s*;?\\s*", 2);
    private static final Pattern QueryStatsToken = Pattern.compile("^\\s*querystats(\\W|$)\\s*([^;\\s]*)" + InitiallyForgivingDirectiveTermination, 2);
    private static final Pattern ExecuteCallPreamble = Pattern.compile("^\\s*(?:exec|execute)(\\W|$)\\s*", 10);
    private static final Pattern ExplainCallPreamble = Pattern.compile("^\\s*explain(\\W|$)\\s*", 10);
    private static final Pattern ExplainJSONCallPreamble = Pattern.compile("^\\s*explainjson(\\W|$)\\s*", 10);
    private static final Pattern ExplainCatalogCallPreamble = Pattern.compile("^\\s*explaincatalog\\s*", 2);
    private static final Pattern ExplainProcCallPreamble = Pattern.compile("^\\s*explainProc(\\W|$)\\s*", 10);
    private static final Pattern ExplainViewCallPreamble = Pattern.compile("^\\s*explainView(\\W|$)\\s*", 10);
    private static final Pattern Unquote = Pattern.compile("^'|'$", 8);
    private static final Map<String, String> FRIENDLY_TYPE_NAMES = ImmutableMap.builder().put("tinyint", "byte numeric").put("smallint", "short numeric").put("int", "numeric").put("integer", "numeric").put("bigint", "long numeric").build();
    private static final SingleArgumentCommandParser loadClassesParser = new SingleArgumentCommandParser("load classes", "jar file");
    private static final SingleArgumentCommandParser removeClassesParser = new SingleArgumentCommandParser("remove classes", "class selector");
    private static final Pattern ClassSelectorToken = Pattern.compile("^[\\w*.$]+$", 2);
    public static final String CAPTURE_EXPORT_TARGET = "targetName";
    public static final String CAPTURE_STREAM_PARTITION_COLUMN = "partitionColumnName";
    public static final String CAPTURE_TOPIC_PROFILE = "topicProfileName";
    public static final String CAPTURE_TOPIC_FORMAT = "topicFormatName";
    public static final String CAPTURE_TOPIC_KEY_COLUMNS = "topicKeyColumnNames";
    public static final String CAPTURE_TOPIC_ALLOWED_ROLES = "topicAllowedRoleNames";

    public static Matcher matchSetGlobalParam(String statement) {
        return SET_GLOBAL_PARAM.matcher(statement);
    }

    public static Matcher matchAllVoltDBStatementPreambles(String statement) {
        return PAT_ALL_VOLTDB_STATEMENT_PREAMBLES.matcher(statement);
    }

    public static Matcher matchCreateRole(String statement) {
        return PAT_CREATE_ROLE.matcher(statement);
    }

    public static Matcher matchDropRole(String statement) {
        return PAT_DROP_ROLE.matcher(statement);
    }

    public static Matcher matchDropStream(String statement) {
        return PAT_DROP_STREAM.matcher(statement);
    }

    public static Matcher matchCreateStream(String statement) {
        return PAT_CREATE_STREAM.matcher(statement);
    }

    public static Matcher matchCreateTableMigrateTo(String statement) {
        return PAT_CREATE_TABLE.matcher(statement);
    }

    public static Matcher matchCreateTableExportTo(String statement) {
        return PAT_CREATE_EXPORT_TABLE.matcher(statement);
    }

    public static Matcher matchAlterTTL(String statement) {
        return PAT_ALTER_TTL.matcher(statement);
    }

    public static Matcher matchDRTable(String statement) {
        return PAT_DR_TABLE.matcher(statement);
    }

    public static Matcher matchPartitionStatementPreamble(String statement) {
        return PAT_PARTITION_ANY_PREAMBLE.matcher(statement);
    }

    public static Matcher matchPartitionTable(String statement) {
        return PAT_PARTITION_TABLE.matcher(statement);
    }

    public static Matcher matchPartitionProcedure(String statement) {
        return PAT_PARTITION_PROCEDURE.matcher(statement);
    }

    public static Matcher matchCreateProcedureAsSQL(String statement) {
        return PAT_CREATE_PROCEDURE_FROM_SQL.matcher(statement);
    }

    public static Matcher matchCreateMultiStmtProcedureAsSQL(String statement) {
        return PAT_CREATE_MULTI_STMT_PROCEDURE_FROM_SQL.matcher(statement);
    }

    public static Matcher matchCreateProcedureAsScript(String statement) {
        return PAT_CREATE_PROCEDURE_AS_SCRIPT.matcher(statement);
    }

    public static Matcher matchCreateProcedureFromClass(String statement) {
        return PAT_CREATE_PROCEDURE_FROM_CLASS.matcher(statement);
    }

    public static Matcher matchCreateFunctionFromMethod(String statement) {
        return PAT_CREATE_FUNCTION_FROM_METHOD.matcher(statement);
    }

    public static Matcher matchCreateAggregateFunctionFromClass(String statement) {
        return PAT_CREATE_AGGREGATE_FUNCTION_FROM_CLASS.matcher(statement);
    }

    public static Matcher matchDropAggregateFunction(String statement) {
        return PAT_DROP_AGGREGATE_FUNCTION.matcher(statement);
    }

    public static Matcher matchDropFunction(String statement) {
        return PAT_DROP_FUNCTION.matcher(statement);
    }

    public static Matcher matchDropProcedure(String statement) {
        return PAT_DROP_PROCEDURE.matcher(statement);
    }

    public static Matcher matchAnyCreateProcedureStatementClause(String statement) {
        return PAT_ANY_CREATE_PROCEDURE_STATEMENT_CLAUSE.matcher(statement);
    }

    public static Matcher matchAnyCreateStreamStatementClause(String statement) {
        return PAT_ANY_CREATE_STREAM_STATEMENT_CLAUSE.matcher(statement);
    }

    public static Matcher matchReplicateTable(String statement) {
        return PAT_REPLICATE_TABLE.matcher(statement);
    }

    public static Matcher matchCreateTask(String statement) {
        return PAT_CREATE_TASK.matcher(statement);
    }

    public static Matcher matchDropTask(String statement) {
        return PAT_DROP_TASK.matcher(statement);
    }

    public static Matcher matchAlterTask(String statement) {
        return PAT_ALTER_TASK.matcher(statement);
    }

    private static SQLPatternPart makeInnerProcedureModifierClausePattern(boolean captureTokens) {
        return SQLPatternFactory.SPF.oneOf(SQLPatternFactory.SPF.clause(SQLPatternFactory.SPF.token("allow"), SQLPatternFactory.SPF.group(captureTokens, SQLPatternFactory.SPF.commaList(SQLPatternFactory.SPF.userName()))), SQLPatternFactory.SPF.clause(SQLPatternFactory.SPF.token("partition"), SQLPatternFactory.SPF.token("on"), SQLPatternFactory.SPF.token("table"), SQLPatternFactory.SPF.group(captureTokens, SQLPatternFactory.SPF.databaseObjectName()), SQLPatternFactory.SPF.token("column"), SQLPatternFactory.SPF.group(captureTokens, SQLPatternFactory.SPF.databaseObjectName()), SQLPatternFactory.SPF.optional(SQLPatternFactory.SPF.clause(SQLPatternFactory.SPF.token("parameter"), SQLPatternFactory.SPF.group(captureTokens, SQLPatternFactory.SPF.integer()))), SQLPatternFactory.SPF.optional(SQLPatternFactory.SPF.clause(SQLPatternFactory.SPF.token("and"), SQLPatternFactory.SPF.token("on"), SQLPatternFactory.SPF.token("table"), SQLPatternFactory.SPF.group(captureTokens, SQLPatternFactory.SPF.databaseObjectName()), SQLPatternFactory.SPF.token("column"), SQLPatternFactory.SPF.group(captureTokens, SQLPatternFactory.SPF.databaseObjectName()), SQLPatternFactory.SPF.optional(SQLPatternFactory.SPF.clause(SQLPatternFactory.SPF.token("parameter"), SQLPatternFactory.SPF.group(captureTokens, SQLPatternFactory.SPF.integer())))))), SQLPatternFactory.SPF.group(captureTokens, SQLPatternFactory.SPF.token("directed")));
    }

    static SQLPatternPart parsedProcedureModifierClause() {
        return SQLPatternFactory.SPF.clause(SQLParser.makeInnerProcedureModifierClausePattern(true));
    }

    static SQLPatternPart unparsedProcedureModifierClauses() {
        return SQLPatternFactory.SPF.capture(SQLPatternFactory.SPF.repeat(SQLParser.makeInnerProcedureModifierClausePattern(false))).withFlags(SQLPatternFactory.ADD_LEADING_SPACE_TO_CHILD);
    }

    private static SQLPatternPart makeInnerStreamModifierClausePattern(boolean captureTokens) {
        return SQLPatternFactory.SPF.oneOf(SQLPatternFactory.SPF.clause(SQLPatternFactory.SPF.token("export"), SQLPatternFactory.SPF.token("to"), SQLPatternFactory.SPF.token("target"), SQLPatternFactory.SPF.group(captureTokens, CAPTURE_EXPORT_TARGET, SQLPatternFactory.SPF.databaseObjectName())), SQLPatternFactory.SPF.clause(SQLPatternFactory.SPF.token("partition"), SQLPatternFactory.SPF.token("on"), SQLPatternFactory.SPF.token("column"), SQLPatternFactory.SPF.group(captureTokens, CAPTURE_STREAM_PARTITION_COLUMN, SQLPatternFactory.SPF.databaseObjectName())), SQLPatternFactory.SPF.clause(SQLPatternFactory.SPF.token("as"), SQLPatternFactory.SPF.token("topic"), SQLPatternFactory.SPF.optional(SQLPatternFactory.SPF.clause(SQLPatternFactory.SPF.token("profile"), SQLPatternFactory.SPF.group(captureTokens, CAPTURE_TOPIC_PROFILE, SQLPatternFactory.SPF.databaseObjectName()))), SQLPatternFactory.SPF.optional(SQLPatternFactory.SPF.clause(SQLPatternFactory.SPF.token("format"), SQLPatternFactory.SPF.group(captureTokens, CAPTURE_TOPIC_FORMAT, SQLPatternFactory.SPF.databaseObjectName()))), SQLPatternFactory.SPF.optional(SQLPatternFactory.SPF.clause(SQLPatternFactory.SPF.token("keys"), SQLPatternFactory.SPF.group(captureTokens, CAPTURE_TOPIC_KEY_COLUMNS, new SQLPatternPartElement("[\\w$]+(?:\\s*,\\s*[\\w$]+)*")))), SQLPatternFactory.SPF.optional(SQLPatternFactory.SPF.clause(SQLPatternFactory.SPF.token("allow"), SQLPatternFactory.SPF.group(captureTokens, CAPTURE_TOPIC_ALLOWED_ROLES, new SQLPatternPartElement("[\\w$]+(?:\\s*,\\s*[\\w$]+)*"))))));
    }

    static SQLPatternPart parsedStreamModifierClause() {
        return SQLPatternFactory.SPF.clause(SQLParser.makeInnerStreamModifierClausePattern(true));
    }

    private static SQLPatternPart unparsedStreamModifierClauses() {
        return SQLPatternFactory.SPF.capture(SQLPatternFactory.SPF.repeat(SQLParser.makeInnerStreamModifierClausePattern(false))).withFlags(SQLPatternFactory.ADD_LEADING_SPACE_TO_CHILD);
    }

    private static List<String> parseExecParameters(String paramText) {
        String[] split;
        String SafeParamStringValuePattern = "#(SQL_PARSER_SAFE_PARAMSTRING)";
        ArrayList<String> originalString = new ArrayList<String>();
        Matcher stringMatcher = SingleQuotedString.matcher(paramText);
        StringBuilder safeText = new StringBuilder();
        while (stringMatcher.find()) {
            safeText.append(paramText.substring(0, stringMatcher.start()));
            String asMatched = stringMatcher.group();
            if (SingleQuotedStringContainingParameterSeparators.matcher(asMatched).matches()) {
                originalString.add(asMatched);
                safeText.append("#(SQL_PARSER_SAFE_PARAMSTRING)");
            } else {
                safeText.append(asMatched);
            }
            paramText = paramText.substring(stringMatcher.end());
            stringMatcher = SingleQuotedString.matcher(paramText);
        }
        safeText.append(paramText);
        ArrayList<String> params = new ArrayList<String>();
        int subCount = 0;
        int neededSubs = originalString.size();
        for (String fragment : split = safeText.toString().split("[\\s,]+")) {
            if (fragment.isEmpty()) continue;
            if (subCount < neededSubs) {
                while (fragment.indexOf("#(SQL_PARSER_SAFE_PARAMSTRING)") > -1) {
                    fragment = fragment.replace("#(SQL_PARSER_SAFE_PARAMSTRING)", (CharSequence)originalString.get(subCount));
                    ++subCount;
                }
            }
            params.add(fragment);
        }
        assert (subCount == neededSubs);
        return params;
    }

    public static boolean isSemiColonTerminated(String statement) {
        return SemicolonToken.matcher(statement).matches();
    }

    public static boolean isExitCommand(String statement) {
        return ExitToken.matcher(statement).matches();
    }

    public static ParseRecallResults parseRecallStatement(String statement, int lineMax) {
        Matcher matcher = RecallToken.matcher(statement);
        if (matcher.matches()) {
            String error;
            String commandWordTerminator = matcher.group(1);
            String lineNumberText = matcher.group(2);
            if (OneWhitespace.matcher(commandWordTerminator).matches()) {
                String trailings = matcher.group(3) + ";" + matcher.group(4);
                if (trailings.equals(";")) {
                    try {
                        int line = Integer.parseInt(lineNumberText) - 1;
                        if (line < 0 || line > lineMax) {
                            throw new NumberFormatException();
                        }
                        return new ParseRecallResults(line);
                    }
                    catch (NumberFormatException e) {
                        error = "Invalid RECALL line number argument: '" + lineNumberText + "'";
                    }
                } else {
                    error = "Invalid RECALL line number argument: '" + lineNumberText + " " + trailings + "'";
                }
            } else {
                error = commandWordTerminator.equals("") || commandWordTerminator.equals(";") ? "Incomplete RECALL command. RECALL expects a line number argument." : "Invalid RECALL command: a space and line number are required after 'recall'";
            }
            return new ParseRecallResults(error);
        }
        return null;
    }

    public static List<FileInfo> parseFileStatement(FileInfo parentContext, String statement) {
        Matcher fileMatcher = FileToken.matcher(statement);
        if (!fileMatcher.lookingAt()) {
            return null;
        }
        String remainder = statement.substring(fileMatcher.end(), statement.length());
        ArrayList<FileInfo> filesInfo = new ArrayList<FileInfo>();
        Matcher inlineBatchMatcher = DashInlineBatchToken.matcher(remainder);
        if (inlineBatchMatcher.lookingAt()) {
            Matcher delimiterMatcher = DelimiterToken.matcher(remainder = remainder.substring(inlineBatchMatcher.end(), remainder.length()));
            if (delimiterMatcher.matches()) {
                String delimiter = delimiterMatcher.group(1);
                filesInfo.add(new FileInfo(parentContext, FileOption.INLINEBATCH, delimiter));
                return filesInfo;
            }
            throw new Exception("Did not find valid delimiter for \"file -inlinebatch\" command.", new Object[0]);
        }
        FileOption option = FileOption.PLAIN;
        Matcher batchMatcher = DashBatchToken.matcher(remainder);
        if (batchMatcher.lookingAt()) {
            option = FileOption.BATCH;
            remainder = remainder.substring(batchMatcher.end(), remainder.length());
        }
        remainder = remainder.trim();
        ArrayList<String> filenames = new ArrayList<String>();
        Pattern regex = Pattern.compile("[^\\s']+|'[^']*'");
        Matcher regexMatcher = regex.matcher(remainder);
        while (regexMatcher.find()) {
            filenames.add(regexMatcher.group());
        }
        for (String filename : filenames) {
            Matcher filenameMatcher = FilenameToken.matcher(filename);
            if (!filenameMatcher.matches()) continue;
            filename = filenameMatcher.group(1);
            if ((filename = filename.trim()).startsWith("~")) {
                filename = filename.replaceFirst("~", System.getProperty("user.home"));
            }
            filesInfo.add(new FileInfo(parentContext, option, filename));
        }
        if (filesInfo.size() == 0) {
            String msg = String.format("Did not find valid file name in \"file%s\" command.", option == FileOption.BATCH ? " -batch" : "");
            throw new Exception(msg, new Object[0]);
        }
        return filesInfo;
    }

    public static List<FileInfo> parseFileStatement(String statement) {
        return SQLParser.parseFileStatement(null, statement);
    }

    public static String parseShowStatementSubcommand(String statement) {
        Matcher matcher = ShowToken.matcher(statement);
        if (matcher.matches()) {
            String commandWordTerminator = matcher.group(1);
            if (OneWhitespace.matcher(commandWordTerminator).matches()) {
                String trailings = matcher.group(3) + ";" + matcher.group(4);
                if (trailings.equals(";")) {
                    return matcher.group(2);
                }
                return matcher.group(2) + " " + trailings;
            }
            if (commandWordTerminator.equals("") || commandWordTerminator.equals(";")) {
                return commandWordTerminator;
            }
        }
        return null;
    }

    public static String parseHelpStatement(String statement) {
        Matcher matcher = HelpToken.matcher(statement);
        if (matcher.matches()) {
            String commandWordTerminator = matcher.group(1);
            if (OneWhitespace.matcher(commandWordTerminator).matches()) {
                String trailings = matcher.group(3) + ";" + matcher.group(4);
                if (trailings.equals(";")) {
                    return matcher.group(2);
                }
                return matcher.group(2) + " " + trailings;
            }
            if (commandWordTerminator.equals("") || commandWordTerminator.equals(";")) {
                return "";
            }
            return matcher.group(1).trim();
        }
        return null;
    }

    public static TimestampType parseDate(String dateIn) {
        String dateRepled = dateIn.replaceAll("^\"|\"$", "").replaceAll("^'|'$", "");
        return new TimestampType(dateRepled);
    }

    public static GeographyPointValue parseGeographyPoint(String param) {
        int spos = param.indexOf("'");
        int epos = param.lastIndexOf("'");
        if (spos < 0) {
            spos = -1;
        }
        if (epos < 0) {
            epos = param.length();
        }
        return GeographyPointValue.fromWKT(param.substring(spos + 1, epos));
    }

    public static GeographyValue parseGeography(String param) {
        int spos = param.indexOf("'");
        int epos = param.lastIndexOf("'");
        if (spos < 0) {
            spos = -1;
        }
        if (epos < 0) {
            epos = param.length();
        }
        return GeographyValue.fromWKT(param.substring(spos + 1, epos));
    }

    public static String getDigitsFromHexLiteral(String paramString) {
        Matcher matcher = SingleQuotedHexLiteral.matcher(paramString);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    public static long hexDigitsToLong(String hexDigits) throws Exception {
        if (hexDigits.length() > 16) {
            throw new Exception("Too many hexadecimal digits for BIGINT value", new Object[0]);
        }
        if (hexDigits.length() == 0) {
            throw new Exception("Zero hexadecimal digits is invalid for BIGINT value", new Object[0]);
        }
        long val = new BigInteger(hexDigits, 16).longValue();
        return val;
    }

    public static ExecuteCallResults parseExecuteCall(String statement, Map<String, Map<Integer, List<String>>> procedures) throws Exception {
        assert (procedures != null);
        return SQLParser.parseExecuteCallInternal(statement, procedures);
    }

    public static ExecuteCallResults parseExecuteCallWithoutParameterTypes(String statement) throws Exception {
        return SQLParser.parseExecuteCallInternal(statement, null);
    }

    private static ExecuteCallResults parseExecuteCallInternal(String statement, Map<String, Map<Integer, List<String>>> procedures) throws Exception {
        Matcher matcher = ExecuteCallPreamble.matcher(statement);
        if (!matcher.lookingAt()) {
            return null;
        }
        String commandWordTerminator = matcher.group(1);
        if (OneWhitespace.matcher(commandWordTerminator).matches() || commandWordTerminator.equals(",")) {
            ExecuteCallResults results = new ExecuteCallResults();
            String rawParams = statement.substring(matcher.end());
            results.params = SQLParser.parseExecParameters(rawParams);
            results.procedure = results.params.remove(0);
            if (procedures == null) {
                results.paramTypes = null;
                return results;
            }
            Map<Integer, List<String>> signature = procedures.get(results.procedure);
            if (signature == null) {
                throw new Exception("Undefined procedure: %s", new Object[]{results.procedure});
            }
            results.paramTypes = signature.get(results.params.size());
            if (results.paramTypes == null || results.params.size() != results.paramTypes.size()) {
                String expectedSizes = "";
                for (Integer expectedSize : signature.keySet()) {
                    expectedSizes = expectedSizes + expectedSize + ", ";
                }
                throw new Exception("Invalid parameter count for procedure: %s (expected: %s received: %d)", new Object[]{results.procedure, expectedSizes, results.params.size()});
            }
            return results;
        }
        if (commandWordTerminator.equals(";")) {
            throw new Exception("Incomplete EXECUTE command. EXECUTE requires a procedure name argument.", new Object[0]);
        }
        throw new Exception("Invalid EXECUTE command. unexpected input: '" + commandWordTerminator + "'.", new Object[0]);
    }

    public static String parseExplainCall(String statement) {
        Matcher matcher = ExplainCallPreamble.matcher(statement);
        if (!matcher.lookingAt()) {
            return null;
        }
        return statement.substring(matcher.end());
    }

    public static String parseExplainJSONCall(String statement) {
        Matcher matcher = ExplainJSONCallPreamble.matcher(statement);
        if (!matcher.lookingAt()) {
            return null;
        }
        return statement.substring(matcher.end());
    }

    public static boolean parseExplainCatalogCall(String statement) {
        Matcher matcher = ExplainCatalogCallPreamble.matcher(statement);
        return matcher.matches();
    }

    public static String parseExplainProcCall(String statement) {
        Matcher matcher = ExplainProcCallPreamble.matcher(statement);
        if (!matcher.lookingAt()) {
            return null;
        }
        return statement.substring(matcher.end()).trim();
    }

    public static String parseExplainViewCall(String statement) {
        Matcher matcher = ExplainViewCallPreamble.matcher(statement);
        if (!matcher.lookingAt()) {
            return null;
        }
        return statement.substring(matcher.end()).trim();
    }

    public static boolean queryIsDDL(String query) {
        return SQLLexer.extractDDLToken(query) != null;
    }

    public static String parseLoadClasses(String statement) throws Exception {
        String arg = loadClassesParser.parse(statement);
        if (arg == null) {
            return null;
        }
        if (!new File(arg).isFile()) {
            throw new Exception("Jar file not found: '" + arg + "'", new Object[0]);
        }
        return arg;
    }

    public static String parseRemoveClasses(String statement) throws Exception {
        String arg = removeClassesParser.parse(statement);
        if (arg == null) {
            return null;
        }
        if (!ClassSelectorToken.matcher(arg).matches()) {
            throw new Exception("Invalid class selector: '" + arg + "'", new Object[0]);
        }
        return arg;
    }

    public static boolean isWholeLineComment(String line) {
        return OneWholeLineComment.matcher(line).matches();
    }

    public static boolean appearsToBeValidDDLBatch(String batch) {
        block3: {
            BufferedReader reader = new BufferedReader(new StringReader(batch));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    if (SQLParser.isWholeLineComment(line) || (line = line.trim()).equals("")) continue;
                    return SQLParser.queryIsDDL(line);
                }
            }
            catch (IOException e) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
        return true;
    }

    public static String parseEchoStatement(String statement) {
        Matcher matcher = EchoToken.matcher(statement);
        if (matcher.matches()) {
            String commandWordTerminator = matcher.group(1);
            if (OneWhitespace.matcher(commandWordTerminator).matches()) {
                return matcher.group(2);
            }
            return "";
        }
        return null;
    }

    public static String parseEchoErrorStatement(String statement) {
        Matcher matcher = EchoErrorToken.matcher(statement);
        if (matcher.matches()) {
            String commandWordTerminator = matcher.group(1);
            if (OneWhitespace.matcher(commandWordTerminator).matches()) {
                return matcher.group(2);
            }
            return "";
        }
        return null;
    }

    public static String parseDescribeStatement(String statement) {
        Matcher matcher = DescribeToken.matcher(statement);
        if (matcher.matches()) {
            String commandWordTerminator = matcher.group(1);
            if (OneWhitespace.matcher(commandWordTerminator).matches()) {
                String trailings = matcher.group(3) + ";" + matcher.group(4);
                if (trailings.equals(";")) {
                    return matcher.group(2);
                }
                return matcher.group(2) + " " + trailings;
            }
            if (commandWordTerminator.equals("") || commandWordTerminator.equals(";")) {
                return commandWordTerminator;
            }
        }
        return null;
    }

    public static String parseQueryStatsStatement(String statement) {
        Matcher matcher = QueryStatsToken.matcher(statement);
        if (matcher.matches()) {
            String commandWordTerminator = matcher.group(1);
            if (OneWhitespace.matcher(commandWordTerminator).matches()) {
                String trailings = matcher.group(3) + ";" + matcher.group(4);
                if (trailings.equals(";")) {
                    return matcher.group(2);
                }
                return matcher.group(2) + " " + trailings;
            }
            if (commandWordTerminator.equals("") || commandWordTerminator.equals(";")) {
                return commandWordTerminator;
            }
        }
        return null;
    }

    public static class ExecuteCallResults {
        public String procedure = null;
        public List<String> params = null;
        public List<String> paramTypes = null;

        private static String preprocessParam(String param) {
            if (param.charAt(0) == '\'' && param.charAt(param.length() - 1) == '\'' || param.charAt(0) == '\"' && param.charAt(param.length() - 1) == '\"') {
                param = param.substring(1, param.length() - 1);
            }
            param = param.trim();
            param = param.toUpperCase();
            return param;
        }

        private static String friendlyTypeDescription(String paramType) {
            String friendly = (String)FRIENDLY_TYPE_NAMES.get(paramType);
            if (friendly != null) {
                return friendly;
            }
            return paramType;
        }

        public Object[] getParameterObjects() throws Exception {
            int i;
            Object[] objectParams = new Object[this.params.size()];
            try {
                for (i = 0; i < this.params.size(); ++i) {
                    String paramType = this.paramTypes.get(i);
                    String param = this.params.get(i);
                    Object objParam = null;
                    if (paramType.equals("bit")) {
                        objParam = param.equals("yes") || param.equals("true") || param.equals("1") ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
                    } else if (paramType.equals("statisticscomponent") || paramType.equals("sysinfoselector") || paramType.equals("metadataselector")) {
                        objParam = ExecuteCallResults.preprocessParam(param);
                    } else if (!"null".equalsIgnoreCase(param)) {
                        String hexDigits;
                        if (paramType.equals("tinyint")) {
                            objParam = Byte.parseByte(param);
                        } else if (paramType.equals("smallint")) {
                            objParam = Short.parseShort(param);
                        } else if (paramType.equals("int") || paramType.equals("integer")) {
                            objParam = Integer.parseInt(param);
                        } else if (paramType.equals("bigint")) {
                            hexDigits = SQLParser.getDigitsFromHexLiteral(param);
                            objParam = hexDigits != null ? Long.valueOf(SQLParser.hexDigitsToLong(hexDigits)) : Long.valueOf(Long.parseLong(param));
                        } else if (paramType.equals("float")) {
                            objParam = Double.parseDouble(param);
                        } else if (paramType.equals("varchar")) {
                            objParam = Unquote.matcher(param).replaceAll("").replace("''", "'");
                        } else if (paramType.equals("decimal")) {
                            objParam = new BigDecimal(param);
                        } else if (paramType.equals("timestamp")) {
                            objParam = SQLParser.parseDate(param);
                        } else if (paramType.equals("geography_point")) {
                            objParam = SQLParser.parseGeographyPoint(param);
                        } else if (paramType.equals("geography")) {
                            objParam = SQLParser.parseGeography(param);
                        } else if (paramType.equals("varbinary") || paramType.equals("tinyint_array")) {
                            hexDigits = SQLParser.getDigitsFromHexLiteral(param);
                            if (hexDigits == null) {
                                hexDigits = Unquote.matcher(param).replaceAll("");
                            }
                            objParam = Encoder.hexDecode(hexDigits);
                        } else {
                            throw new Exception("Unsupported Data Type: %s", new Object[]{paramType});
                        }
                    }
                    objectParams[i] = objParam;
                }
            }
            catch (NumberFormatException nfe) {
                throw new Exception((Throwable)nfe, "Invalid parameter:  Expected a %s value, got '%s' (param %d).", new Object[]{ExecuteCallResults.friendlyTypeDescription(this.paramTypes.get(i)), this.params.get(i), i + 1});
            }
            return objectParams;
        }

        ExecuteCallResults() {
        }

        public String toString() {
            return "ExecuteCallResults { procedure: " + this.procedure + ", params: " + this.params + ", paramTypes: " + this.paramTypes + " }";
        }
    }

    public static class FileInfo {
        private final FileInfo m_context;
        private final FileOption m_option;
        private final File m_file;
        private final String m_delimiter;
        private static FileInfo m_oneForSystemIn = null;

        public FileInfo(String path) {
            this.m_context = null;
            this.m_option = FileOption.PLAIN;
            this.m_file = new File(path);
            this.m_delimiter = null;
        }

        FileInfo(FileInfo context, FileOption option, String filenameOrDelimiter) {
            this.m_context = context;
            this.m_option = option;
            switch (option) {
                case PLAIN: 
                case BATCH: {
                    this.m_file = new File(filenameOrDelimiter);
                    this.m_delimiter = null;
                    break;
                }
                default: {
                    assert (option == FileOption.INLINEBATCH);
                    assert (this.m_context != null);
                    this.m_file = null;
                    this.m_delimiter = filenameOrDelimiter;
                }
            }
        }

        private FileInfo() {
            this.m_context = null;
            this.m_option = FileOption.PLAIN;
            this.m_file = null;
            this.m_delimiter = null;
        }

        public static FileInfo forSystemIn() {
            if (m_oneForSystemIn == null) {
                m_oneForSystemIn = new FileInfo(){

                    @Override
                    public String getFilePath() {
                        return "(standard input)";
                    }
                };
            }
            return m_oneForSystemIn;
        }

        public File getFile() {
            return this.m_file;
        }

        public String getFilePath() {
            String filePath;
            switch (this.m_option) {
                case PLAIN: 
                case BATCH: {
                    return this.m_file.getPath();
                }
            }
            String string = filePath = this.m_context == null ? "AdHoc DDL Input" : this.m_context.getFilePath();
            assert (this.m_option == FileOption.INLINEBATCH);
            return "(inline batch delimited by '" + this.m_delimiter + "' in " + filePath + ")";
        }

        public String getDelimiter() {
            assert (this.m_option == FileOption.INLINEBATCH);
            return this.m_delimiter;
        }

        public boolean isBatch() {
            return this.m_option == FileOption.BATCH || this.m_option == FileOption.INLINEBATCH;
        }

        public FileOption getOption() {
            return this.m_option;
        }

        public String toString() {
            return "FILE " + this.m_option.optionString() + (this.m_file != null ? this.m_file.toString() : this.m_delimiter);
        }
    }

    public static enum FileOption {
        PLAIN{

            @Override
            String optionString() {
                return "";
            }
        }
        ,
        BATCH{

            @Override
            String optionString() {
                return "-batch ";
            }
        }
        ,
        INLINEBATCH{

            @Override
            String optionString() {
                return "-inlinebatch ";
            }
        };


        abstract String optionString();
    }

    public static class ParseRecallResults {
        private final int line;
        private final String error;

        ParseRecallResults(int line) {
            this.line = line;
            this.error = null;
        }

        ParseRecallResults(String error) {
            this.line = -1;
            this.error = error;
        }

        public int getLine() {
            return this.line;
        }

        public String getError() {
            return this.error;
        }
    }

    public static class SingleArgumentCommandParser {
        final String prefix;
        final Pattern patPrefix;
        final Pattern patFull;
        final String argName;

        SingleArgumentCommandParser(String prefix, String argName) {
            this.prefix = prefix.toUpperCase();
            String prefixPat = prefix.replace(" ", "\\s+");
            this.patPrefix = Pattern.compile(String.format("^\\s*%s\\s.*$", prefixPat), 2);
            this.patFull = Pattern.compile(String.format("^\\s*%s\\s+([^;]+)[;\\s]*$", prefixPat), 2);
            this.argName = argName;
        }

        String parse(String line) throws Exception {
            if (line == null || !this.patPrefix.matcher(line).matches()) {
                return null;
            }
            Matcher matcher = this.patFull.matcher(line);
            String arg = null;
            if (matcher.matches()) {
                arg = SingleArgumentCommandParser.parseOptionallyQuotedString(matcher.group(1));
                if (arg == null) {
                    throw new Exception("Bad %s argument to %s: %s", new Object[]{this.argName, this.prefix, arg});
                }
            } else {
                throw new Exception("Missing %s argument to %s.", new Object[]{this.argName, this.prefix});
            }
            return arg;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static String parseOptionallyQuotedString(String sIn) throws Exception {
            String sOut = null;
            if (sIn == null) return sOut;
            if (!sIn.startsWith("'")) {
                if (!sIn.startsWith("\"")) return sIn;
            }
            if (sIn.length() <= 1 || !sIn.endsWith(sIn.substring(0, 1))) throw new Exception("Quoted string is not properly closed: %s", new Object[]{sIn});
            return sIn.substring(1, sIn.length() - 1);
        }
    }

    public static class Exception
    extends RuntimeException {
        private static final long serialVersionUID = -4043500523038225173L;

        private Exception(String message, Object ... args) {
            super(String.format(message, args));
        }

        private Exception(Throwable cause) {
            super(cause.getMessage(), cause);
        }

        private Exception(Throwable cause, String message, Object ... args) {
            super(String.format(message, args), cause);
        }
    }
}

