/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.types;

import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GeographyPointValue {
    private static final Pattern wktPattern = Pattern.compile("^\\s*point\\s*\\(\\s*(-?\\d+(?:\\.\\d*)?)?\\s+(-?\\d+(?:\\.\\d*)?)\\s*\\)\\s*\\z", 2);
    private final double m_latitude;
    private final double m_longitude;
    private static final int BYTES_IN_A_COORD = 8;
    static final double EPSILON = 1.0E-12;
    static final double NULL_COORD = 360.0;

    public GeographyPointValue(double longitude, double latitude) {
        this.m_latitude = latitude + 0.0;
        this.m_longitude = longitude + 0.0;
        if (!(this.m_latitude >= -90.0) || !(this.m_latitude <= 90.0)) {
            throw new IllegalArgumentException("Latitude out of bounds: " + this.m_latitude);
        }
        if (!(this.m_longitude >= -180.0) || !(this.m_longitude <= 180.0)) {
            throw new IllegalArgumentException("Longitude out of bounds: " + this.m_longitude);
        }
    }

    public static GeographyPointValue fromWKT(String param) {
        if (param == null) {
            throw new IllegalArgumentException("Null well known text argument to GeographyPointValue constructor.");
        }
        Matcher m = wktPattern.matcher(param);
        if (m.find()) {
            double longitude = Double.parseDouble(m.group(1));
            double latitude = Double.parseDouble(m.group(2));
            return new GeographyPointValue(longitude, latitude);
        }
        throw new IllegalArgumentException("Cannot construct GeographyPointValue value from \"" + param + "\"");
    }

    public double getLatitude() {
        return this.m_latitude;
    }

    public double getLongitude() {
        return this.m_longitude;
    }

    String formatLngLat() {
        DecimalFormat df = new DecimalFormat("##0.0###########");
        double lng = Math.abs(this.m_longitude) < 1.0E-12 ? 0.0 : this.m_longitude;
        double lat = Math.abs(this.m_latitude) < 1.0E-12 ? 0.0 : this.m_latitude;
        return df.format(lng) + " " + df.format(lat);
    }

    public String toString() {
        return this.toWKT();
    }

    public String toWKT() {
        return "POINT (" + this.formatLngLat() + ")";
    }

    public static int getValueDisplaySize() {
        return 42;
    }

    public boolean equals(Object o) {
        if (!(o instanceof GeographyPointValue)) {
            return false;
        }
        GeographyPointValue that = (GeographyPointValue)o;
        if (this == that) {
            return true;
        }
        GeographyPointValue normThis = GeographyPointValue.normalizeLngLat(this.getLongitude(), this.getLatitude());
        GeographyPointValue normThat = GeographyPointValue.normalizeLngLat(that.getLongitude(), that.getLatitude());
        if (Math.abs(normThis.getLongitude() - normThat.getLongitude()) > 1.0E-12) {
            return false;
        }
        return Math.abs(normThis.getLatitude() - normThat.getLatitude()) < 1.0E-12;
    }

    public static int getLengthInBytes() {
        return 16;
    }

    public void flattenToBuffer(ByteBuffer buffer) {
        buffer.putDouble(this.getLongitude());
        buffer.putDouble(this.getLatitude());
    }

    public static GeographyPointValue unflattenFromBuffer(ByteBuffer inBuffer, int offset) {
        double lng = inBuffer.getDouble(offset);
        double lat = inBuffer.getDouble(offset + 8);
        if (lat == 360.0 && lng == 360.0) {
            return null;
        }
        return new GeographyPointValue(lng, lat);
    }

    public static GeographyPointValue unflattenFromBuffer(ByteBuffer inBuffer) {
        double lng = inBuffer.getDouble();
        double lat = inBuffer.getDouble();
        if (lat == 360.0 && lng == 360.0) {
            return null;
        }
        return new GeographyPointValue(lng, lat);
    }

    public static void serializeNull(ByteBuffer buffer) {
        buffer.putDouble(360.0);
        buffer.putDouble(360.0);
    }

    public static GeographyPointValue normalizeLngLat(double longitude, double latitude) {
        double latNorm = GeographyPointValue.normalize(latitude, 360.0);
        double lngNorm = GeographyPointValue.normalize(longitude, 360.0);
        double latFinal = 0.0;
        double lngFinal = 0.0;
        assert (-180.0 <= latNorm && latNorm <= 180.0);
        assert (-180.0 <= lngNorm && lngNorm <= 180.0);
        boolean flipLng = false;
        if (latNorm > 90.0) {
            latFinal = 180.0 - latNorm;
            flipLng = true;
        } else if (latNorm < -90.0) {
            latFinal = -latNorm - 180.0;
            flipLng = true;
        } else {
            latFinal = latNorm;
            lngFinal = lngNorm;
        }
        if (flipLng) {
            lngFinal = lngNorm <= 0.0 ? lngNorm + 180.0 : lngNorm - 180.0;
        }
        assert (-90.0 <= latFinal && latFinal <= 90.0);
        if (90.0 - Math.abs(latFinal) < 1.0E-12) {
            lngFinal = 0.0;
        }
        if (lngFinal < 0.0 && 180.0 + lngFinal < 1.0E-12) {
            lngFinal = 180.0;
        }
        assert (-180.0 < lngFinal && lngFinal <= 180.0);
        return new GeographyPointValue(lngFinal + 0.0, latFinal + 0.0);
    }

    private static double normalize(double v, double range) {
        double a = v - Math.floor((v + range / 2.0) / range) * range;
        if (Math.abs(a) == 180.0 && a * v < 0.0) {
            a *= -1.0;
        }
        return a + 0.0;
    }

    @Deprecated
    public GeographyPointValue add(GeographyPointValue offset, double alpha) {
        return GeographyPointValue.normalizeLngLat(this.getLongitude() + alpha * offset.getLongitude() + 0.0, this.getLatitude() + alpha * offset.getLatitude() + 0.0);
    }

    @Deprecated
    public GeographyPointValue add(GeographyPointValue offset) {
        return this.add(offset, 1.0);
    }

    @Deprecated
    public GeographyPointValue sub(GeographyPointValue offset) {
        return this.add(offset, -1.0);
    }

    @Deprecated
    public GeographyPointValue sub(GeographyPointValue offset, double scale) {
        return this.add(offset, -1.0 * scale);
    }

    @Deprecated
    public GeographyPointValue mul(double alpha) {
        return GeographyPointValue.normalizeLngLat(this.getLongitude() * alpha + 0.0, this.getLatitude() * alpha + 0.0);
    }

    @Deprecated
    public GeographyPointValue rotate(double phi, GeographyPointValue center) {
        double sinphi = Math.sin(Math.PI * 2 * phi / 360.0);
        double cosphi = Math.cos(Math.PI * 2 * phi / 360.0);
        double longitude = this.getLongitude() - center.getLongitude();
        double latitude = this.getLatitude() - center.getLatitude();
        return GeographyPointValue.normalizeLngLat(cosphi * longitude - sinphi * latitude + center.getLongitude(), sinphi * longitude + cosphi * latitude + center.getLatitude());
    }

    @Deprecated
    public GeographyPointValue scale(GeographyPointValue center, double alpha) {
        return GeographyPointValue.normalizeLngLat(alpha * (this.getLongitude() - center.getLongitude()) + center.getLongitude(), alpha * (this.getLatitude() - center.getLatitude()) + center.getLatitude());
    }
}

