/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.types;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.voltdb.types.GeographyPointValue;

public class GeographyValue {
    public static final int DEFAULT_LENGTH = 32768;
    public static final int MIN_SERIALIZED_LENGTH = 155;
    public static final int MAX_SERIALIZED_LENGTH = 0x100000;
    private List<List<XYZPoint>> m_loops;
    private static final byte INCOMPLETE_ENCODING_FROM_JAVA = 0;
    private static final byte COMPLETE_ENCODING = 1;

    public GeographyValue(List<List<GeographyPointValue>> rings) {
        this(rings, false);
    }

    private GeographyValue(List<List<GeographyPointValue>> rings, boolean holesAreInS2Order) {
        if (rings == null || rings.size() < 1) {
            throw new IllegalArgumentException("GeographyValue must be instantiated with at least one ring");
        }
        this.m_loops = new ArrayList<List<XYZPoint>>();
        boolean firstLoop = true;
        for (List<GeographyPointValue> loop : rings) {
            int delta;
            int endIdx;
            int startIdx;
            GeographyValue.diagnoseLoop(loop, "Invalid loop for GeographyValue: ");
            ArrayList<XYZPoint> oneLoop = new ArrayList<XYZPoint>();
            if (firstLoop || holesAreInS2Order) {
                startIdx = 1;
                endIdx = loop.size() - 1;
                delta = 1;
            } else {
                startIdx = loop.size() - 2;
                endIdx = 0;
                delta = -1;
            }
            oneLoop.add(XYZPoint.fromGeographyPointValue(loop.get(0)));
            for (int i = startIdx; i != endIdx; i += delta) {
                oneLoop.add(XYZPoint.fromGeographyPointValue(loop.get(i)));
            }
            this.m_loops.add(oneLoop);
            firstLoop = false;
        }
    }

    public GeographyValue(String wkt) {
        if (wkt == null) {
            throw new IllegalArgumentException("Argument to GeographyValue WKT constructor was null");
        }
        this.m_loops = GeographyValue.loopsFromWkt(wkt);
        if (this.m_loops == null || this.m_loops.isEmpty()) {
            throw new IllegalArgumentException("Argument to GeographyValue WKT constructor was invalid");
        }
    }

    public static GeographyValue fromWKT(String text) {
        return new GeographyValue(text);
    }

    public List<List<GeographyPointValue>> getRings() {
        ArrayList<List<GeographyPointValue>> llLoops = new ArrayList<List<GeographyPointValue>>();
        boolean isShell = true;
        for (List<XYZPoint> xyzLoop : this.m_loops) {
            ArrayList<GeographyPointValue> llLoop = new ArrayList<GeographyPointValue>();
            llLoop.add(xyzLoop.get(0).toGeographyPointValue());
            int startIdx = isShell ? 1 : xyzLoop.size() - 1;
            int endIdx = isShell ? xyzLoop.size() : 0;
            int delta = isShell ? 1 : -1;
            for (int idx = startIdx; idx != endIdx; idx += delta) {
                XYZPoint xyz = xyzLoop.get(idx);
                llLoop.add(xyz.toGeographyPointValue());
            }
            llLoop.add(xyzLoop.get(0).toGeographyPointValue());
            llLoops.add(llLoop);
            isShell = false;
        }
        return llLoops;
    }

    public String toString() {
        return this.toWKT();
    }

    public String toWKT() {
        StringBuffer sb = new StringBuffer();
        sb.append("POLYGON (");
        boolean isFirstLoop = true;
        for (List<XYZPoint> loop : this.m_loops) {
            if (!isFirstLoop) {
                sb.append(", ");
            }
            sb.append("(");
            int startIdx = isFirstLoop ? 1 : loop.size() - 1;
            int endIdx = isFirstLoop ? loop.size() : 0;
            int increment = isFirstLoop ? 1 : -1;
            sb.append(loop.get(0).toGeographyPointValue().formatLngLat()).append(", ");
            for (int idx = startIdx; idx != endIdx; idx += increment) {
                XYZPoint xyz = loop.get(idx);
                sb.append(xyz.toGeographyPointValue().formatLngLat());
                sb.append(", ");
            }
            sb.append(loop.get(0).toGeographyPointValue().formatLngLat());
            sb.append(")");
            isFirstLoop = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof GeographyValue)) {
            return false;
        }
        GeographyValue that = (GeographyValue)o;
        if (this == that) {
            return true;
        }
        List<List<GeographyPointValue>> expectedRings = that.getRings();
        List<List<GeographyPointValue>> actualRings = this.getRings();
        if (expectedRings.size() != actualRings.size()) {
            return false;
        }
        Iterator<List<GeographyPointValue>> expectedRingIt = expectedRings.iterator();
        for (List<GeographyPointValue> actualRing : actualRings) {
            List<GeographyPointValue> expectedRing = expectedRingIt.next();
            if (expectedRing.size() != actualRing.size()) {
                return false;
            }
            Iterator<GeographyPointValue> expectedVertexIt = expectedRing.iterator();
            for (GeographyPointValue actualPt : actualRing) {
                GeographyPointValue expectedPt = expectedVertexIt.next();
                if (expectedPt.equals(actualPt)) continue;
                return false;
            }
        }
        return true;
    }

    private static long polygonOverheadInBytes() {
        return 7L + GeographyValue.boundLengthInBytes();
    }

    public int getLengthInBytes() {
        long length = GeographyValue.polygonOverheadInBytes();
        for (List<XYZPoint> loop : this.m_loops) {
            length += GeographyValue.loopLengthInBytes(loop.size());
        }
        return (int)length;
    }

    public static int getValueDisplaySize(int numBytes) {
        if (numBytes < 155) {
            throw new IllegalArgumentException("Cannot compute max display size for a GEOGRAPHY value of size " + numBytes + " bytes, since minimum allowed size is " + 155);
        }
        int numBytesUsedForVertices = numBytes;
        numBytesUsedForVertices = (int)((long)numBytesUsedForVertices - GeographyValue.polygonOverheadInBytes());
        numBytesUsedForVertices = (int)((long)numBytesUsedForVertices - GeographyValue.loopOverheadInBytes());
        int numVertices = numBytesUsedForVertices / 24;
        return 12 + 36 * numVertices;
    }

    public void flattenToBuffer(ByteBuffer buf) {
        buf.put((byte)0);
        buf.put((byte)1);
        buf.put((byte)(this.m_loops.size() > 1 ? 1 : 0));
        buf.putInt(this.m_loops.size());
        int depth = 0;
        for (List<XYZPoint> loop : this.m_loops) {
            GeographyValue.flattenLoopToBuffer(loop, depth, buf);
            depth = 1;
        }
        GeographyValue.flattenEmptyBoundToBuffer(buf);
    }

    public static GeographyValue unflattenFromBuffer(ByteBuffer inBuffer, int offset) {
        int origPos = inBuffer.position();
        inBuffer.position(offset);
        GeographyValue gv = GeographyValue.unflattenFromBuffer(inBuffer);
        inBuffer.position(origPos);
        return gv;
    }

    public static GeographyValue unflattenFromBuffer(ByteBuffer inBuffer) {
        byte version = inBuffer.get();
        inBuffer.get();
        inBuffer.get();
        int numLoops = inBuffer.getInt();
        ArrayList<List<XYZPoint>> loops = new ArrayList<List<XYZPoint>>();
        int indexOfOuterRing = 0;
        for (int i = 0; i < numLoops; ++i) {
            ArrayList<XYZPoint> loop = new ArrayList<XYZPoint>();
            int depth = GeographyValue.unflattenLoopFromBuffer(inBuffer, loop);
            if (depth == 0) {
                indexOfOuterRing = i;
            }
            loops.add(loop);
        }
        GeographyValue.unflattenBoundFromBuffer(inBuffer);
        return GeographyValue.polygonFromXyzPoints(loops);
    }

    private GeographyValue() {
        this.m_loops = null;
    }

    private static GeographyValue polygonFromXyzPoints(List<List<XYZPoint>> loops) {
        if (loops == null || loops.size() < 1) {
            throw new IllegalArgumentException("GeographyValue must be instantiated with at least one loop");
        }
        GeographyValue geog = new GeographyValue();
        geog.m_loops = loops;
        return geog;
    }

    private static long boundLengthInBytes() {
        return 33L;
    }

    private static long loopOverheadInBytes() {
        return 10L + GeographyValue.boundLengthInBytes();
    }

    private static long loopLengthInBytes(long numberOfVertices) {
        return GeographyValue.loopOverheadInBytes() + numberOfVertices * 24L;
    }

    private static void flattenEmptyBoundToBuffer(ByteBuffer buf) {
        buf.put((byte)0);
        buf.putDouble(360.0);
        buf.putDouble(360.0);
        buf.putDouble(360.0);
        buf.putDouble(360.0);
    }

    private static void flattenLoopToBuffer(List<XYZPoint> loop, int depth, ByteBuffer buf) {
        buf.put((byte)0);
        buf.putInt(loop.size());
        for (XYZPoint xyz : loop) {
            buf.putDouble(xyz.x());
            buf.putDouble(xyz.y());
            buf.putDouble(xyz.z());
        }
        buf.put((byte)0);
        buf.putInt(depth);
        GeographyValue.flattenEmptyBoundToBuffer(buf);
    }

    private static void unflattenBoundFromBuffer(ByteBuffer inBuffer) {
        inBuffer.get();
        inBuffer.getDouble();
        inBuffer.getDouble();
        inBuffer.getDouble();
        inBuffer.getDouble();
    }

    private static int unflattenLoopFromBuffer(ByteBuffer inBuffer, List<XYZPoint> loop) {
        inBuffer.get();
        int numVertices = inBuffer.getInt();
        for (int i = 0; i < numVertices; ++i) {
            double x = inBuffer.getDouble();
            double y = inBuffer.getDouble();
            double z = inBuffer.getDouble();
            loop.add(new XYZPoint(x, y, z));
        }
        inBuffer.get();
        int depth = inBuffer.getInt();
        GeographyValue.unflattenBoundFromBuffer(inBuffer);
        return depth;
    }

    private static <T> void diagnoseLoop(List<T> loop, String excpMsgPrf) throws IllegalArgumentException {
        if (loop == null) {
            throw new IllegalArgumentException(excpMsgPrf + "a polygon must contain at least one ring (with each ring at least 4 points, including repeated closing vertex)");
        }
        if (loop.size() < 4) {
            throw new IllegalArgumentException(excpMsgPrf + "a polygon ring must contain at least 4 points (including repeated closing vertex)");
        }
        if (!loop.get(0).equals(loop.get(loop.size() - 1))) {
            throw new IllegalArgumentException(excpMsgPrf + "closing points of ring are not equal: \"" + loop.get(0).toString() + "\" != \"" + loop.get(loop.size() - 1).toString() + "\"");
        }
    }

    private static List<List<XYZPoint>> loopsFromWkt(String wkt) throws IllegalArgumentException {
        String msgPrefix = "Improperly formatted WKT for polygon: ";
        StreamTokenizer tokenizer = new StreamTokenizer(new StringReader(wkt));
        tokenizer.lowerCaseMode(true);
        tokenizer.eolIsSignificant(false);
        ArrayList<XYZPoint> currentLoop = null;
        ArrayList<List<XYZPoint>> loops = new ArrayList<List<XYZPoint>>();
        boolean is_shell = true;
        try {
            int token = tokenizer.nextToken();
            if (token != -3 || !tokenizer.sval.equals("polygon")) {
                throw new IllegalArgumentException("Improperly formatted WKT for polygon: expected WKT to start with POLYGON");
            }
            token = tokenizer.nextToken();
            if (token != 40) {
                throw new IllegalArgumentException("Improperly formatted WKT for polygon: expected left parenthesis after POLYGON");
            }
            boolean polygonOpen = true;
            block8: while (polygonOpen) {
                token = tokenizer.nextToken();
                switch (token) {
                    case 40: {
                        if (currentLoop != null) {
                            throw new IllegalArgumentException("Improperly formatted WKT for polygon: missing closing parenthesis");
                        }
                        currentLoop = new ArrayList<XYZPoint>();
                        continue block8;
                    }
                    case -2: {
                        if (currentLoop == null) {
                            throw new IllegalArgumentException("Improperly formatted WKT for polygon: missing opening parenthesis");
                        }
                        double lng = tokenizer.nval;
                        token = tokenizer.nextToken();
                        if (token != -2) {
                            throw new IllegalArgumentException("Improperly formatted WKT for polygon: missing latitude in long lat pair");
                        }
                        double lat = tokenizer.nval;
                        currentLoop.add(XYZPoint.fromGeographyPointValue(new GeographyPointValue(lng, lat)));
                        token = tokenizer.nextToken();
                        if (token == 44) continue block8;
                        if (token != 41) {
                            throw new IllegalArgumentException("Improperly formatted WKT for polygon: missing comma between long lat pairs");
                        }
                        tokenizer.pushBack();
                        continue block8;
                    }
                    case 41: {
                        GeographyValue.diagnoseLoop(currentLoop, "Improperly formatted WKT for polygon: ");
                        currentLoop.remove(currentLoop.size() - 1);
                        if (!is_shell) {
                            int fidx = 1;
                            for (int lidx = currentLoop.size() - 1; fidx < lidx; ++fidx, --lidx) {
                                Collections.swap(currentLoop, fidx, lidx);
                            }
                        }
                        is_shell = false;
                        loops.add(currentLoop);
                        currentLoop = null;
                        token = tokenizer.nextToken();
                        if (token == 41) {
                            polygonOpen = false;
                            continue block8;
                        }
                        if (token == 44) continue block8;
                        throw new IllegalArgumentException("Improperly formatted WKT for polygon: unrecognized token in WKT: " + Character.toString((char)token));
                    }
                    case -1: {
                        throw new IllegalArgumentException("Improperly formatted WKT for polygon: premature end of input");
                    }
                }
                throw new IllegalArgumentException("Improperly formatted WKT for polygon: unrecognized token in WKT: " + Character.toString((char)token));
            }
            token = tokenizer.nextToken();
            if (token != -1) {
                throw new IllegalArgumentException("Improperly formatted WKT for polygon: unrecognized input after WKT");
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Improperly formatted WKT for polygon: error tokenizing string");
        }
        return loops;
    }

    @Deprecated
    public GeographyValue add(GeographyPointValue offset) {
        ArrayList<List<GeographyPointValue>> newLoops = new ArrayList<List<GeographyPointValue>>();
        for (List<XYZPoint> oneLoop : this.m_loops) {
            ArrayList<GeographyPointValue> loop = new ArrayList<GeographyPointValue>();
            for (XYZPoint p : oneLoop) {
                loop.add(p.toGeographyPointValue().add(offset));
            }
            loop.add(oneLoop.get(0).toGeographyPointValue().add(offset));
            newLoops.add(loop);
        }
        return new GeographyValue(newLoops, true);
    }

    static class XYZPoint {
        private final double m_x;
        private final double m_y;
        private final double m_z;

        public static XYZPoint fromGeographyPointValue(GeographyPointValue pt) {
            double latRadians = pt.getLatitude() * (Math.PI / 180);
            double lngRadians = pt.getLongitude() * (Math.PI / 180);
            double cosPhi = Math.cos(latRadians);
            double x = Math.cos(lngRadians) * cosPhi;
            double y = Math.sin(lngRadians) * cosPhi;
            double z = Math.sin(latRadians);
            return new XYZPoint(x, y, z);
        }

        public XYZPoint(double x, double y, double z) {
            this.m_x = x;
            this.m_y = y;
            this.m_z = z;
        }

        public double x() {
            return this.m_x;
        }

        public double y() {
            return this.m_y;
        }

        public double z() {
            return this.m_z;
        }

        public GeographyPointValue toGeographyPointValue() {
            double latRadians = Math.atan2(this.m_z, Math.sqrt(this.m_x * this.m_x + this.m_y * this.m_y));
            double lngRadians = Math.atan2(this.m_y, this.m_x);
            double latDegrees = latRadians * 57.29577951308232;
            double lngDegrees = lngRadians * 57.29577951308232;
            return new GeographyPointValue(lngDegrees, latDegrees);
        }

        public boolean equals(Object other) {
            if (!(other instanceof XYZPoint)) {
                return false;
            }
            XYZPoint compareTo = (XYZPoint)other;
            return this.m_x == compareTo.x() && this.m_y == compareTo.y() && this.m_z == compareTo.z();
        }

        public String toString() {
            return this.toGeographyPointValue().toString();
        }
    }
}

