/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.types;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class VoltDecimalHelper {
    public static final int kDefaultScale = 12;
    public static final int kDefaultPrecision = 38;
    private static final byte[] NULL_INDICATOR = new BigInteger("-170141183460469231731687303715884105728").toByteArray();
    private static final MathContext context = new MathContext(38);
    private static final BigInteger[] scaleFactors = new BigInteger[]{BigInteger.ONE, BigInteger.TEN, BigInteger.TEN.pow(2), BigInteger.TEN.pow(3), BigInteger.TEN.pow(4), BigInteger.TEN.pow(5), BigInteger.TEN.pow(6), BigInteger.TEN.pow(7), BigInteger.TEN.pow(8), BigInteger.TEN.pow(9), BigInteger.TEN.pow(10), BigInteger.TEN.pow(11), BigInteger.TEN.pow(12), BigInteger.TEN.pow(13), BigInteger.TEN.pow(14), BigInteger.TEN.pow(15), BigInteger.TEN.pow(16), BigInteger.TEN.pow(17), BigInteger.TEN.pow(18), BigInteger.TEN.pow(19), BigInteger.TEN.pow(20), BigInteger.TEN.pow(21), BigInteger.TEN.pow(22), BigInteger.TEN.pow(23), BigInteger.TEN.pow(24), BigInteger.TEN.pow(25), BigInteger.TEN.pow(26), BigInteger.TEN.pow(27), BigInteger.TEN.pow(28), BigInteger.TEN.pow(29), BigInteger.TEN.pow(30), BigInteger.TEN.pow(31), BigInteger.TEN.pow(32), BigInteger.TEN.pow(33), BigInteger.TEN.pow(34), BigInteger.TEN.pow(35), BigInteger.TEN.pow(36), BigInteger.TEN.pow(37), BigInteger.TEN.pow(38)};
    private static final String m_roundingEnabledProperty = "BIGDECIMAL_ROUND";
    private static final String m_defaultRoundingEnablement = "true";
    private static final String m_roundingModeProperty = "BIGDECIMAL_ROUND_POLICY";
    private static final String m_defaultRoundingMode = "HALF_UP";
    private static RoundingConfiguration m_roundingConfiguration = new RoundingConfiguration(Boolean.valueOf(System.getProperty("BIGDECIMAL_ROUND", "true")), RoundingMode.valueOf(System.getProperty("BIGDECIMAL_ROUND_POLICY", "HALF_UP")));

    public static void serializeNull(ByteBuffer buf) {
        buf.put(NULL_INDICATOR);
    }

    private static final byte[] expandToLength16(byte[] scaledValue, boolean isNegative) {
        if (scaledValue.length == 16) {
            return scaledValue;
        }
        byte[] replacement = new byte[16];
        if (isNegative) {
            Arrays.fill(replacement, (byte)-1);
        }
        int shift = 16 - scaledValue.length;
        for (int ii = 0; ii < scaledValue.length; ++ii) {
            replacement[ii + shift] = scaledValue[ii];
        }
        return replacement;
    }

    public static byte[] serializeBigDecimal(BigDecimal bd) {
        ByteBuffer buf = ByteBuffer.allocate(16);
        VoltDecimalHelper.serializeBigDecimal(bd, buf);
        return buf.array();
    }

    public static final boolean isRoundingEnabled() {
        return m_roundingConfiguration.getRoundingIsEnabled();
    }

    public static final synchronized void setRoundingConfig(boolean enabled, RoundingMode mode) {
        m_roundingConfiguration.setConfig(enabled, mode);
    }

    public static final RoundingMode getRoundingMode() {
        return m_roundingConfiguration.getRoundingMode();
    }

    private static final BigDecimal roundToScale(BigDecimal bd, int scale, RoundingMode mode) throws RuntimeException {
        int lostScaleDigits = bd.scale() - scale;
        if (lostScaleDigits <= 0) {
            return bd;
        }
        if (!VoltDecimalHelper.isRoundingEnabled()) {
            throw new RuntimeException(String.format("Decimal scale %d is greater than the maximum %d", bd.scale(), 12));
        }
        int desiredPrecision = Math.max(1, bd.precision() - lostScaleDigits);
        MathContext mc = new MathContext(desiredPrecision, mode);
        BigDecimal nbd = bd.round(mc);
        if (nbd.scale() != scale) {
            nbd = nbd.setScale(scale);
        }
        assert (nbd.scale() == scale);
        return nbd;
    }

    public static void serializeBigDecimal(BigDecimal bd, ByteBuffer buf) {
        int overallPrecision;
        int wholeNumberPrecision;
        if (bd == null) {
            VoltDecimalHelper.serializeNull(buf);
            return;
        }
        int decimalScale = bd.scale();
        if (decimalScale > 12) {
            bd = VoltDecimalHelper.roundToScale(bd, 12, VoltDecimalHelper.getRoundingMode());
            decimalScale = bd.scale();
        }
        if ((wholeNumberPrecision = (overallPrecision = bd.precision()) - decimalScale) > 26) {
            throw new RuntimeException("Precision of " + bd + " to the left of the decimal point is " + wholeNumberPrecision + " and the max is 26");
        }
        int scalingFactor = Math.max(0, 12 - decimalScale);
        BigInteger scalableBI = bd.unscaledValue();
        byte[] wholePicos = (scalableBI = scalableBI.multiply(scaleFactors[scalingFactor])).toByteArray();
        if (wholePicos.length > 16) {
            throw new RuntimeException("Precision of " + bd + " is > 38 digits");
        }
        boolean isNegative = scalableBI.signum() < 0;
        buf.put(VoltDecimalHelper.expandToLength16(wholePicos, isNegative));
    }

    public static BigDecimal deserializeBigDecimalFromString(String decimal) throws IOException {
        if (decimal == null) {
            return null;
        }
        BigDecimal bd = new BigDecimal(decimal);
        if (bd.scale() > 12 && (bd = bd.stripTrailingZeros()).scale() > 12) {
            bd = VoltDecimalHelper.roundToScale(bd, 12, VoltDecimalHelper.getRoundingMode());
        }
        if (bd.scale() < 12) {
            bd = bd.setScale(12);
        }
        if (bd.precision() > 38) {
            throw new RuntimeException("Decimal " + bd + " has more than " + 38 + " digits of precision.");
        }
        return bd;
    }

    public static BigDecimal deserializeBigDecimal(ByteBuffer buffer) {
        byte[] decimalBytes = new byte[16];
        buffer.get(decimalBytes);
        if (Arrays.equals(decimalBytes, NULL_INDICATOR)) {
            return null;
        }
        BigDecimal bd = new BigDecimal(new BigInteger(decimalBytes), 12, context);
        if (bd.precision() > 38) {
            throw new RuntimeException("Decimal " + bd + " has more than 38 digits of precision.");
        }
        return bd;
    }

    public static BigDecimal setDefaultScale(BigDecimal bd) {
        return bd.setScale(12, VoltDecimalHelper.getRoundingMode());
    }

    public static BigDecimal stringToDecimal(String valueStr) {
        BigInteger bi = new BigInteger(valueStr);
        BigDecimal bd = new BigDecimal(bi);
        bd = VoltDecimalHelper.setDefaultScale(bd);
        return bd;
    }

    private static class RoundingConfiguration {
        private RoundingMode m_roundingMode;
        private boolean m_roundingIsEnabled;

        public RoundingConfiguration(boolean enabled, RoundingMode mode) {
            this.m_roundingIsEnabled = enabled;
            this.m_roundingMode = mode;
        }

        public final RoundingMode getRoundingMode() {
            return this.m_roundingMode;
        }

        public final Boolean getRoundingIsEnabled() {
            return this.m_roundingIsEnabled;
        }

        public final void setConfig(boolean enabled, RoundingMode roundingMode) {
            this.m_roundingIsEnabled = enabled;
            this.m_roundingMode = roundingMode;
        }
    }
}

