/*
 * Decompiled with CFR 0.152.
 */
package com.google_voltpatches.common.base;

import com.google_voltpatches.common.annotations.GwtCompatible;
import com.google_voltpatches.common.base.CharMatcher;
import com.google_voltpatches.common.base.Enums;
import com.google_voltpatches.common.base.Optional;
import java.lang.ref.WeakReference;

@GwtCompatible(emulated=true)
final class Platform {
    private Platform() {
    }

    static long systemNanoTime() {
        return System.nanoTime();
    }

    static CharMatcher precomputeCharMatcher(CharMatcher matcher) {
        return matcher.precomputedInternal();
    }

    static <T extends Enum<T>> Optional<T> getEnumIfPresent(Class<T> enumClass, String value) {
        WeakReference<Enum<?>> ref = Enums.getEnumConstants(enumClass).get(value);
        return ref == null ? Optional.absent() : Optional.of(enumClass.cast(ref.get()));
    }
}

