/*
 * Decompiled with CFR 0.152.
 */
package org.HdrHistogram_voltpatches;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.HdrHistogram_voltpatches.AbstractHistogramBase;
import org.HdrHistogram_voltpatches.Histogram;
import org.HdrHistogram_voltpatches.HistogramData;
import org.HdrHistogram_voltpatches.HistogramIterationValue;
import org.voltcore.utils.CompressionStrategy;

public abstract class AbstractHistogram
extends AbstractHistogramBase
implements Serializable {
    int subBucketHalfCountMagnitude;
    int unitMagnitude;
    int subBucketHalfCount;
    long subBucketMask;
    private static final long serialVersionUID = 42L;

    abstract long getCountAtIndex(int var1);

    abstract void incrementCountAtIndex(int var1);

    abstract void addToCountAtIndex(int var1, long var2);

    abstract long getTotalCount();

    abstract void setTotalCount(long var1);

    abstract void incrementTotalCount();

    abstract void addToTotalCount(long var1);

    abstract void clearCounts();

    public abstract AbstractHistogram copy();

    public abstract AbstractHistogram copyCorrectedForCoordinatedOmission(long var1);

    public abstract int getEstimatedFootprintInBytes();

    public void copyInto(AbstractHistogram targetHistogram) {
        targetHistogram.reset();
        targetHistogram.add(this);
    }

    public void copyIntoCorrectedForCoordinatedOmission(AbstractHistogram targetHistogram, long expectedIntervalBetweenValueSamples) {
        targetHistogram.reset();
        targetHistogram.addWhileCorrectingForCoordinatedOmission(this, expectedIntervalBetweenValueSamples);
    }

    void initTotalCount() {
    }

    public AbstractHistogram(long lowestTrackableValue, long highestTrackableValue, int numberOfSignificantValueDigits) {
        if (lowestTrackableValue < 1L) {
            throw new IllegalArgumentException("lowestTrackableValue must be >= 1");
        }
        if (highestTrackableValue < 2L * lowestTrackableValue) {
            throw new IllegalArgumentException("highestTrackableValue must be >= 2 * lowestTrackableValue");
        }
        if (numberOfSignificantValueDigits < 0 || numberOfSignificantValueDigits > 5) {
            throw new IllegalArgumentException("numberOfSignificantValueDigits must be between 0 and 6");
        }
        this.identityCount = constructionIdentityCount.getAndIncrement();
        this.initTotalCount();
        this.init(lowestTrackableValue, highestTrackableValue, numberOfSignificantValueDigits, 0L);
    }

    private void init(long lowestTrackableValue, long highestTrackableValue, int numberOfSignificantValueDigits, long totalCount) {
        this.highestTrackableValue = highestTrackableValue;
        this.numberOfSignificantValueDigits = numberOfSignificantValueDigits;
        this.lowestTrackableValue = lowestTrackableValue;
        long largestValueWithSingleUnitResolution = 2L * (long)Math.pow(10.0, numberOfSignificantValueDigits);
        this.unitMagnitude = (int)Math.floor(Math.log(lowestTrackableValue) / Math.log(2.0));
        int subBucketCountMagnitude = (int)Math.ceil(Math.log(largestValueWithSingleUnitResolution) / Math.log(2.0));
        this.subBucketHalfCountMagnitude = (subBucketCountMagnitude > 1 ? subBucketCountMagnitude : 1) - 1;
        this.subBucketCount = (int)Math.pow(2.0, this.subBucketHalfCountMagnitude + 1);
        this.subBucketHalfCount = this.subBucketCount / 2;
        this.subBucketMask = this.subBucketCount - 1 << this.unitMagnitude;
        long trackableValue = this.subBucketCount - 1 << this.unitMagnitude;
        int bucketsNeeded = 1;
        while (trackableValue < highestTrackableValue) {
            trackableValue <<= 1;
            ++bucketsNeeded;
        }
        this.bucketCount = bucketsNeeded;
        this.countsArrayLength = (this.bucketCount + 1) * (this.subBucketCount / 2);
        this.setTotalCount(totalCount);
        this.histogramData = new HistogramData(this);
    }

    public long getLowestTrackableValue() {
        return this.lowestTrackableValue;
    }

    public long getHighestTrackableValue() {
        return this.highestTrackableValue;
    }

    public int getNumberOfSignificantValueDigits() {
        return this.numberOfSignificantValueDigits;
    }

    private int countsArrayIndex(int bucketIndex, int subBucketIndex) {
        assert (subBucketIndex < this.subBucketCount);
        assert (bucketIndex == 0 || subBucketIndex >= this.subBucketHalfCount);
        int bucketBaseIndex = bucketIndex + 1 << this.subBucketHalfCountMagnitude;
        int offsetInBucket = subBucketIndex - this.subBucketHalfCount;
        return bucketBaseIndex + offsetInBucket;
    }

    long getCountAt(int bucketIndex, int subBucketIndex) {
        return this.getCountAtIndex(this.countsArrayIndex(bucketIndex, subBucketIndex));
    }

    private static void arrayAdd(AbstractHistogram toHistogram, AbstractHistogram fromHistogram) {
        if (fromHistogram.countsArrayLength != toHistogram.countsArrayLength) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < fromHistogram.countsArrayLength; ++i) {
            toHistogram.addToCountAtIndex(i, fromHistogram.getCountAtIndex(i));
        }
    }

    int getBucketIndex(long value) {
        int pow2ceiling = 64 - Long.numberOfLeadingZeros(value | this.subBucketMask);
        return pow2ceiling - this.unitMagnitude - (this.subBucketHalfCountMagnitude + 1);
    }

    int getSubBucketIndex(long value, int bucketIndex) {
        return (int)(value >> bucketIndex + this.unitMagnitude);
    }

    private void recordCountAtValue(long count, long value) throws ArrayIndexOutOfBoundsException {
        int bucketIndex = this.getBucketIndex(value);
        int subBucketIndex = this.getSubBucketIndex(value, bucketIndex);
        int countsIndex = this.countsArrayIndex(bucketIndex, subBucketIndex);
        this.addToCountAtIndex(countsIndex, count);
        this.addToTotalCount(count);
    }

    private void recordSingleValue(long value) throws ArrayIndexOutOfBoundsException {
        int bucketIndex = this.getBucketIndex(value);
        int subBucketIndex = this.getSubBucketIndex(value, bucketIndex);
        int countsIndex = this.countsArrayIndex(bucketIndex, subBucketIndex);
        this.incrementCountAtIndex(countsIndex);
        this.incrementTotalCount();
    }

    private void recordValueWithCountAndExpectedInterval(long value, long count, long expectedIntervalBetweenValueSamples) throws ArrayIndexOutOfBoundsException {
        this.recordCountAtValue(count, value);
        if (expectedIntervalBetweenValueSamples <= 0L) {
            return;
        }
        for (long missingValue = value - expectedIntervalBetweenValueSamples; missingValue >= expectedIntervalBetweenValueSamples; missingValue -= expectedIntervalBetweenValueSamples) {
            this.recordCountAtValue(count, missingValue);
        }
    }

    public void recordValueWithExpectedInterval(long value, long expectedIntervalBetweenValueSamples) throws ArrayIndexOutOfBoundsException {
        this.recordValueWithCountAndExpectedInterval(value, 1L, expectedIntervalBetweenValueSamples);
    }

    public void recordValue(long value, long expectedIntervalBetweenValueSamples) throws ArrayIndexOutOfBoundsException {
        this.recordValueWithExpectedInterval(value, expectedIntervalBetweenValueSamples);
    }

    public void recordValueWithCount(long value, long count) throws ArrayIndexOutOfBoundsException {
        this.recordCountAtValue(count, value);
    }

    public void recordValue(long value) throws ArrayIndexOutOfBoundsException {
        this.recordSingleValue(value);
    }

    public void reset() {
        this.clearCounts();
    }

    public void add(AbstractHistogram fromHistogram) {
        if (this.highestTrackableValue != fromHistogram.highestTrackableValue || this.numberOfSignificantValueDigits != fromHistogram.numberOfSignificantValueDigits || this.bucketCount != fromHistogram.bucketCount || this.subBucketCount != fromHistogram.subBucketCount) {
            throw new IllegalArgumentException("Cannot add histograms with incompatible ranges");
        }
        AbstractHistogram.arrayAdd(this, fromHistogram);
        this.setTotalCount(this.getTotalCount() + fromHistogram.getTotalCount());
    }

    public void addWhileCorrectingForCoordinatedOmission(AbstractHistogram fromHistogram, long expectedIntervalBetweenValueSamples) {
        AbstractHistogram toHistogram = this;
        for (HistogramIterationValue v : fromHistogram.getHistogramData().recordedValues()) {
            toHistogram.recordValueWithCountAndExpectedInterval(v.getValueIteratedTo(), v.getCountAtValueIteratedTo(), expectedIntervalBetweenValueSamples);
        }
    }

    public boolean hasOverflowed() {
        long totalCounted = 0L;
        for (int i = 0; i < this.countsArrayLength; ++i) {
            totalCounted += this.getCountAtIndex(i);
        }
        return totalCounted != this.getTotalCount();
    }

    public void reestablishTotalCount() {
        long totalCounted = 0L;
        for (int i = 0; i < this.countsArrayLength; ++i) {
            totalCounted += this.getCountAtIndex(i);
        }
        this.setTotalCount(totalCounted);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AbstractHistogram)) {
            return false;
        }
        AbstractHistogram that = (AbstractHistogram)other;
        if (this.highestTrackableValue != that.highestTrackableValue || this.numberOfSignificantValueDigits != that.numberOfSignificantValueDigits) {
            return false;
        }
        if (this.countsArrayLength != that.countsArrayLength) {
            return false;
        }
        return this.getTotalCount() == that.getTotalCount();
    }

    public HistogramData getHistogramData() {
        return this.histogramData;
    }

    public long sizeOfEquivalentValueRange(long value) {
        int bucketIndex = this.getBucketIndex(value);
        int subBucketIndex = this.getSubBucketIndex(value, bucketIndex);
        long distanceToNextValue = 1 << this.unitMagnitude + (subBucketIndex >= this.subBucketCount ? bucketIndex + 1 : bucketIndex);
        return distanceToNextValue;
    }

    public long lowestEquivalentValue(long value) {
        int bucketIndex = this.getBucketIndex(value);
        int subBucketIndex = this.getSubBucketIndex(value, bucketIndex);
        long thisValueBaseLevel = AbstractHistogram.valueFromIndex(bucketIndex, subBucketIndex, this.unitMagnitude);
        return thisValueBaseLevel;
    }

    public long highestEquivalentValue(long value) {
        return this.nextNonEquivalentValue(value) - 1L;
    }

    public long medianEquivalentValue(long value) {
        return this.lowestEquivalentValue(value) + (this.sizeOfEquivalentValueRange(value) >> 1);
    }

    public long nextNonEquivalentValue(long value) {
        return this.lowestEquivalentValue(value) + this.sizeOfEquivalentValueRange(value);
    }

    public boolean valuesAreEquivalent(long value1, long value2) {
        return this.lowestEquivalentValue(value1) == this.lowestEquivalentValue(value2);
    }

    private void writeObject(ObjectOutputStream o) throws IOException {
        o.writeLong(this.lowestTrackableValue);
        o.writeLong(this.highestTrackableValue);
        o.writeInt(this.numberOfSignificantValueDigits);
        o.writeLong(this.getTotalCount());
    }

    private void readObject(ObjectInputStream o) throws IOException, ClassNotFoundException {
        long lowestTrackableValue = o.readLong();
        long highestTrackableValue = o.readLong();
        int numberOfSignificantValueDigits = o.readInt();
        long totalCount = o.readLong();
        this.init(lowestTrackableValue, highestTrackableValue, numberOfSignificantValueDigits, totalCount);
        this.setTotalCount(totalCount);
    }

    static final long valueFromIndex(int bucketIndex, int subBucketIndex, int unitMagnitude) {
        return (long)subBucketIndex << bucketIndex + unitMagnitude;
    }

    public byte[] toCompressedBytes(CompressionStrategy strategy) {
        byte[] array = this.toUncompressedBytes();
        try {
            return strategy.compress(array);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] toUncompressedBytes() {
        ByteBuffer buf = ByteBuffer.allocate(8 * this.countsArrayLength + 24 + 4);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.putLong(this.lowestTrackableValue);
        buf.putLong(this.highestTrackableValue);
        buf.putInt(this.numberOfSignificantValueDigits);
        buf.putLong(this.getTotalCount());
        for (int ii = 0; ii < this.countsArrayLength; ++ii) {
            buf.putLong(this.getCountAtIndex(ii));
        }
        return buf.array();
    }

    public static byte[] toCompressedBytes(byte[] bytes, CompressionStrategy strategy) {
        try {
            return strategy.compress(bytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Histogram fromCompressedBytes(byte[] bytes, CompressionStrategy strategy) {
        try {
            ByteBuffer buf = ByteBuffer.wrap(strategy.uncompress(bytes));
            buf.order(ByteOrder.LITTLE_ENDIAN);
            long lTrackableValue = buf.getLong();
            long hTrackableValue = buf.getLong();
            int nSVD = buf.getInt();
            Histogram h = new Histogram(lTrackableValue, hTrackableValue, nSVD);
            h.addToTotalCount(buf.getLong());
            for (int ii = 0; ii < h.countsArrayLength; ++ii) {
                h.addToCountAtIndex(ii, buf.getLong());
            }
            return h;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

