/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop_voltpatches.hbase.utils;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.List;

public class DirectMemoryUtils {
    public static long getDirectMemorySize() {
        RuntimeMXBean RuntimemxBean = ManagementFactory.getRuntimeMXBean();
        List<String> arguments = RuntimemxBean.getInputArguments();
        long multiplier = 1L;
        for (String s : arguments) {
            if (!s.contains("-XX:MaxDirectMemorySize=")) continue;
            String memSize = s.toLowerCase().replace("-xx:maxdirectmemorysize=", "").trim();
            if (memSize.contains("k")) {
                multiplier = 1024L;
            } else if (memSize.contains("m")) {
                multiplier = 0x100000L;
            } else if (memSize.contains("g")) {
                multiplier = 0x40000000L;
            }
            memSize = memSize.replaceAll("[^\\d]", "");
            long retValue = Long.parseLong(memSize);
            return retValue * multiplier;
        }
        return 0L;
    }
}

