/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jute_voltpatches;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.jute_voltpatches.Index;
import org.apache.jute_voltpatches.InputArchive;
import org.apache.jute_voltpatches.Record;

public class BinaryInputArchive
implements InputArchive {
    public static int MAX_BUFFER_SIZE = 0x3400000;
    private final DataInput in;
    public static final int maxBuffer = BinaryInputArchive.determineMaxBuffer();

    public static BinaryInputArchive getArchive(InputStream strm) {
        return new BinaryInputArchive(new DataInputStream(strm));
    }

    public BinaryInputArchive(DataInput in) {
        this.in = in;
    }

    @Override
    public byte readByte(String tag) throws IOException {
        return this.in.readByte();
    }

    @Override
    public boolean readBool(String tag) throws IOException {
        return this.in.readBoolean();
    }

    @Override
    public int readInt(String tag) throws IOException {
        return this.in.readInt();
    }

    @Override
    public long readLong(String tag) throws IOException {
        return this.in.readLong();
    }

    @Override
    public float readFloat(String tag) throws IOException {
        return this.in.readFloat();
    }

    @Override
    public double readDouble(String tag) throws IOException {
        return this.in.readDouble();
    }

    @Override
    public String readString(String tag) throws IOException {
        int len = this.in.readInt();
        if (len == -1) {
            return null;
        }
        byte[] b = new byte[len];
        this.in.readFully(b);
        return new String(b, "UTF8");
    }

    private static int determineMaxBuffer() {
        String maxBufferString = System.getProperty("jute.maxbuffer");
        try {
            return Integer.parseInt(maxBufferString);
        }
        catch (Exception e) {
            return MAX_BUFFER_SIZE;
        }
    }

    @Override
    public byte[] readBuffer(String tag) throws IOException {
        int len = this.readInt(tag);
        if (len == -1) {
            return null;
        }
        if (len < 0 || len > maxBuffer) {
            throw new IOException("Unreasonable length = " + len);
        }
        byte[] arr = new byte[len];
        this.in.readFully(arr);
        return arr;
    }

    @Override
    public void readRecord(Record r, String tag) throws IOException {
        r.deserialize(this, tag);
    }

    @Override
    public void startRecord(String tag) throws IOException {
    }

    @Override
    public void endRecord(String tag) throws IOException {
    }

    @Override
    public Index startVector(String tag) throws IOException {
        int len = this.readInt(tag);
        if (len == -1) {
            return null;
        }
        return new BinaryIndex(len);
    }

    @Override
    public void endVector(String tag) throws IOException {
    }

    @Override
    public Index startMap(String tag) throws IOException {
        return new BinaryIndex(this.readInt(tag));
    }

    @Override
    public void endMap(String tag) throws IOException {
    }

    private static class BinaryIndex
    implements Index {
        private int nelems;

        BinaryIndex(int nelems) {
            this.nelems = nelems;
        }

        @Override
        public boolean done() {
            return this.nelems <= 0;
        }

        @Override
        public void incr() {
            --this.nelems;
        }
    }
}

