/*
 * Decompiled with CFR 0.152.
 */
package org.voltcore.logging;

import java.util.logging.Logger;
import org.voltcore.logging.Level;
import org.voltcore.logging.VoltLogger;

public class VoltUtilLoggingLogger
implements VoltLogger.CoreVoltLogger {
    Logger m_logger;

    static java.util.logging.Level getPriorityForLevel(Level level) {
        switch (level) {
            case DEBUG: {
                return java.util.logging.Level.FINEST;
            }
            case ERROR: {
                return java.util.logging.Level.SEVERE;
            }
            case FATAL: {
                return java.util.logging.Level.SEVERE;
            }
            case INFO: {
                return java.util.logging.Level.INFO;
            }
            case TRACE: {
                return java.util.logging.Level.FINER;
            }
            case WARN: {
                return java.util.logging.Level.WARNING;
            }
        }
        return null;
    }

    VoltUtilLoggingLogger(String classname) {
        this.m_logger = Logger.getLogger(classname);
        if (this.m_logger == null) {
            throw new RuntimeException("Unable to get java.util.logging.Logger instance.");
        }
    }

    @Override
    public boolean isEnabledFor(Level level) {
        return this.m_logger.isLoggable(VoltUtilLoggingLogger.getPriorityForLevel(level));
    }

    @Override
    public void l7dlog(Level level, String key, Object[] params, Throwable t) {
        String msg = "NULL";
        if (key != null) {
            msg = key;
        }
        if (t != null) {
            msg = msg + " : Throwable: " + t.toString();
        }
        if (params != null && params.length > 0) {
            msg = msg + " : ";
            for (Object o : params) {
                msg = o != null ? msg + o.toString() + ", " : msg + "NULL, ";
            }
        }
        this.m_logger.log(VoltUtilLoggingLogger.getPriorityForLevel(level), msg);
    }

    @Override
    public void log(Level level, Object message, Throwable t) {
        String msg = "NULL";
        if (message != null) {
            msg = message.toString();
        }
        if (t != null) {
            msg = msg + " : Throwable: " + t.toString();
        }
        this.m_logger.log(VoltUtilLoggingLogger.getPriorityForLevel(level), msg);
    }

    @Override
    public long getLogLevels(VoltLogger[] loggers) {
        System.err.printf("This logger doesn't support getting log levels. You need Log4j.\n", new Object[0]);
        return 0L;
    }

    @Override
    public void setLevel(Level level) {
        this.m_logger.setLevel(VoltUtilLoggingLogger.getPriorityForLevel(level));
    }
}

