/*
 * Decompiled with CFR 0.152.
 */
package org.voltcore.network;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayDeque;
import org.voltcore.network.NetworkDBBPool;
import org.voltcore.utils.DBBPool;

public class NIOReadStream {
    private final ArrayDeque<DBBPool.BBContainer> m_readBuffers = new ArrayDeque();
    private DBBPool.BBContainer m_writeBuffer = null;
    private int m_totalAvailable = 0;
    private long m_bytesRead = 0L;
    private long m_lastBytesRead = 0L;

    public int dataAvailable() {
        return this.m_totalAvailable;
    }

    int getInt() {
        byte[] intbytes = new byte[4];
        this.getBytes(intbytes);
        int output = 0;
        for (int i = 0; i < intbytes.length; ++i) {
            output <<= 8;
            output |= intbytes[i] & 0xFF;
        }
        return output;
    }

    void getBytes(byte[] output) {
        if (this.m_totalAvailable < output.length) {
            throw new IllegalStateException("Requested " + output.length + " bytes; only have " + this.m_totalAvailable + " bytes; call tryRead() first");
        }
        int bytesCopied = 0;
        while (bytesCopied < output.length) {
            DBBPool.BBContainer firstC = this.m_readBuffers.peekFirst();
            if (firstC == null) {
                this.m_writeBuffer.b().flip();
                this.m_readBuffers.add(this.m_writeBuffer);
                firstC = this.m_writeBuffer;
                this.m_writeBuffer = null;
            }
            ByteBuffer first = firstC.b();
            assert (first.remaining() > 0);
            int bytesToCopy = output.length - bytesCopied;
            int bytesRemaining = first.remaining();
            if (bytesToCopy > bytesRemaining) {
                bytesToCopy = bytesRemaining;
            }
            first.get(output, bytesCopied, bytesToCopy);
            bytesCopied += bytesToCopy;
            this.m_totalAvailable -= bytesToCopy;
            if (first.remaining() != 0) continue;
            this.m_readBuffers.poll();
            firstC.discard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int read(ReadableByteChannel channel, int maxBytes, NetworkDBBPool pool) throws IOException {
        int bytesRead = 0;
        int lastRead = 1;
        try {
            while (bytesRead < maxBytes && lastRead > 0) {
                ByteBuffer writeBuffer = null;
                if (this.m_writeBuffer == null) {
                    this.m_writeBuffer = pool.acquire();
                    writeBuffer = this.m_writeBuffer.b();
                    writeBuffer.clear();
                } else {
                    writeBuffer = this.m_writeBuffer.b();
                }
                lastRead = channel.read(writeBuffer);
                if (lastRead < 0 && bytesRead == 0) {
                    if (writeBuffer.position() == 0) {
                        this.m_writeBuffer.discard();
                        this.m_writeBuffer = null;
                    }
                    int n = -1;
                    return n;
                }
                if (lastRead > 0) {
                    bytesRead += lastRead;
                    if (!writeBuffer.hasRemaining()) {
                        writeBuffer.flip();
                        this.m_readBuffers.add(this.m_writeBuffer);
                        this.m_writeBuffer = null;
                        continue;
                    }
                    break;
                }
                if (writeBuffer.position() != 0) continue;
                this.m_writeBuffer.discard();
                this.m_writeBuffer = null;
            }
        }
        finally {
            if (bytesRead > 0) {
                this.m_bytesRead += (long)bytesRead;
                this.m_totalAvailable += bytesRead;
            }
        }
        return bytesRead;
    }

    void shutdown() {
        for (DBBPool.BBContainer c : this.m_readBuffers) {
            c.discard();
        }
        if (this.m_writeBuffer != null) {
            this.m_writeBuffer.discard();
        }
        this.m_readBuffers.clear();
        this.m_writeBuffer = null;
    }

    long getBytesRead(boolean interval) {
        if (interval) {
            long bytesRead = this.m_bytesRead;
            long bytesReadThisTime = bytesRead - this.m_lastBytesRead;
            this.m_lastBytesRead = bytesRead;
            return bytesReadThisTime;
        }
        return this.m_bytesRead;
    }
}

