/*
 * Decompiled with CFR 0.152.
 */
package org.voltcore.network;

import java.util.ArrayDeque;
import org.voltcore.utils.DBBPool;

public class NetworkDBBPool {
    private final ArrayDeque<DBBPool.BBContainer> m_buffers = new ArrayDeque();
    private static final int LIMIT = Integer.getInteger("NETWORK_DBB_LIMIT", 512);
    private static final int SIZE = Integer.getInteger("NETWORK_DBB_SIZE", 32768);
    private final int m_numBuffers;
    private final int m_allocationSize;

    public NetworkDBBPool(int numBuffers) {
        this.m_numBuffers = numBuffers;
        this.m_allocationSize = SIZE;
    }

    NetworkDBBPool(int numBuffers, int allocSize) {
        this.m_numBuffers = numBuffers;
        this.m_allocationSize = allocSize;
    }

    public NetworkDBBPool() {
        this.m_numBuffers = LIMIT;
        this.m_allocationSize = SIZE;
    }

    DBBPool.BBContainer acquire() {
        final DBBPool.BBContainer cont = this.m_buffers.poll();
        if (cont == null) {
            final DBBPool.BBContainer originContainer = DBBPool.allocateDirect(this.m_allocationSize);
            return new DBBPool.BBContainer(originContainer.b()){

                @Override
                public void discard() {
                    this.checkDoubleFree();
                    if (NetworkDBBPool.this.m_buffers.size() > NetworkDBBPool.this.m_numBuffers) {
                        originContainer.discard();
                        return;
                    }
                    NetworkDBBPool.this.m_buffers.push(originContainer);
                }
            };
        }
        return new DBBPool.BBContainer(cont.b()){

            @Override
            public void discard() {
                this.checkDoubleFree();
                NetworkDBBPool.this.m_buffers.push(cont);
            }
        };
    }

    void clear() {
        DBBPool.BBContainer cont = null;
        while ((cont = this.m_buffers.poll()) != null) {
            cont.discard();
        }
    }
}

