/*
 * Decompiled with CFR 0.152.
 */
package org.voltcore.network;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.util.ArrayDeque;
import org.voltcore.network.NIOWriteStreamBase;
import org.voltcore.utils.DBBPool;
import org.voltcore.utils.DeferredSerialization;

public class PicoNIOWriteStream
extends NIOWriteStreamBase {
    private final ArrayDeque<DeferredSerialization> m_queuedWrites = new ArrayDeque();

    @Override
    public int getOutstandingMessageCount() {
        return this.m_queuedWrites.size() + super.getOutstandingMessageCount();
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && this.m_queuedWrites.isEmpty();
    }

    @Override
    protected ArrayDeque<DeferredSerialization> getQueuedWrites() {
        return this.m_queuedWrites;
    }

    @Override
    synchronized void shutdown() {
        super.shutdown();
        DeferredSerialization ds = null;
        while ((ds = this.m_queuedWrites.poll()) != null) {
            ds.cancel();
        }
    }

    @Override
    protected void updateQueued(int queued, boolean noBackpressureSignal) {
    }

    @Override
    int drainTo(GatheringByteChannel channel) throws IOException {
        int bytesWritten = 0;
        long rc = 0L;
        while (this.m_currentWriteBuffer != null || !this.m_queuedBuffers.isEmpty()) {
            ByteBuffer buffer = null;
            if (this.m_currentWriteBuffer == null) {
                this.m_currentWriteBuffer = (DBBPool.BBContainer)this.m_queuedBuffers.poll();
                buffer = this.m_currentWriteBuffer.b();
                buffer.flip();
            } else {
                buffer = this.m_currentWriteBuffer.b();
            }
            rc = channel.write(buffer);
            if (!buffer.hasRemaining()) {
                this.m_currentWriteBuffer.discard();
                this.m_currentWriteBuffer = null;
                ++this.m_messagesWritten;
            }
            bytesWritten = (int)((long)bytesWritten + rc);
            if (rc > 0L) continue;
        }
        this.m_bytesWritten += (long)bytesWritten;
        return bytesWritten;
    }

    public void enqueue(DeferredSerialization ds) {
        if (this.m_isShutdown) {
            ds.cancel();
            return;
        }
        this.m_queuedWrites.offer(ds);
    }

    public void enqueue(final ByteBuffer buf) {
        assert (!buf.isDirect());
        if (buf.remaining() == 0) {
            throw new IllegalArgumentException("Attempted to queue a zero length buffer");
        }
        if (this.m_isShutdown) {
            return;
        }
        this.m_queuedWrites.offer(new DeferredSerialization(){

            @Override
            public void serialize(ByteBuffer outbuf) throws IOException {
                outbuf.put(buf);
            }

            @Override
            public void cancel() {
            }

            @Override
            public int getSerializedSize() {
                return buf.remaining();
            }
        });
    }
}

