/*
 * Decompiled with CFR 0.152.
 */
package org.voltcore.network;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.voltcore.logging.VoltLogger;
import org.voltcore.network.Connection;
import org.voltcore.network.InputHandler;
import org.voltcore.network.NIOReadStream;
import org.voltcore.network.NetworkDBBPool;
import org.voltcore.network.PicoNIOWriteStream;
import org.voltcore.network.ReverseDNSCache;
import org.voltcore.network.VoltNetwork;
import org.voltcore.network.VoltNetworkPool;
import org.voltcore.network.VoltProtocolHandler;
import org.voltcore.network.WriteStream;
import org.voltcore.utils.DeferredSerialization;
import org.voltcore.utils.LatencyWatchdog;
import org.voltcore.utils.Pair;

public class PicoNetwork
implements Runnable,
Connection,
VoltNetworkPool.IOStatsIntf {
    private static final VoltLogger m_logger = new VoltLogger(VoltNetwork.class.getName());
    private static final VoltLogger networkLog = new VoltLogger("NETWORK");
    private final Selector m_selector;
    private final NetworkDBBPool m_pool = new NetworkDBBPool(64);
    private final NIOReadStream m_readStream = new NIOReadStream();
    private final PicoNIOWriteStream m_writeStream = new PicoNIOWriteStream();
    private final ConcurrentLinkedQueue<Runnable> m_tasks = new ConcurrentLinkedQueue();
    private volatile boolean m_shouldStop = false;
    private long m_messagesRead;
    private int m_interestOps = 0;
    private final SocketChannel m_sc;
    private final SelectionKey m_key;
    private InputHandler m_ih;
    private final Thread m_thread;
    volatile String m_remoteHostname = null;
    final InetSocketAddress m_remoteSocketAddress;
    final String m_remoteSocketAddressString;
    private volatile String m_remoteHostAndAddressAndPort;
    private String m_toString;
    private Set<Long> m_verbotenThreads;
    private boolean m_hadWork = false;
    private boolean m_alreadyStopped = false;
    private boolean m_alreadyStopping = false;

    public void start(InputHandler ih, Set<Long> verbotenThreads) {
        this.m_ih = ih;
        this.m_verbotenThreads = verbotenThreads;
        this.m_thread.start();
    }

    public PicoNetwork(SocketChannel sc) {
        InetSocketAddress remoteAddress;
        this.m_sc = sc;
        this.m_remoteSocketAddress = remoteAddress = (InetSocketAddress)sc.socket().getRemoteSocketAddress();
        this.m_remoteSocketAddressString = remoteAddress.getAddress().getHostAddress();
        this.m_remoteHostAndAddressAndPort = "/" + this.m_remoteSocketAddressString + ":" + this.m_remoteSocketAddress.getPort();
        this.m_toString = super.toString() + ":" + this.m_remoteHostAndAddressAndPort;
        String remoteHost = ReverseDNSCache.hostnameOrAddress(this.m_remoteSocketAddress.getAddress());
        if (!remoteHost.equals(this.m_remoteSocketAddress.getAddress().getHostAddress())) {
            this.m_remoteHostname = remoteHost;
            this.m_remoteHostAndAddressAndPort = remoteHost + this.m_remoteHostAndAddressAndPort;
            this.m_toString = super.toString() + ":" + this.m_remoteHostAndAddressAndPort;
        }
        this.m_thread = new Thread((Runnable)this, "Pico Network - " + this.m_toString);
        this.m_thread.setDaemon(true);
        try {
            sc.configureBlocking(false);
            sc.socket().setTcpNoDelay(true);
            this.m_selector = Selector.open();
            this.m_interestOps = 1;
            this.m_key = this.m_sc.register(this.m_selector, this.m_interestOps);
        }
        catch (IOException ex) {
            m_logger.fatal(null, ex);
            throw new RuntimeException(ex);
        }
    }

    public void shutdownAsync() throws InterruptedException {
        this.m_shouldStop = true;
        if (this.m_thread != null) {
            this.m_selector.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.m_verbotenThreads.add(Thread.currentThread().getId());
        try {
            this.m_ih.starting(this);
            this.m_ih.started(this);
            while (!this.m_shouldStop) {
                LatencyWatchdog.pet();
                if (this.m_hadWork) {
                    this.m_selector.selectNow();
                } else {
                    this.m_selector.select();
                }
                this.m_hadWork = false;
                Runnable task = null;
                while ((task = this.m_tasks.poll()) != null) {
                    this.m_hadWork = true;
                    task.run();
                }
                this.dispatchReadStream();
                this.drainWriteStream();
            }
        }
        catch (CancelledKeyException e) {
            networkLog.warn("Had a cancelled key exception for " + this.m_toString, e);
        }
        catch (IOException e) {
            String trimmed;
            String string = trimmed = e.getMessage() == null ? "" : e.getMessage().trim();
            if (e instanceof IOException && (trimmed.equalsIgnoreCase("Connection reset by peer") || trimmed.equalsIgnoreCase("broken pipe")) || e instanceof AsynchronousCloseException || e instanceof ClosedChannelException || e instanceof ClosedByInterruptException) {
                m_logger.debug("VoltPort died, probably of natural causes", e);
            } else {
                e.printStackTrace();
                networkLog.error("VoltPort died due to an unexpected exception", e);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            m_logger.error(null, ex);
            this.m_shouldStop = true;
        }
        finally {
            this.m_verbotenThreads.remove(Thread.currentThread().getId());
            try {
                this.p_shutdown();
            }
            catch (Throwable t) {
                m_logger.error("Error shutting down Volt Network", t);
                t.printStackTrace();
            }
        }
    }

    private void dispatchReadStream() throws IOException {
        if (this.readyForRead()) {
            if (this.fillReadStream() > 0) {
                this.m_hadWork = true;
            }
            try {
                ByteBuffer message;
                while ((message = this.m_ih.retrieveNextMessage(this.m_readStream)) != null) {
                    this.m_ih.handleMessage(message, this);
                    ++this.m_messagesRead;
                }
            }
            catch (VoltProtocolHandler.BadMessageLength e) {
                networkLog.error("Bad message length exception", e);
                throw e;
            }
        }
    }

    private final int fillReadStream() throws IOException {
        if (this.m_shouldStop) {
            return 0;
        }
        int read = this.m_readStream.read(this.m_sc, Integer.MAX_VALUE, this.m_pool);
        if (read == -1) {
            this.m_interestOps &= 0xFFFFFFFE;
            this.m_key.interestOps(this.m_interestOps);
            if (this.m_sc.socket().isConnected()) {
                try {
                    this.m_sc.socket().shutdownInput();
                }
                catch (SocketException socketException) {
                    // empty catch block
                }
            }
            this.m_shouldStop = true;
            this.safeStopping();
            this.enableWriteSelection();
        }
        return read;
    }

    private void drainWriteStream() throws IOException {
        if (this.m_writeStream.swapAndSerializeQueuedWrites(this.m_pool) != 0) {
            this.m_hadWork = true;
        }
        if (this.m_writeStream.drainTo(this.m_sc) > 0) {
            this.m_hadWork = true;
        }
        if (this.m_writeStream.isEmpty()) {
            this.disableWriteSelection();
            if (this.m_shouldStop) {
                this.m_sc.close();
                this.unregistered();
            }
        } else {
            this.enableWriteSelection();
        }
    }

    private void safeStopped() {
        if (!this.m_alreadyStopped) {
            this.m_alreadyStopped = true;
            this.m_ih.stopped(this);
        }
    }

    private void safeStopping() {
        if (!this.m_alreadyStopping) {
            this.m_alreadyStopping = true;
            this.m_ih.stopping(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregistered() {
        block15: {
            try {
                if (this.m_alreadyStopped) break block15;
                try {
                    this.safeStopping();
                }
                finally {
                    try {
                        this.m_writeStream.shutdown();
                    }
                    finally {
                        this.m_readStream.shutdown();
                    }
                }
            }
            finally {
                networkLog.debug("Closing channel " + this.m_toString);
                try {
                    this.m_sc.close();
                }
                catch (IOException e) {
                    networkLog.warn(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void p_shutdown() {
        try {
            this.safeStopping();
        }
        finally {
            try {
                this.safeStopped();
            }
            finally {
                try {
                    this.m_readStream.shutdown();
                }
                finally {
                    try {
                        this.m_writeStream.shutdown();
                    }
                    finally {
                        try {
                            this.m_pool.clear();
                        }
                        finally {
                            try {
                                try {
                                    this.m_selector.close();
                                }
                                finally {
                                    this.m_sc.close();
                                }
                            }
                            catch (IOException e) {
                                m_logger.error(null, e);
                            }
                        }
                    }
                }
            }
        }
    }

    private Map<Long, Pair<String, long[]>> getIOStatsImpl(boolean interval) {
        HashMap<Long, Pair<String, long[]>> retval = new HashMap<Long, Pair<String, long[]>>();
        long read = this.m_readStream.getBytesRead(interval);
        long[] writeInfo = this.m_writeStream.getBytesAndMessagesWritten(interval);
        long messagesRead = this.m_messagesRead;
        retval.put(this.m_ih.connectionId(), Pair.of(this.getHostnameOrIP(), new long[]{read, messagesRead, writeInfo[0], writeInfo[1]}));
        retval.put(-1L, Pair.of("GLOBAL", new long[]{read, messagesRead, writeInfo[0], writeInfo[1]}));
        return retval;
    }

    @Override
    public Future<Map<Long, Pair<String, long[]>>> getIOStats(final boolean interval) {
        Callable<Map<Long, Pair<String, long[]>>> task = new Callable<Map<Long, Pair<String, long[]>>>(){

            @Override
            public Map<Long, Pair<String, long[]>> call() throws Exception {
                return PicoNetwork.this.getIOStatsImpl(interval);
            }
        };
        FutureTask<Map<Long, Pair<String, long[]>>> ft = new FutureTask<Map<Long, Pair<String, long[]>>>(task);
        this.m_tasks.offer(ft);
        this.m_selector.wakeup();
        return ft;
    }

    @Override
    public WriteStream writeStream() {
        throw new UnsupportedOperationException();
    }

    @Override
    public NIOReadStream readStream() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void disableReadSelection() {
        throw new UnsupportedOperationException();
    }

    private void disableWriteSelection() {
        if ((this.m_interestOps & 4) != 0) {
            this.m_interestOps &= 0xFFFFFFFB;
            this.m_key.interestOps(this.m_interestOps);
        }
    }

    private void enableWriteSelection() {
        if ((this.m_interestOps & 4) == 0) {
            this.m_interestOps |= 4;
            this.m_key.interestOps(this.m_interestOps);
        }
    }

    @Override
    public void enableReadSelection() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getHostnameAndIPAndPort() {
        if (this.m_remoteHostname != null) {
            return this.m_remoteHostname;
        }
        return this.m_remoteSocketAddressString;
    }

    @Override
    public String getHostnameOrIP() {
        return this.m_remoteHostAndAddressAndPort;
    }

    @Override
    public int getRemotePort() {
        return this.m_remoteSocketAddress.getPort();
    }

    @Override
    public InetSocketAddress getRemoteSocketAddress() {
        return this.m_remoteSocketAddress;
    }

    @Override
    public long connectionId() {
        return this.m_ih.connectionId();
    }

    @Override
    public void queueTask(Runnable r) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Future<?> unregister() {
        throw new UnsupportedOperationException();
    }

    public void enqueue(final DeferredSerialization ds) {
        this.m_tasks.offer(new Runnable(){

            @Override
            public void run() {
                PicoNetwork.this.m_writeStream.enqueue(ds);
            }
        });
        this.m_selector.wakeup();
    }

    public void enqueue(final ByteBuffer buf) {
        this.m_tasks.offer(new Runnable(){

            @Override
            public void run() {
                PicoNetwork.this.m_writeStream.enqueue(buf);
            }
        });
        this.m_selector.wakeup();
    }

    boolean readyForRead() {
        return (this.m_key.readyOps() & 1) != 0 && (this.m_interestOps & 1) != 0;
    }
}

