/*
 * Decompiled with CFR 0.152.
 */
package org.voltcore.network;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import org.voltcore.network.Connection;
import org.voltcore.network.InputHandler;
import org.voltcore.network.NIOReadStream;

public abstract class VoltProtocolHandler
implements InputHandler {
    private static AtomicLong m_globalConnectionCounter = new AtomicLong(0L);
    private int m_sequenceId = 0;
    private final long m_connectionId = m_globalConnectionCounter.incrementAndGet();
    private int m_nextLength;
    private static int MAX_MESSAGE_LENGTH = 0x3200000;

    @Override
    public ByteBuffer retrieveNextMessage(NIOReadStream inputStream) throws BadMessageLength {
        ByteBuffer result = null;
        if (this.m_nextLength == 0 && inputStream.dataAvailable() > 4) {
            this.m_nextLength = inputStream.getInt();
            if (this.m_nextLength < 1) {
                throw new BadMessageLength("Next message length is " + this.m_nextLength + " which is less than 1 and is nonsense");
            }
            if (this.m_nextLength > MAX_MESSAGE_LENGTH) {
                throw new BadMessageLength("Next message length is " + this.m_nextLength + " which is greater then the hard coded " + "max of " + MAX_MESSAGE_LENGTH + ". Break up the work into smaller chunks (2 megabytes is reasonable) " + "and send as multiple messages or stored procedure invocations");
            }
            assert (this.m_nextLength > 0);
        }
        if (this.m_nextLength > 0 && inputStream.dataAvailable() >= this.m_nextLength) {
            result = ByteBuffer.allocate(this.m_nextLength);
            inputStream.getBytes(result.array());
            this.m_nextLength = 0;
            ++this.m_sequenceId;
        }
        return result;
    }

    @Override
    public void started(Connection c) {
    }

    @Override
    public void starting(Connection c) {
    }

    @Override
    public void stopped(Connection c) {
    }

    @Override
    public void stopping(Connection c) {
    }

    @Override
    public long connectionId() {
        return this.m_connectionId;
    }

    public int sequenceId() {
        return this.m_sequenceId;
    }

    protected int getNextMessageLength() {
        return this.m_nextLength;
    }

    class BadMessageLength
    extends IOException {
        private static final long serialVersionUID = 8547352379044459911L;

        public BadMessageLength(String string) {
            super(string);
        }
    }
}

