/*
 * Decompiled with CFR 0.152.
 */
package org.voltcore.utils;

import com.google_voltpatches.common.base.Preconditions;
import com.google_voltpatches.common.collect.ForwardingMap;
import com.google_voltpatches.common.collect.ImmutableMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;

public class COWMap<K, V>
extends ForwardingMap<K, V>
implements ConcurrentMap<K, V> {
    private final AtomicReference<ImmutableMap<K, V>> m_map;

    public COWMap() {
        this.m_map = new AtomicReference(new ImmutableMap.Builder().build());
    }

    public COWMap(Map<K, V> map) {
        if (map == null) {
            throw new IllegalArgumentException("Wrapped map cannot be null");
        }
        this.m_map = new AtomicReference(new ImmutableMap.Builder<K, V>().putAll(map).build());
    }

    @Override
    public V put(K key, V value) {
        V oldValue;
        ImmutableMap.Builder<K, V> builder;
        ImmutableMap copy;
        ImmutableMap<K, V> original;
        do {
            original = this.m_map.get();
            builder = new ImmutableMap.Builder<K, V>();
            oldValue = null;
            boolean replaced = false;
            for (Map.Entry entry : original.entrySet()) {
                if (entry.getKey().equals(key)) {
                    oldValue = entry.getValue();
                    builder.put(key, value);
                    replaced = true;
                    continue;
                }
                builder.put(entry);
            }
            if (replaced) continue;
            builder.put(key, value);
        } while (!this.m_map.compareAndSet(original, copy = builder.build()));
        return oldValue;
    }

    @Override
    public V remove(Object key) {
        V oldValue;
        ImmutableMap.Builder builder;
        ImmutableMap copy;
        ImmutableMap<K, V> original;
        Preconditions.checkNotNull(key);
        do {
            original = this.m_map.get();
            builder = new ImmutableMap.Builder();
            oldValue = null;
            for (Map.Entry entry : original.entrySet()) {
                if (entry.getKey().equals(key)) {
                    oldValue = entry.getValue();
                    continue;
                }
                builder.put(entry);
            }
        } while (!this.m_map.compareAndSet(original, copy = builder.build()));
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        ImmutableMap.Builder<K, V> builder;
        ImmutableMap copy;
        ImmutableMap<K, V> original;
        do {
            original = this.m_map.get();
            builder = new ImmutableMap.Builder<K, V>();
            for (Map.Entry entry : original.entrySet()) {
                if (m.containsKey(entry.getKey())) continue;
                builder.put(entry);
            }
            builder.putAll(m);
        } while (!this.m_map.compareAndSet(original, copy = builder.build()));
    }

    @Override
    public void clear() {
        this.m_map.set(new ImmutableMap.Builder().build());
    }

    @Override
    protected Map<K, V> delegate() {
        return this.m_map.get();
    }

    @Override
    public V putIfAbsent(K key, V value) {
        ImmutableMap<K, V> original;
        V existingValue;
        while ((existingValue = this.get(key)) == null && (existingValue = (original = this.m_map.get()).get(key)) == null) {
            ImmutableMap.Builder<K, V> builder = new ImmutableMap.Builder<K, V>();
            for (Map.Entry entry : original.entrySet()) {
                if (entry.getKey().equals(key)) {
                    throw new RuntimeException("Shouldn't happen already checked");
                }
                builder.put(entry);
            }
            builder.put(key, value);
            ImmutableMap copy = builder.build();
            if (!this.m_map.compareAndSet(original, copy)) continue;
            break;
        }
        return existingValue;
    }

    @Override
    public V get(Object key) {
        Preconditions.checkNotNull(key);
        return this.delegate().get(key);
    }

    @Override
    public boolean containsKey(Object key) {
        Preconditions.checkNotNull(key);
        return this.delegate().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        Preconditions.checkNotNull(value);
        return this.delegate().containsValue(value);
    }

    @Override
    public boolean remove(Object key, Object value) {
        ImmutableMap<K, V> original;
        V existingValue;
        Preconditions.checkNotNull(key);
        if (value == null) {
            return false;
        }
        while ((existingValue = (original = this.m_map.get()).get(key)) != null && existingValue.equals(value)) {
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            for (Map.Entry entry : original.entrySet()) {
                if (entry.getKey().equals(key)) continue;
                builder.put(entry);
            }
            ImmutableMap copy = builder.build();
            if (!this.m_map.compareAndSet(original, copy)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        ImmutableMap<K, V> original;
        V existingValue;
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(oldValue);
        Preconditions.checkNotNull(newValue);
        while ((existingValue = (original = this.m_map.get()).get(key)) != null && existingValue.equals(oldValue)) {
            ImmutableMap.Builder<K, V> builder = new ImmutableMap.Builder<K, V>();
            for (Map.Entry entry : original.entrySet()) {
                if (entry.getKey().equals(key)) continue;
                builder.put(entry);
            }
            builder.put(key, newValue);
            ImmutableMap copy = builder.build();
            if (!this.m_map.compareAndSet(original, copy)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V replace(K key, V value) {
        ImmutableMap<K, V> original;
        V existingValue;
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(value);
        while ((existingValue = (original = this.m_map.get()).get(key)) != null) {
            ImmutableMap.Builder<K, V> builder = new ImmutableMap.Builder<K, V>();
            for (Map.Entry entry : original.entrySet()) {
                if (entry.getKey().equals(key)) continue;
                builder.put(entry);
            }
            builder.put(key, value);
            ImmutableMap copy = builder.build();
            if (!this.m_map.compareAndSet(original, copy)) continue;
            return existingValue;
        }
        return null;
    }
}

