/*
 * Decompiled with CFR 0.152.
 */
package org.voltcore.utils;

import com.google_voltpatches.common.base.Preconditions;
import com.google_voltpatches.common.collect.ForwardingNavigableMap;
import com.google_voltpatches.common.collect.ImmutableMap;
import com.google_voltpatches.common.collect.ImmutableSortedMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.atomic.AtomicReference;

public class COWSortedMap<K extends Comparable<K>, V>
extends ForwardingNavigableMap<K, V>
implements NavigableMap<K, V> {
    private final AtomicReference<ImmutableSortedMap<K, V>> m_map;

    public COWSortedMap() {
        this.m_map = new AtomicReference<ImmutableMap>(ImmutableSortedMap.naturalOrder().build());
    }

    public COWSortedMap(Map<K, V> map) {
        if (map == null) {
            throw new IllegalArgumentException("Wrapped map cannot be null");
        }
        this.m_map = new AtomicReference<ImmutableMap>(((ImmutableSortedMap.Builder)ImmutableSortedMap.naturalOrder().putAll(map)).build());
    }

    @Override
    public int size() {
        return this.m_map.get().size();
    }

    public Map<K, V> get() {
        return this.m_map.get();
    }

    @Override
    public boolean isEmpty() {
        return this.m_map.get().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        Preconditions.checkNotNull(key);
        return this.m_map.get().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        Preconditions.checkNotNull(value);
        return this.m_map.get().containsValue(value);
    }

    @Override
    public V get(Object key) {
        Preconditions.checkNotNull(key);
        return this.m_map.get().get(key);
    }

    @Override
    public V put(K key, V value) {
        V oldValue;
        ImmutableSortedMap.Builder builder;
        ImmutableMap copy;
        ImmutableSortedMap<K, V> original;
        do {
            original = this.m_map.get();
            builder = ImmutableSortedMap.naturalOrder();
            oldValue = null;
            boolean replaced = false;
            for (Map.Entry entry : original.entrySet()) {
                if (((Comparable)entry.getKey()).equals(key)) {
                    oldValue = entry.getValue();
                    builder.put((Object)key, (Object)value);
                    replaced = true;
                    continue;
                }
                builder.put(entry);
            }
            if (replaced) continue;
            builder.put((Object)key, (Object)value);
        } while (!this.m_map.compareAndSet((ImmutableSortedMap<K, ImmutableMap>)original, (ImmutableSortedMap<K, ImmutableMap>)(copy = builder.build())));
        return oldValue;
    }

    @Override
    public V remove(Object key) {
        V oldValue;
        ImmutableSortedMap.Builder builder;
        ImmutableMap copy;
        ImmutableSortedMap<K, V> original;
        Preconditions.checkNotNull(key);
        do {
            original = this.m_map.get();
            builder = ImmutableSortedMap.naturalOrder();
            oldValue = null;
            for (Map.Entry entry : original.entrySet()) {
                if (((Comparable)entry.getKey()).equals(key)) {
                    oldValue = entry.getValue();
                    continue;
                }
                builder.put(entry);
            }
        } while (!this.m_map.compareAndSet((ImmutableSortedMap<K, ImmutableMap>)original, (ImmutableSortedMap<K, ImmutableMap>)(copy = builder.build())));
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        ImmutableSortedMap.Builder builder;
        ImmutableMap copy;
        ImmutableSortedMap<K, V> original;
        do {
            original = this.m_map.get();
            builder = ImmutableSortedMap.naturalOrder();
            for (Map.Entry entry : original.entrySet()) {
                if (m.containsKey(entry.getKey())) continue;
                builder.put(entry);
            }
            builder.putAll(m);
        } while (!this.m_map.compareAndSet((ImmutableSortedMap<K, ImmutableMap>)original, (ImmutableSortedMap<K, ImmutableMap>)(copy = builder.build())));
    }

    @Override
    public void clear() {
        this.m_map.set((ImmutableSortedMap<K, ImmutableMap>)ImmutableSortedMap.naturalOrder().build());
    }

    @Override
    public Map.Entry<K, V> pollFirstEntry() {
        Map.Entry<K, V> firstEntry;
        ImmutableSortedMap.Builder builder;
        ImmutableMap copy;
        ImmutableSortedMap<K, V> original;
        do {
            original = this.m_map.get();
            builder = ImmutableSortedMap.naturalOrder();
            firstEntry = original.firstEntry();
            for (Map.Entry entry : original.entrySet()) {
                if (entry.equals(firstEntry)) continue;
                builder.put(entry);
            }
        } while (!this.m_map.compareAndSet((ImmutableSortedMap<K, ImmutableMap>)original, (ImmutableSortedMap<K, ImmutableMap>)(copy = builder.build())));
        return firstEntry;
    }

    @Override
    public Map.Entry<K, V> pollLastEntry() {
        Map.Entry<K, V> lastEntry;
        ImmutableSortedMap.Builder builder;
        ImmutableMap copy;
        ImmutableSortedMap<K, V> original;
        do {
            original = this.m_map.get();
            builder = ImmutableSortedMap.naturalOrder();
            lastEntry = original.lastEntry();
            for (Map.Entry entry : original.entrySet()) {
                if (entry.equals(lastEntry)) continue;
                builder.put(entry);
            }
        } while (!this.m_map.compareAndSet((ImmutableSortedMap<K, ImmutableMap>)original, (ImmutableSortedMap<K, ImmutableMap>)(copy = builder.build())));
        return lastEntry;
    }

    @Override
    protected NavigableMap<K, V> delegate() {
        return this.m_map.get();
    }
}

