/*
 * Decompiled with CFR 0.152.
 */
package org.voltcore.utils;

import com.google_voltpatches.common.base.Preconditions;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.cliffc_voltpatches.high_scale_lib.NonBlockingHashMap;
import org.voltcore.logging.VoltLogger;
import org.voltcore.utils.CoreUtils;
import sun.misc.Cleaner;
import sun.nio.ch.DirectBuffer;

public final class DBBPool {
    private static final VoltLogger TRACE = new VoltLogger("DBBPOOL");
    private static final VoltLogger HOST = new VoltLogger("DBBPOOL");
    private static AtomicLong bytesAllocatedGlobally = new AtomicLong(0L);
    private static final VoltLogger m_logger = new VoltLogger(DBBPool.class.getName());
    private static final NonBlockingHashMap<Integer, ConcurrentLinkedQueue<BBContainer>> m_pooledBuffers = new NonBlockingHashMap();

    public static final BBContainer dummyWrapBB(ByteBuffer b) {
        return new BBWrapperContainer(b);
    }

    public static final BBContainer wrapBB(ByteBuffer b) {
        if (b.isDirect()) {
            return new DBBWrapperContainer(b);
        }
        return new BBWrapperContainer(b);
    }

    public static final MBBContainer wrapMBB(ByteBuffer b) {
        Preconditions.checkArgument(b.isDirect());
        return new MBBContainer((MappedByteBuffer)b);
    }

    static long getBytesAllocatedGlobally() {
        return bytesAllocatedGlobally.get();
    }

    public static native int getBufferCRC32C(ByteBuffer var0, int var1, int var2);

    public static native int getCRC32C(long var0, int var2, int var3);

    public static native int getBufferCRC32(ByteBuffer var0, int var1, int var2);

    public static native int getCRC32(long var0, int var2, int var3);

    public static native int getMurmur3128(long var0, int var2, int var3);

    public static native int getMurmur3128(long var0);

    static int roundToClosestPowerOf2(int capacity) {
        if (capacity == 0) {
            return 0;
        }
        if (capacity == 1) {
            return 2;
        }
        int result = Integer.highestOneBit(capacity - 1) << 1;
        return result < 0 ? capacity : result;
    }

    public static BBContainer allocateDirectAndPool(Integer capacity) {
        BBContainer cont;
        final int bucket = DBBPool.roundToClosestPowerOf2(capacity);
        ConcurrentLinkedQueue<BBContainer> pooledBuffers = m_pooledBuffers.get(bucket);
        if (pooledBuffers == null) {
            pooledBuffers = new ConcurrentLinkedQueue();
            if (m_pooledBuffers.putIfAbsent(bucket, pooledBuffers) != null) {
                pooledBuffers = m_pooledBuffers.get(bucket);
            }
        }
        if ((cont = pooledBuffers.poll()) == null) {
            cont = DBBPool.allocateDirect(bucket);
        }
        final BBContainer origin = cont;
        cont = new BBContainer(origin.b()){

            @Override
            public void discard() {
                this.checkDoubleFree();
                ((ConcurrentLinkedQueue)m_pooledBuffers.get(bucket)).offer(origin);
            }
        };
        cont.b().clear();
        cont.b().limit(capacity);
        return cont;
    }

    private static void clear() {
        long startingBytes = bytesAllocatedGlobally.get();
        for (ConcurrentLinkedQueue<BBContainer> pool : m_pooledBuffers.values()) {
            BBContainer cont = null;
            while ((cont = pool.poll()) != null) {
                cont.discard();
            }
        }
        new VoltLogger("HOST").warn("Attempted to resolve DirectByteBuffer OOM by freeing pooled buffers. Starting bytes was " + startingBytes + " after clearing " + bytesAllocatedGlobally.get() + " change " + (startingBytes - bytesAllocatedGlobally.get()));
    }

    private static void logAllocation(int capacity) {
        if (TRACE.isTraceEnabled()) {
            String message = "Allocated DBB capacity " + capacity + " total allocated " + bytesAllocatedGlobally.get() + " from " + CoreUtils.throwableToString(new Throwable());
            TRACE.trace(message);
        }
    }

    private static void logDeallocation(int capacity) {
        if (TRACE.isTraceEnabled()) {
            String message = "Deallocated DBB capacity " + capacity + " total allocated " + bytesAllocatedGlobally.get() + " from " + CoreUtils.throwableToString(new Throwable());
            TRACE.trace(message);
        }
    }

    public static BBContainer allocateDirect(int capacity) {
        ByteBuffer retval = null;
        try {
            retval = ByteBuffer.allocateDirect(capacity);
        }
        catch (OutOfMemoryError e) {
            if (e.getMessage().contains("Direct buffer memory")) {
                DBBPool.clear();
                retval = ByteBuffer.allocateDirect(capacity);
            }
            throw new Error(e);
        }
        bytesAllocatedGlobally.getAndAdd(capacity);
        DBBPool.logAllocation(capacity);
        return new DeallocatingContainer(retval);
    }

    private static void crash(String msg, boolean stackTrace, Throwable e) {
        try {
            Class<?> vdbClz = Class.forName("org.voltdb.VoltDB");
            Method m = vdbClz.getMethod("crashLocalVoltDB", String.class, Boolean.TYPE, Throwable.class);
            m.invoke(null, msg, stackTrace, e);
        }
        catch (Exception ignored) {
            HOST.fatal(msg, ignored);
            System.err.println(msg);
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public static void registerUnsafeMemory(long pointer) {
    }

    private static void deleteCharArrayMemory(long pointer) {
        DBBPool.nativeDeleteCharArrayMemory(pointer);
    }

    private static native void nativeDeleteCharArrayMemory(long var0);

    public static BBContainer allocateUnsafeByteBuffer(long size) {
        BBContainer retcont = DBBPool.wrapBB(DBBPool.nativeAllocateUnsafeByteBuffer(size));
        return retcont;
    }

    private static native ByteBuffer nativeAllocateUnsafeByteBuffer(long var0);

    private static void cleanByteBuffer(ByteBuffer buf) {
        if (buf == null) {
            return;
        }
        if (!buf.isDirect()) {
            return;
        }
        DirectBuffer dbuf = (DirectBuffer)((Object)buf);
        Cleaner cleaner = dbuf.cleaner();
        if (cleaner != null) {
            cleaner.clean();
        } else {
            DBBPool.deleteCharArrayMemory(dbuf.address());
        }
    }

    private static class DeallocatingContainer
    extends BBContainer {
        private DeallocatingContainer(ByteBuffer buf) {
            super(buf);
        }

        @Override
        public void discard() {
            ByteBuffer buf = this.checkDoubleFree();
            try {
                bytesAllocatedGlobally.getAndAdd(-buf.capacity());
                DBBPool.logDeallocation(buf.capacity());
                DBBPool.cleanByteBuffer(buf);
            }
            catch (Throwable e) {
                DBBPool.crash("Failed to deallocate direct byte buffer", false, e);
            }
        }
    }

    public static class MBBContainer
    extends BBContainer {
        private MBBContainer(MappedByteBuffer buf) {
            super(buf);
        }

        @Override
        public MappedByteBuffer b() {
            return (MappedByteBuffer)super.b();
        }

        @Override
        public void discard() {
            ByteBuffer buf = this.checkDoubleFree();
            DBBPool.cleanByteBuffer(buf);
        }
    }

    public static final class DBBWrapperContainer
    extends BBContainer {
        private DBBWrapperContainer(ByteBuffer b) {
            super(b);
        }

        @Override
        public final void discard() {
            ByteBuffer buf = this.checkDoubleFree();
            DBBPool.cleanByteBuffer(buf);
        }
    }

    public static final class BBWrapperContainer
    extends BBContainer {
        private BBWrapperContainer(ByteBuffer b) {
            super(b);
        }

        @Override
        public final void discard() {
            super.discard();
        }
    }

    public static abstract class BBContainer {
        private final ByteBuffer b;
        private boolean m_previouslyFreed = false;

        public BBContainer(ByteBuffer b) {
            this.b = b;
        }

        public final long address() {
            this.checkUseAfterFree();
            return ((DirectBuffer)((Object)this.b)).address();
        }

        public void discard() {
            this.checkDoubleFree();
        }

        public ByteBuffer b() {
            this.checkUseAfterFree();
            return this.b;
        }

        public final ByteBuffer bD() {
            return this.b().duplicate();
        }

        public final ByteBuffer bDR() {
            return this.b().asReadOnlyBuffer();
        }

        protected final void checkUseAfterFree() {
            if (this.m_previouslyFreed) {
                DBBPool.crash("Use after free in DBBPool", true, null);
            }
        }

        protected final ByteBuffer checkDoubleFree() {
            if (this.m_previouslyFreed) {
                DBBPool.crash("Double free in DBBPool", true, null);
            }
            this.m_previouslyFreed = true;
            return this.b;
        }

        public final void tag(String tag) {
        }

        public final void addToTagTrail(String tag) {
        }

        public boolean isTagged() {
            return false;
        }
    }
}

