/*
 * Decompiled with CFR 0.152.
 */
package org.voltcore.utils;

import org.voltcore.logging.VoltLogger;
import org.voltcore.utils.EstTime;

public class EstTimeUpdater {
    public static final long maxErrorReportInterval = 60000L;
    public static long lastErrorReport = System.currentTimeMillis() - 60000L;
    public static final int ESTIMATED_TIME_UPDATE_FREQUENCY = Integer.getInteger("ESTIMATED_TIME_UPDATE_FREQUENCY", 5);
    public static final int ESTIMATED_TIME_WARN_INTERVAL = Integer.getInteger("ESTIMATED_TIME_WARN_INTERVAL", 2000);
    public static volatile boolean pause = false;
    private static final Thread updater = new Thread("Estimated Time Updater"){

        @Override
        public void run() {
            while (true) {
                Long delta;
                try {
                    Thread.sleep(ESTIMATED_TIME_UPDATE_FREQUENCY);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (pause || (delta = EstTimeUpdater.update(System.currentTimeMillis())) == null) continue;
                new VoltLogger("HOST").info(delta + " estimated time update.");
            }
        }
    };

    public static Long update(long now) {
        long estNow = EstTime.m_now;
        if (estNow == now) {
            return null;
        }
        EstTime.m_now = now;
        if (now - estNow > (long)ESTIMATED_TIME_WARN_INTERVAL) {
            if (lastErrorReport > now) {
                lastErrorReport = now;
            }
            if (now - lastErrorReport > 60000L) {
                lastErrorReport = now;
                return now - estNow;
            }
        }
        return null;
    }

    static {
        updater.setDaemon(true);
        updater.start();
    }
}

