/*
 * Decompiled with CFR 0.152.
 */
package org.voltcore.utils;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.json_voltpatches.JSONException;
import org.json_voltpatches.JSONObject;
import org.json_voltpatches.JSONStringer;

public class InstanceId {
    private final int m_coord;
    private final long m_timestamp;

    public InstanceId(int coord, long timestamp) {
        this.m_coord = coord;
        this.m_timestamp = timestamp;
    }

    public InstanceId(JSONObject jsObj) throws JSONException {
        this.m_coord = jsObj.getInt("coord");
        this.m_timestamp = jsObj.getLong("timestamp");
    }

    public int getCoord() {
        return this.m_coord;
    }

    public long getTimestamp() {
        return this.m_timestamp;
    }

    public int hashCode() {
        MessageDigest md;
        ByteBuffer buf = ByteBuffer.allocate(12);
        buf.putLong(this.m_timestamp);
        buf.putInt(this.m_coord);
        buf.flip();
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return 0;
        }
        md.update(buf);
        byte[] digest = md.digest();
        return ByteBuffer.wrap(digest).getInt();
    }

    public JSONObject serializeToJSONObject() throws JSONException {
        JSONStringer stringer = new JSONStringer();
        stringer.object();
        stringer.key("coord").value(this.m_coord);
        stringer.key("timestamp").value(this.m_timestamp);
        stringer.endObject();
        return new JSONObject(stringer.toString());
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        if (rhs == this) {
            return true;
        }
        if (!(rhs instanceof InstanceId)) {
            return false;
        }
        InstanceId other = (InstanceId)rhs;
        return this.m_coord == other.m_coord && this.m_timestamp == other.m_timestamp;
    }
}

