/*
 * Decompiled with CFR 0.152.
 */
package org.voltcore.utils;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.voltcore.logging.Level;
import org.voltcore.logging.VoltLogger;
import org.voltcore.utils.RateLimitedLogger;

public class LatencyWatchdog
extends Thread {
    private static final VoltLogger LOG = new VoltLogger("HOST");
    private static ThreadLocal<AtomicLong> sLatencyVal = new ThreadLocal<AtomicLong>(){

        @Override
        public AtomicLong initialValue() {
            AtomicLong retval = new AtomicLong();
            sLatencyMap.put(Thread.currentThread(), retval);
            return retval;
        }
    };
    private static ConcurrentHashMap<Thread, AtomicLong> sLatencyMap = new ConcurrentHashMap();
    private static final long WATCHDOG_THRESHOLD = Long.getLong("WATCHDOG_THRESHOLD", 100L);
    private static final long WAKEUP_INTERVAL = Long.getLong("WAKEUP_INTERVAL", 25L);
    private static final long MIN_LOG_INTERVAL = Long.getLong("MIN_LOG_INTERVAL", 10000L);
    static LatencyWatchdog sWatchdog;
    public static final boolean sEnable;

    public static void pet() {
        if (!sEnable) {
            return;
        }
        LatencyWatchdog.petImpl();
    }

    private static void petImpl() {
        sLatencyVal.get().lazySet(System.currentTimeMillis());
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        Thread.currentThread().setName("Latency Watchdog");
        LatencyWatchdog.LOG.info(String.format("Latency Watchdog enabled -- threshold:%d(ms) wakeup_interval:%d(ms) min_log_interval:%d(ms)\n", new Object[]{LatencyWatchdog.WATCHDOG_THRESHOLD, LatencyWatchdog.WAKEUP_INTERVAL, LatencyWatchdog.MIN_LOG_INTERVAL}));
        while (true) lbl-1000:
        // 5 sources

        {
            for (Map.Entry<Thread, AtomicLong> entry : LatencyWatchdog.sLatencyMap.entrySet()) {
                t = entry.getKey();
                timestamp = entry.getValue().get();
                now = System.currentTimeMillis();
                if (now - timestamp <= LatencyWatchdog.WATCHDOG_THRESHOLD || t.getState() == Thread.State.TERMINATED) continue;
                sb = new StringBuilder();
                format = t.getName() + " has been delayed for more than " + LatencyWatchdog.WATCHDOG_THRESHOLD + " milliseconds\n %s";
                for (StackTraceElement ste : t.getStackTrace()) {
                    sb.append(ste);
                    sb.append("\n");
                }
                RateLimitedLogger.tryLogForMessage(now, LatencyWatchdog.MIN_LOG_INTERVAL, TimeUnit.MILLISECONDS, LatencyWatchdog.LOG, Level.INFO, format, new Object[]{sb.toString()});
            }
            try {
                Thread.sleep(LatencyWatchdog.WAKEUP_INTERVAL);
                ** continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    static {
        sEnable = Boolean.getBoolean("ENABLE_LATENCY_WATCHDOG");
        if (sEnable) {
            sWatchdog = new LatencyWatchdog();
            sWatchdog.start();
        }
    }
}

