/*
 * Decompiled with CFR 0.152.
 */
package org.voltcore.utils;

public class Pair<T, U> {
    protected final T m_first;
    protected final U m_second;
    protected final transient int m_hash;

    public Pair(T first, U second, boolean hash) {
        this.m_first = first;
        this.m_second = second;
        this.m_hash = hash ? (first == null ? 0 : first.hashCode() * 31) + (second == null ? 0 : second.hashCode()) : 0;
    }

    public Pair(T first, U second) {
        this(first, second, true);
    }

    public String toString() {
        return "<" + this.m_first.toString() + ", " + this.m_second.toString() + ">";
    }

    public int hashCode() {
        return this.m_hash;
    }

    public Object get(int idx) {
        if (idx == 0) {
            return this.m_first;
        }
        if (idx == 1) {
            return this.m_second;
        }
        return null;
    }

    public boolean contains(Object o) {
        if (this.m_first != null && this.m_first.equals(o)) {
            return true;
        }
        if (this.m_second != null && this.m_second.equals(o)) {
            return true;
        }
        if (o != null) {
            return false;
        }
        return this.m_first == null || this.m_second == null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !this.getClass().isInstance(o)) {
            return false;
        }
        Pair other = (Pair)o;
        return (this.m_first == null ? other.m_first == null : this.m_first.equals(other.m_first)) && (this.m_second == null ? other.m_second == null : this.m_second.equals(other.m_second));
    }

    public T getFirst() {
        return this.m_first;
    }

    public U getSecond() {
        return this.m_second;
    }

    public static <T, U> Pair<T, U> of(T x, U y) {
        return new Pair<T, U>(x, y);
    }
}

