/*
 * Decompiled with CFR 0.152.
 */
package org.voltcore.utils;

import com.google_voltpatches.common.base.Throwables;
import com.google_voltpatches.common.cache.Cache;
import com.google_voltpatches.common.cache.CacheBuilder;
import java.util.Arrays;
import java.util.IllegalFormatConversionException;
import java.util.MissingFormatArgumentException;
import java.util.UnknownFormatConversionException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.voltcore.logging.Level;
import org.voltcore.logging.VoltLogger;

public class RateLimitedLogger {
    private volatile long m_lastLogTime = 0L;
    private final long m_maxLogIntervalMillis;
    private final VoltLogger m_logger;
    private final Level m_level;
    private static final Cache<String, RateLimitedLogger> m_loggersCached = CacheBuilder.newBuilder().maximumSize(1000L).build();

    public RateLimitedLogger(long maxLogIntervalMillis, VoltLogger logger, Level level) {
        this.m_maxLogIntervalMillis = maxLogIntervalMillis;
        this.m_logger = logger;
        this.m_level = level;
    }

    public void log(String message, long now) {
        this.log(message, now, this.m_level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(String message, long now, Level level) {
        if (now - this.m_lastLogTime > this.m_maxLogIntervalMillis) {
            RateLimitedLogger rateLimitedLogger = this;
            synchronized (rateLimitedLogger) {
                if (now - this.m_lastLogTime > this.m_maxLogIntervalMillis) {
                    switch (level) {
                        case DEBUG: {
                            this.m_logger.debug(message);
                            break;
                        }
                        case ERROR: {
                            this.m_logger.error(message);
                            break;
                        }
                        case FATAL: {
                            this.m_logger.fatal(message);
                            break;
                        }
                        case INFO: {
                            this.m_logger.info(message);
                            break;
                        }
                        case TRACE: {
                            this.m_logger.trace(message);
                            break;
                        }
                        case WARN: {
                            this.m_logger.warn(message);
                        }
                    }
                    this.m_lastLogTime = now;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(long now, Level level, Throwable cause, String stemformat, Object ... args) {
        if (now - this.m_lastLogTime > this.m_maxLogIntervalMillis) {
            RateLimitedLogger rateLimitedLogger = this;
            synchronized (rateLimitedLogger) {
                if (now - this.m_lastLogTime > this.m_maxLogIntervalMillis) {
                    String message = this.formatMessage(cause, stemformat, args);
                    switch (level) {
                        case DEBUG: {
                            this.m_logger.debug(message);
                            break;
                        }
                        case ERROR: {
                            this.m_logger.error(message);
                            break;
                        }
                        case FATAL: {
                            this.m_logger.fatal(message);
                            break;
                        }
                        case INFO: {
                            this.m_logger.info(message);
                            break;
                        }
                        case TRACE: {
                            this.m_logger.trace(message);
                            break;
                        }
                        case WARN: {
                            this.m_logger.warn(message);
                        }
                    }
                    this.m_lastLogTime = now;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String formatMessage(Throwable cause, String stemformat, Object ... args) {
        String format = stemformat;
        if (cause != null) {
            format = new StringBuilder(stemformat.length() + 8).append(stemformat).append("\n%s").toString().intern();
            args = Arrays.copyOf(args, args.length + 1);
            args[args.length - 1] = Throwables.getStackTraceAsString(cause);
        }
        String msg = null;
        try {
            msg = String.format(format, args);
        }
        catch (MissingFormatArgumentException ex) {
            this.m_logger.error("failed to format log message. Format: " + format + ", arguments: " + Arrays.toString(args), ex);
        }
        catch (IllegalFormatConversionException ex) {
            this.m_logger.error("failed to format log message. Format: " + format + ", arguments: " + Arrays.toString(args), ex);
        }
        catch (UnknownFormatConversionException ex) {
            this.m_logger.error("failed to format log message. Format: " + format + ", arguments: " + Arrays.toString(args), ex);
        }
        finally {
            if (msg == null) {
                msg = "Format: " + format + ", arguments: " + Arrays.toString(args);
            }
        }
        return msg;
    }

    public static void tryLogForMessage(long now, final long maxLogInterval, final TimeUnit maxLogIntervalUnit, final VoltLogger logger, final Level level, String format, Object ... parameters) {
        Callable<RateLimitedLogger> builder = new Callable<RateLimitedLogger>(){

            @Override
            public RateLimitedLogger call() throws Exception {
                return new RateLimitedLogger(maxLogIntervalUnit.toMillis(maxLogInterval), logger, level);
            }
        };
        try {
            RateLimitedLogger rll = m_loggersCached.get(format, builder);
            rll.log(now, level, null, format, parameters);
        }
        catch (ExecutionException ex) {
            Throwables.propagate(Throwables.getRootCause(ex));
        }
    }

    public static void tryLogForMessage(long now, final long maxLogInterval, final TimeUnit maxLogIntervalUnit, final VoltLogger logger, final Level level, Throwable cause, String stemformat, Object ... parameters) {
        Callable<RateLimitedLogger> builder = new Callable<RateLimitedLogger>(){

            @Override
            public RateLimitedLogger call() throws Exception {
                return new RateLimitedLogger(maxLogIntervalUnit.toMillis(maxLogInterval), logger, level);
            }
        };
        try {
            RateLimitedLogger rll = m_loggersCached.get(stemformat, builder);
            rll.log(now, level, cause, stemformat, parameters);
        }
        catch (ExecutionException ex) {
            Throwables.propagate(Throwables.getRootCause(ex));
        }
    }
}

