/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.json_voltpatches.JSONException;
import org.json_voltpatches.JSONString;
import org.json_voltpatches.JSONStringer;
import org.voltdb.VoltTable;
import org.voltdb.VoltType;
import org.voltdb.client.ClientResponse;
import org.voltdb.client.ClientUtils;
import org.voltdb.common.Constants;
import org.voltdb.utils.SerializationHelper;

public class ClientResponseImpl
implements ClientResponse,
JSONString {
    private boolean setProperly = false;
    private byte status = 0;
    private String statusString = null;
    private byte[] encodedStatusString;
    private byte appStatus = (byte)-128;
    private String appStatusString = null;
    private byte[] encodedAppStatusString;
    private VoltTable[] results = new VoltTable[0];
    private Integer m_hash = null;
    private int clusterRoundTripTime = 0;
    private int clientRoundTripTime = 0;
    private long clientRoundTripTimeNanos = 0L;
    static final String JSON_STATUS_KEY = "status";
    static final String JSON_STATUSSTRING_KEY = "statusstring";
    static final String JSON_APPSTATUS_KEY = "appstatus";
    static final String JSON_APPSTATUSSTRING_KEY = "appstatusstring";
    static final String JSON_RESULTS_KEY = "results";
    static final String JSON_TYPE_KEY = "type";
    static final String JSON_EXCEPTION_KEY = "exception";
    public static final String IGNORED_TRANSACTION = "Ignored replayed transaction";
    private long clientHandle = -1L;

    public ClientResponseImpl() {
    }

    public ClientResponseImpl(byte status, byte appStatus, String appStatusString, VoltTable[] results, String statusString) {
        this(status, appStatus, appStatusString, results, statusString, -1L);
    }

    public ClientResponseImpl(byte status, VoltTable[] results, String statusString) {
        this(status, -128, null, results, statusString, -1L);
    }

    public ClientResponseImpl(byte status, VoltTable[] results, String statusString, long handle) {
        this(status, -128, null, results, statusString, handle);
    }

    ClientResponseImpl(byte status, byte appStatus, String appStatusString, VoltTable[] results, String statusString, long handle) {
        this.appStatus = appStatus;
        this.appStatusString = appStatusString;
        this.setResults(status, results, statusString);
        this.clientHandle = handle;
    }

    private void setResults(byte status, VoltTable[] results, String statusString) {
        assert (results != null);
        for (VoltTable result : results) {
            assert (result != null);
        }
        this.status = status;
        this.results = results;
        this.statusString = statusString;
        this.setProperly = true;
    }

    public void setHash(Integer hash) {
        this.m_hash = hash;
    }

    @Override
    public byte getStatus() {
        return this.status;
    }

    @Override
    public VoltTable[] getResults() {
        return this.results;
    }

    @Override
    public String getStatusString() {
        return this.statusString;
    }

    public void setClientHandle(long aHandle) {
        this.clientHandle = aHandle;
    }

    public long getClientHandle() {
        return this.clientHandle;
    }

    public Integer getHash() {
        return this.m_hash;
    }

    public void initFromBuffer(ByteBuffer buf) throws IOException {
        buf.get();
        this.clientHandle = buf.getLong();
        byte presentFields = buf.get();
        this.status = buf.get();
        this.statusString = (presentFields & 0x20) != 0 ? SerializationHelper.getString(buf) : null;
        this.appStatus = buf.get();
        this.appStatusString = (presentFields & 0x80) != 0 ? SerializationHelper.getString(buf) : null;
        this.clusterRoundTripTime = buf.getInt();
        if ((presentFields & 0x40) != 0) {
            throw new RuntimeException("Use of deprecated exception in Client Response serialization.");
        }
        this.m_hash = (presentFields & 0x10) != 0 ? Integer.valueOf(buf.getInt()) : null;
        int tableCount = buf.getShort();
        this.results = new VoltTable[tableCount];
        for (int i = 0; i < tableCount; ++i) {
            int tableSize = buf.getInt();
            int originalLimit = buf.limit();
            buf.limit(buf.position() + tableSize);
            ByteBuffer slice = buf.slice();
            buf.position(buf.position() + tableSize);
            buf.limit(originalLimit);
            this.results[i] = new VoltTable(slice, false);
        }
        this.setProperly = true;
    }

    public int getSerializedSize() {
        int msgsize = 18;
        if (this.appStatusString != null) {
            this.encodedAppStatusString = this.appStatusString.getBytes(Constants.UTF8ENCODING);
            msgsize += this.encodedAppStatusString.length + 4;
        }
        if (this.statusString != null) {
            this.encodedStatusString = this.statusString.getBytes(Constants.UTF8ENCODING);
            msgsize += this.encodedStatusString.length + 4;
        }
        if (this.m_hash != null) {
            msgsize += 4;
        }
        for (VoltTable vt : this.results) {
            msgsize += vt.getSerializedSize();
        }
        return msgsize;
    }

    public ByteBuffer flattenToBuffer(ByteBuffer buf) {
        assert (this.setProperly);
        buf.put((byte)0);
        buf.putLong(this.clientHandle);
        byte presentFields = 0;
        if (this.appStatusString != null) {
            presentFields = (byte)(presentFields | 0x80);
        }
        if (this.statusString != null) {
            presentFields = (byte)(presentFields | 0x20);
        }
        if (this.m_hash != null) {
            presentFields = (byte)(presentFields | 0x10);
        }
        buf.put(presentFields);
        buf.put(this.status);
        if (this.statusString != null) {
            buf.putInt(this.encodedStatusString.length);
            buf.put(this.encodedStatusString);
        }
        buf.put(this.appStatus);
        if (this.appStatusString != null) {
            buf.putInt(this.encodedAppStatusString.length);
            buf.put(this.encodedAppStatusString);
        }
        buf.putInt(this.clusterRoundTripTime);
        if (this.m_hash != null) {
            buf.putInt(this.m_hash);
        }
        buf.putShort((short)this.results.length);
        for (VoltTable vt : this.results) {
            vt.flattenToBuffer(buf);
        }
        return buf;
    }

    @Override
    public int getClusterRoundtrip() {
        return this.clusterRoundTripTime;
    }

    public void setClusterRoundtrip(int time) {
        this.clusterRoundTripTime = time;
    }

    @Override
    public int getClientRoundtrip() {
        return this.clientRoundTripTime;
    }

    @Override
    public long getClientRoundtripNanos() {
        return this.clientRoundTripTimeNanos;
    }

    public void setClientRoundtrip(long timeNanos) {
        this.clientRoundTripTimeNanos = timeNanos;
        this.clientRoundTripTime = (int)TimeUnit.NANOSECONDS.toMillis(timeNanos);
    }

    @Override
    public byte getAppStatus() {
        return this.appStatus;
    }

    @Override
    public String getAppStatusString() {
        return this.appStatusString;
    }

    public boolean isTransactionallySuccessful() {
        return ClientResponseImpl.isTransactionallySuccessful(this.status);
    }

    public static boolean isTransactionallySuccessful(byte status) {
        return status == 1 || status == -9;
    }

    @Override
    public String toJSONString() {
        JSONStringer js = new JSONStringer();
        try {
            js.object();
            js.key(JSON_STATUS_KEY);
            js.value(this.status);
            js.key(JSON_APPSTATUS_KEY);
            js.value(this.appStatus);
            js.key(JSON_STATUSSTRING_KEY);
            js.value(this.statusString);
            js.key(JSON_APPSTATUSSTRING_KEY);
            js.value(this.appStatusString);
            js.key(JSON_RESULTS_KEY);
            js.array();
            for (VoltTable o : this.results) {
                js.value(o);
            }
            js.endArray();
            js.endObject();
        }
        catch (JSONException e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to serialized a parameter set to JSON.", e);
        }
        return js.toString();
    }

    public int getHashOfTableResults() {
        try {
            long cheesyChecksum = 0L;
            for (int i = 0; i < this.results.length; ++i) {
                cheesyChecksum += ClientUtils.cheesyBufferCheckSum(this.results[i].m_buffer);
            }
            return (int)cheesyChecksum;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public void convertResultsToHashForDeterminism() {
        int hash = this.m_hash == null ? 0 : this.m_hash;
        VoltTable t = new VoltTable(new VoltTable.ColumnInfo("", VoltType.INTEGER), new VoltTable.ColumnInfo[0]);
        t.addRow(hash);
        this.results = new VoltTable[]{t};
    }

    public void dropResultTable() {
        this.results = new VoltTable[0];
    }
}

