/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.regex.Pattern;
import org.voltdb.VoltTable;
import org.voltdb.VoltType;
import org.voltdb.VoltTypeException;
import org.voltdb.common.Constants;
import org.voltdb.parser.SQLParser;
import org.voltdb.types.TimestampType;
import org.voltdb.types.VoltDecimalHelper;
import org.voltdb.utils.Encoder;

public class ParameterConverter {
    private static final Pattern thousandSeparator = Pattern.compile("\\,");

    private static Object nullValueForType(Class<?> expectedClz) {
        if (expectedClz == Long.TYPE) {
            return Long.MIN_VALUE;
        }
        if (expectedClz == Integer.TYPE) {
            return Integer.MIN_VALUE;
        }
        if (expectedClz == Short.TYPE) {
            return (short)Short.MIN_VALUE;
        }
        if (expectedClz == Byte.TYPE) {
            return (byte)-128;
        }
        if (expectedClz == Double.TYPE) {
            return -1.7E308;
        }
        return null;
    }

    public static boolean verifyParameterConversion(Object value, Class<?> expectedClz) {
        if (expectedClz == Long.TYPE) {
            assert (value != null);
            assert (value.getClass() == Long.class);
        } else if (expectedClz == Integer.TYPE) {
            assert (value != null);
            assert (value.getClass() == Integer.class);
        } else if (expectedClz == Short.TYPE) {
            assert (value != null);
            assert (value.getClass() == Short.class);
        } else if (expectedClz == Byte.TYPE) {
            assert (value != null);
            assert (value.getClass() == Byte.class);
        } else if (expectedClz == Double.TYPE) {
            assert (value != null);
            assert (value.getClass() == Double.class);
        } else if (value != null) {
            Class<?> clz = value.getClass();
            if (clz != expectedClz) {
                return expectedClz.getSimpleName().equals("SystemProcedureExecutionContext") && expectedClz.isAssignableFrom(clz);
            }
            if (expectedClz.isArray()) assert (clz.getComponentType() == expectedClz.getComponentType());
        }
        return true;
    }

    private static Object convertStringToPrimitive(String value, Class<?> expectedClz) throws VoltTypeException {
        block10: {
            if ((value = value.trim()).equals("\\N")) {
                return ParameterConverter.nullValueForType(expectedClz);
            }
            String commaFreeValue = thousandSeparator.matcher(value).replaceAll("");
            try {
                if (expectedClz == Long.TYPE) {
                    return Long.parseLong(commaFreeValue);
                }
                if (expectedClz == Integer.TYPE) {
                    return Integer.parseInt(commaFreeValue);
                }
                if (expectedClz == Short.TYPE) {
                    return Short.parseShort(commaFreeValue);
                }
                if (expectedClz == Byte.TYPE) {
                    return Byte.parseByte(commaFreeValue);
                }
                if (expectedClz == Double.TYPE) {
                    return Double.parseDouble(commaFreeValue);
                }
            }
            catch (NumberFormatException nfe) {
                String hexDigits;
                if (expectedClz == Double.TYPE || (hexDigits = SQLParser.getDigitsFromHexLiteral(value)) == null) break block10;
                try {
                    return SQLParser.hexDigitsToLong(hexDigits);
                }
                catch (SQLParser.Exception spe) {
                    // empty catch block
                }
            }
        }
        throw new VoltTypeException("tryToMakeCompatible: Unable to convert string " + value + " to " + expectedClz.getName() + " value for target parameter.");
    }

    private static Object tryToMakeCompatibleArray(Class<?> expectedComponentClz, Class<?> inputComponentClz, Object param) throws VoltTypeException {
        int inputLength = Array.getLength(param);
        if (inputComponentClz == expectedComponentClz) {
            return param;
        }
        if (inputLength == 0) {
            return Array.newInstance(expectedComponentClz, 0);
        }
        if (inputComponentClz == byte[].class && expectedComponentClz == String.class) {
            String[] values = new String[inputLength];
            for (int i = 0; i < inputLength; ++i) {
                try {
                    values[i] = new String((byte[])Array.get(param, i), "UTF-8");
                    continue;
                }
                catch (UnsupportedEncodingException ex) {
                    throw new VoltTypeException("tryScalarMakeCompatible: Unsupported encoding:" + expectedComponentClz.getName() + " to provided " + inputComponentClz.getName());
                }
            }
            return values;
        }
        if (inputComponentClz == String.class && expectedComponentClz == byte[].class) {
            byte[][] values = new byte[inputLength][];
            for (int i = 0; i < inputLength; ++i) {
                values[i] = Encoder.hexDecode((String)Array.get(param, i));
            }
            return values;
        }
        throw new VoltTypeException("tryScalarMakeCompatible: Unable to match parameter array:" + expectedComponentClz.getName() + " to provided " + inputComponentClz.getName());
    }

    public static Object tryToMakeCompatible(Class<?> expectedClz, Object param) throws VoltTypeException {
        if (param == null) {
            return ParameterConverter.nullValueForType(expectedClz);
        }
        Class<?> inputClz = param.getClass();
        Number numberParam = null;
        if (inputClz == Long.class) {
            if (expectedClz == Long.TYPE) {
                return param;
            }
            if ((Long)param == Long.MIN_VALUE) {
                return ParameterConverter.nullValueForType(expectedClz);
            }
            numberParam = (Number)param;
        } else if (inputClz == Integer.class) {
            if (expectedClz == Integer.TYPE) {
                return param;
            }
            if ((Integer)param == Integer.MIN_VALUE) {
                return ParameterConverter.nullValueForType(expectedClz);
            }
            if (expectedClz == Long.TYPE) {
                return ((Integer)param).longValue();
            }
            numberParam = (Number)param;
        } else if (inputClz == Short.class) {
            if (expectedClz == Short.TYPE) {
                return param;
            }
            if ((Short)param == Short.MIN_VALUE) {
                return ParameterConverter.nullValueForType(expectedClz);
            }
            if (expectedClz == Long.TYPE) {
                return ((Short)param).longValue();
            }
            if (expectedClz == Integer.TYPE) {
                return ((Short)param).intValue();
            }
            numberParam = (Number)param;
        } else if (inputClz == Byte.class) {
            if (expectedClz == Byte.TYPE) {
                return param;
            }
            if ((Byte)param == -128) {
                return ParameterConverter.nullValueForType(expectedClz);
            }
            if (expectedClz == Long.TYPE) {
                return ((Byte)param).longValue();
            }
            if (expectedClz == Integer.TYPE) {
                return ((Byte)param).intValue();
            }
            if (expectedClz == Short.TYPE) {
                return ((Byte)param).shortValue();
            }
            numberParam = (Number)param;
        } else if (inputClz == Double.class) {
            if (expectedClz == Double.TYPE) {
                return param;
            }
            if ((Double)param == -1.7E308) {
                return ParameterConverter.nullValueForType(expectedClz);
            }
        } else if (inputClz == String.class) {
            String stringParam = (String)param;
            if (stringParam.equals("\\N")) {
                return ParameterConverter.nullValueForType(expectedClz);
            }
            if (expectedClz == String.class) {
                return param;
            }
            if (expectedClz == byte[].class) {
                String hexDigits;
                if ((stringParam.startsWith("X") || stringParam.startsWith("x")) && (hexDigits = SQLParser.getDigitsFromHexLiteral(stringParam)) != null) {
                    stringParam = hexDigits;
                }
                return Encoder.hexDecode(stringParam);
            }
            if (expectedClz.isPrimitive()) {
                return ParameterConverter.convertStringToPrimitive(stringParam, expectedClz);
            }
        } else if (inputClz == byte[].class) {
            if (expectedClz == byte[].class) {
                return param;
            }
            if (expectedClz == String.class) {
                String value = new String((byte[])param, Constants.UTF8ENCODING);
                if (value.equals("\\N")) {
                    return ParameterConverter.nullValueForType(expectedClz);
                }
                return value;
            }
        } else if (param == VoltType.NULL_TIMESTAMP || param == VoltType.NULL_STRING_OR_VARBINARY || param == VoltType.NULL_DECIMAL) {
            return ParameterConverter.nullValueForType(expectedClz);
        }
        if (expectedClz.isArray() != inputClz.isArray()) {
            throw new VoltTypeException(String.format("Array / Scalar parameter mismatch (%s to %s)", inputClz.getName(), expectedClz.getName()));
        }
        if (expectedClz.isArray()) {
            return ParameterConverter.tryToMakeCompatibleArray(expectedClz.getComponentType(), inputClz.getComponentType(), param);
        }
        if (expectedClz == Integer.TYPE && numberParam != null) {
            long val = numberParam.longValue();
            if (val == Integer.MIN_VALUE) {
                throw new VoltTypeException("tryToMakeCompatible: The provided long value: (" + param.toString() + ") might be interpreted as integer null. " + "Try explicitly using a int parameter.");
            }
            if (val <= Integer.MAX_VALUE && val >= Integer.MIN_VALUE) {
                return numberParam.intValue();
            }
        } else if (expectedClz == Short.TYPE && numberParam != null) {
            if (inputClz == Long.class || inputClz == Integer.class) {
                long val = numberParam.longValue();
                if (val == -32768L) {
                    throw new VoltTypeException("tryToMakeCompatible: The provided int or long value: (" + param.toString() + ") might be interpreted as smallint null. " + "Try explicitly using a short parameter.");
                }
                if (val <= 32767L && val >= -32768L) {
                    return numberParam.shortValue();
                }
            }
        } else if (expectedClz == Byte.TYPE && numberParam != null) {
            if (inputClz == Long.class || inputClz == Integer.class || inputClz == Short.class) {
                long val = numberParam.longValue();
                if (val == -128L) {
                    throw new VoltTypeException("tryToMakeCompatible: The provided short, int or long value: (" + param.toString() + ") might be interpreted as tinyint null. " + "Try explicitly using a byte parameter.");
                }
                if (val <= 127L && val >= -128L) {
                    return numberParam.byteValue();
                }
            }
        } else {
            if (expectedClz == Double.TYPE && numberParam != null) {
                return numberParam.doubleValue();
            }
            if (expectedClz == TimestampType.class) {
                if (inputClz == Integer.class) {
                    return new TimestampType(((Integer)param).intValue());
                }
                if (inputClz == Long.class) {
                    return new TimestampType((Long)param);
                }
                if (inputClz == TimestampType.class) {
                    return param;
                }
                if (inputClz == java.util.Date.class) {
                    return new TimestampType((java.util.Date)param);
                }
                if (inputClz == String.class) {
                    String timestring = ((String)param).trim();
                    try {
                        return new TimestampType(Long.parseLong(timestring));
                    }
                    catch (IllegalArgumentException e) {
                        try {
                            return new TimestampType(timestring);
                        }
                        catch (IllegalArgumentException e2) {}
                    }
                }
            } else if (expectedClz == Timestamp.class) {
                if (param instanceof Timestamp) {
                    return param;
                }
                if (param instanceof java.util.Date) {
                    return new Timestamp(((java.util.Date)param).getTime());
                }
                if (param instanceof TimestampType) {
                    return ((TimestampType)param).asJavaTimestamp();
                }
                if (inputClz == String.class) {
                    String longtime = ((String)param).trim();
                    try {
                        return new Timestamp(Long.parseLong(longtime));
                    }
                    catch (IllegalArgumentException e) {
                        try {
                            return Timestamp.valueOf(longtime);
                        }
                        catch (IllegalArgumentException e3) {}
                    }
                }
            } else if (expectedClz == Date.class) {
                if (param instanceof Date) {
                    return param;
                }
                if (param instanceof java.util.Date) {
                    return new Date(((java.util.Date)param).getTime());
                }
                if (param instanceof TimestampType) {
                    return ((TimestampType)param).asExactJavaSqlDate();
                }
                if (inputClz == String.class) {
                    try {
                        return new Date(TimestampType.millisFromJDBCformat((String)param));
                    }
                    catch (IllegalArgumentException e) {}
                }
            } else if (expectedClz == java.util.Date.class) {
                if (param instanceof java.util.Date) {
                    return param;
                }
                if (param instanceof TimestampType) {
                    return ((TimestampType)param).asExactJavaDate();
                }
                if (inputClz == String.class) {
                    try {
                        return new java.util.Date(TimestampType.millisFromJDBCformat((String)param));
                    }
                    catch (IllegalArgumentException e) {}
                }
            } else {
                if (expectedClz == BigDecimal.class) {
                    if (numberParam != null) {
                        BigInteger bi = new BigInteger(param.toString());
                        BigDecimal bd = new BigDecimal(bi);
                        bd = VoltDecimalHelper.setDefaultScale(bd);
                        return bd;
                    }
                    if (inputClz == BigDecimal.class) {
                        BigDecimal bd = (BigDecimal)param;
                        bd = VoltDecimalHelper.setDefaultScale(bd);
                        return bd;
                    }
                    if (inputClz == Float.class || inputClz == Double.class) {
                        try {
                            return VoltDecimalHelper.deserializeBigDecimalFromString(String.format("%.12f", param));
                        }
                        catch (IOException ex) {
                            throw new VoltTypeException(String.format("deserialize Float from string failed. (%s to %s)", inputClz.getName(), expectedClz.getName()));
                        }
                    }
                    try {
                        return VoltDecimalHelper.deserializeBigDecimalFromString(String.valueOf(param));
                    }
                    catch (IOException ex) {
                        throw new VoltTypeException(String.format("deserialize BigDecimal from string failed. (%s to %s)", inputClz.getName(), expectedClz.getName()));
                    }
                }
                if (expectedClz == VoltTable.class && inputClz == VoltTable.class) {
                    return param;
                }
                if (expectedClz == String.class && !param.getClass().isArray()) {
                    return String.valueOf(param);
                }
            }
        }
        if (expectedClz.getSimpleName().equals("SystemProcedureExecutionContext") && expectedClz.isAssignableFrom(inputClz)) {
            return param;
        }
        throw new VoltTypeException("tryToMakeCompatible: The provided value: (" + param.toString() + ") of type: " + inputClz.getName() + " is not a match or is out of range for the target parameter type: " + expectedClz.getName());
    }

    public static Object stringToLong(Object param, Class<?> slot) throws VoltTypeException {
        try {
            if (slot == Byte.TYPE || slot == Short.TYPE || slot == Integer.TYPE || slot == Long.TYPE) {
                return Long.parseLong((String)param);
            }
            return null;
        }
        catch (NumberFormatException nfe) {
            throw new VoltTypeException("tryToMakeCompatible: Unable to convert string " + (String)param + " to " + slot.getName() + " value for target parameter " + slot.getName());
        }
    }
}

