/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb;

import java.io.IOException;
import java.math.BigDecimal;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import org.json_voltpatches.JSONArray;
import org.json_voltpatches.JSONException;
import org.json_voltpatches.JSONObject;
import org.json_voltpatches.JSONString;
import org.json_voltpatches.JSONStringer;
import org.voltdb.ParameterSet;
import org.voltdb.VoltOverflowException;
import org.voltdb.VoltTableRow;
import org.voltdb.VoltType;
import org.voltdb.VoltTypeException;
import org.voltdb.client.ClientUtils;
import org.voltdb.common.Constants;
import org.voltdb.types.TimestampType;
import org.voltdb.types.VoltDecimalHelper;
import org.voltdb.utils.Encoder;

public final class VoltTable
extends VoltTableRow
implements JSONString {
    public static final int MAX_SERIALIZED_TABLE_LENGTH = 0xA00000;
    public static final String MAX_SERIALIZED_TABLE_LENGTH_STR = String.valueOf(10240) + "k";
    static final int NULL_STRING_INDICATOR = -1;
    static final Charset METADATA_ENCODING = Constants.US_ASCII_ENCODING;
    static final Charset ROWDATA_ENCODING = Constants.UTF8ENCODING;
    static final AtomicInteger expandCountDouble = new AtomicInteger(0);
    boolean m_readOnly = false;
    int m_rowStart = -1;
    int m_rowCount = -1;
    int m_colCount = -1;
    static final String JSON_NAME_KEY = "name";
    static final String JSON_TYPE_KEY = "type";
    static final String JSON_SCHEMA_KEY = "schema";
    static final String JSON_DATA_KEY = "data";
    static final String JSON_STATUS_KEY = "status";
    final ExtraMetadata m_extraMetadata;

    VoltTable() {
        this((ExtraMetadata)null);
    }

    VoltTable(ExtraMetadata extraMetadata) {
        this.m_extraMetadata = extraMetadata;
    }

    VoltTable(ByteBuffer backing, boolean readOnly) {
        this.m_extraMetadata = null;
        this.m_buffer = backing;
        this.m_rowStart = this.m_buffer.getInt(0) + 4;
        this.m_colCount = this.m_buffer.getShort(5);
        this.m_rowCount = this.m_buffer.getInt(this.m_rowStart);
        this.m_buffer.position(this.m_buffer.limit());
        this.m_readOnly = readOnly;
        assert (this.verifyTableInvariants());
    }

    public VoltTable(ColumnInfo[] columns, int columnCount) {
        this(null, columns, columnCount);
    }

    public VoltTable(ColumnInfo[] columns) {
        this(null, columns, columns.length);
    }

    private static ColumnInfo[] prependColumn(ColumnInfo firstColumn, ColumnInfo[] columns) {
        int allLen = 1 + columns.length;
        ColumnInfo[] allColumns = new ColumnInfo[allLen];
        allColumns[0] = firstColumn;
        for (int i = 0; i < columns.length; ++i) {
            allColumns[i + 1] = columns[i];
        }
        return allColumns;
    }

    public VoltTable(ColumnInfo firstColumn, ColumnInfo ... columns) {
        this(VoltTable.prependColumn(firstColumn, columns));
    }

    VoltTable(ExtraMetadata extraMetadata, ColumnInfo[] columns, int columnCount) {
        this.m_extraMetadata = extraMetadata;
        int allocationSize = 1024;
        this.m_buffer = ByteBuffer.allocate(allocationSize);
        boolean success = false;
        while (!success) {
            try {
                int i;
                this.m_colCount = columnCount;
                this.m_rowCount = 0;
                if (columns == null) {
                    throw new RuntimeException("VoltTable(..) constructor passed null schema.");
                }
                if (columnCount <= 0) {
                    throw new RuntimeException("VoltTable(..) constructor requires at least one column.");
                }
                if (columns.length < columnCount) {
                    throw new RuntimeException("VoltTable(..) constructor passed truncated column schema array.");
                }
                this.m_buffer.putInt(0);
                this.m_buffer.put((byte)-128);
                this.m_buffer.putShort((short)columnCount);
                for (i = 0; i < columnCount; ++i) {
                    this.m_buffer.put(columns[i].type.getValue());
                }
                for (i = 0; i < columnCount; ++i) {
                    if (columns[i].name == null) {
                        this.m_buffer.position(0);
                        throw new IllegalArgumentException("VoltTable column names can not be null.");
                    }
                    this.writeStringToBuffer(columns[i].name, METADATA_ENCODING, this.m_buffer);
                }
                this.m_rowStart = this.m_buffer.position();
                this.m_buffer.putInt(0, this.m_rowStart - 4);
                this.m_buffer.putInt(0);
                this.m_buffer.limit(this.m_buffer.position());
                success = true;
            }
            catch (BufferOverflowException e) {
                this.m_buffer = ByteBuffer.allocate(allocationSize *= 4);
            }
        }
        assert (this.verifyTableInvariants());
    }

    public final void clearRowData() {
        assert (this.verifyTableInvariants());
        this.m_buffer.position(this.m_rowStart);
        this.m_buffer.putInt(0);
        this.m_rowCount = 0;
        assert (this.verifyTableInvariants());
    }

    @Override
    public VoltTableRow cloneRow() {
        Row retval = new Row(this.m_position);
        retval.m_hasCalculatedOffsets = this.m_hasCalculatedOffsets;
        retval.m_wasNull = this.m_wasNull;
        if (this.m_offsets != null) {
            for (int i = 0; i < this.m_colCount; ++i) {
                retval.m_offsets[i] = this.m_offsets[i];
            }
        }
        retval.m_activeRowIndex = this.m_activeRowIndex;
        return retval;
    }

    public final String getColumnName(int index) {
        assert (this.verifyTableInvariants());
        if (index < 0 || index >= this.m_colCount) {
            throw new IllegalArgumentException("Not a valid column index.");
        }
        int pos = 7 + this.m_colCount;
        String name = null;
        for (int i = 0; i < index; ++i) {
            pos += this.m_buffer.getInt(pos) + 4;
        }
        name = this.readString(pos, METADATA_ENCODING);
        assert (name != null);
        assert (this.verifyTableInvariants());
        return name;
    }

    @Override
    public final VoltType getColumnType(int index) {
        assert (this.verifyTableInvariants());
        assert (index < this.m_colCount);
        VoltType retval = VoltType.get(this.m_buffer.get(7 + index));
        assert (this.verifyTableInvariants());
        return retval;
    }

    final boolean getColumnNullable(int index) {
        if (this.m_extraMetadata != null) {
            return this.m_extraMetadata.originalColumnInfos[index].nullable;
        }
        return true;
    }

    final int getColumnMaxSize(int index) {
        if (this.m_extraMetadata != null) {
            return this.m_extraMetadata.originalColumnInfos[index].size;
        }
        return 0x100000;
    }

    final int getColumnPkeyIndex(int index) {
        if (this.m_extraMetadata != null) {
            for (int i = 0; i < this.m_extraMetadata.pkeyIndexes.length; ++i) {
                if (this.m_extraMetadata.pkeyIndexes[i] != index) continue;
                return i;
            }
        }
        return -1;
    }

    final int[] getPkeyColumnIndexes() {
        if (this.m_extraMetadata != null && this.m_extraMetadata.pkeyIndexes != null) {
            return this.m_extraMetadata.pkeyIndexes;
        }
        return new int[0];
    }

    final boolean getColumnUniqueness(int index) {
        if (this.m_extraMetadata != null) {
            return this.m_extraMetadata.originalColumnInfos[index].unique;
        }
        return false;
    }

    final String getColumnDefaultValue(int index) {
        if (this.m_extraMetadata != null) {
            return this.m_extraMetadata.originalColumnInfos[index].defaultValue;
        }
        return null;
    }

    @Override
    public final int getColumnIndex(String name) {
        assert (this.verifyTableInvariants());
        for (int i = 0; i < this.m_colCount; ++i) {
            if (!this.getColumnName(i).equalsIgnoreCase(name)) continue;
            return i;
        }
        String msg = "No Column named '" + name + "'. Existing columns are:";
        for (int i = 0; i < this.m_colCount; ++i) {
            msg = msg + "[" + i + "]" + this.getColumnName(i) + ",";
        }
        throw new IllegalArgumentException(msg);
    }

    public final VoltTableRow fetchRow(int index) {
        assert (this.verifyTableInvariants());
        if (index < 0 || index >= this.m_rowCount) {
            throw new IndexOutOfBoundsException("index = " + index + "; rows = " + this.m_rowCount);
        }
        int pos = this.m_rowStart + 4;
        for (int i = 0; i < index; ++i) {
            pos += this.m_buffer.getInt(pos) + 4;
        }
        Row retval = new Row(pos + 4);
        retval.m_activeRowIndex = index;
        return retval;
    }

    public final void add(VoltTableRow row) {
        assert (this.verifyTableInvariants());
        Object[] values = new Object[this.m_colCount];
        for (int i = 0; i < this.m_colCount; ++i) {
            try {
                values[i] = row.get(i, this.getColumnType(i));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.addRow(values);
    }

    public final void addRow(Object ... values) {
        if (this.m_readOnly) {
            throw new IllegalStateException("Table is read-only. Make a copy before changing.");
        }
        assert (this.verifyTableInvariants());
        if (this.m_colCount == 0) {
            throw new IllegalStateException("table has no columns defined");
        }
        if (values.length != this.m_colCount) {
            throw new IllegalArgumentException(values.length + " arguments but table has " + this.m_colCount + " columns");
        }
        int pos = this.m_buffer.position();
        try {
            this.m_buffer.limit(this.m_buffer.capacity());
            this.m_buffer.position(pos + 4);
            int typePos = 7;
            block28: for (int col = 0; col < this.m_colCount; ++col) {
                Object value = values[col];
                VoltType columnType = VoltType.get(this.m_buffer.get(typePos + col));
                boolean allowNulls = true;
                int maxColSize = 0x100000;
                if (this.m_extraMetadata != null) {
                    allowNulls = this.m_extraMetadata.originalColumnInfos[col].nullable;
                    maxColSize = this.m_extraMetadata.originalColumnInfos[col].size;
                }
                try {
                    if (VoltType.isNullVoltType(value)) {
                        if (!allowNulls) {
                            throw new IllegalArgumentException(String.format("Column %s at index %d doesn't allow NULL values.", this.getColumnName(col), col));
                        }
                        switch (columnType) {
                            case TINYINT: {
                                this.m_buffer.put((byte)-128);
                                continue block28;
                            }
                            case SMALLINT: {
                                this.m_buffer.putShort((short)Short.MIN_VALUE);
                                continue block28;
                            }
                            case INTEGER: {
                                this.m_buffer.putInt(Integer.MIN_VALUE);
                                continue block28;
                            }
                            case TIMESTAMP: {
                                this.m_buffer.putLong(Long.MIN_VALUE);
                                continue block28;
                            }
                            case BIGINT: {
                                this.m_buffer.putLong(Long.MIN_VALUE);
                                continue block28;
                            }
                            case FLOAT: {
                                this.m_buffer.putDouble(-1.7E308);
                                continue block28;
                            }
                            case STRING: {
                                this.m_buffer.putInt(-1);
                                continue block28;
                            }
                            case VARBINARY: {
                                this.m_buffer.putInt(-1);
                                continue block28;
                            }
                            case DECIMAL: {
                                VoltDecimalHelper.serializeNull(this.m_buffer);
                                continue block28;
                            }
                            default: {
                                throw new VoltTypeException("Unsupported type: " + (Object)((Object)columnType));
                            }
                        }
                    }
                    switch (columnType) {
                        case TINYINT: {
                            if (value instanceof BigDecimal) {
                                throw new ClassCastException();
                            }
                            Number n1 = (Number)value;
                            if (columnType.wouldCastOverflow(n1)) {
                                throw new VoltTypeException("Cast of " + n1.doubleValue() + " to " + columnType.toString() + " would overflow");
                            }
                            this.m_buffer.put(n1.byteValue());
                            break;
                        }
                        case SMALLINT: {
                            if (value instanceof BigDecimal) {
                                throw new ClassCastException();
                            }
                            Number n2 = (Number)value;
                            if (columnType.wouldCastOverflow(n2)) {
                                throw new VoltTypeException("Cast to " + columnType.toString() + " would overflow");
                            }
                            this.m_buffer.putShort(n2.shortValue());
                            break;
                        }
                        case INTEGER: {
                            if (value instanceof BigDecimal) {
                                throw new ClassCastException();
                            }
                            Number n3 = (Number)value;
                            if (columnType.wouldCastOverflow(n3)) {
                                throw new VoltTypeException("Cast to " + columnType.toString() + " would overflow");
                            }
                            this.m_buffer.putInt(n3.intValue());
                            break;
                        }
                        case BIGINT: {
                            if (value instanceof BigDecimal) {
                                throw new ClassCastException();
                            }
                            Number n4 = (Number)value;
                            if (columnType.wouldCastOverflow(n4)) {
                                throw new VoltTypeException("Cast to " + columnType.toString() + " would overflow");
                            }
                            this.m_buffer.putLong(n4.longValue());
                            break;
                        }
                        case FLOAT: {
                            if (value instanceof BigDecimal) {
                                throw new ClassCastException();
                            }
                            Number n5 = (Number)value;
                            if (columnType.wouldCastOverflow(n5)) {
                                throw new VoltTypeException("Cast to " + columnType.toString() + " would overflow");
                            }
                            this.m_buffer.putDouble(n5.doubleValue());
                            break;
                        }
                        case STRING: {
                            if (value instanceof byte[]) {
                                if (((byte[])value).length > maxColSize) {
                                    throw new VoltOverflowException("Value in VoltTable.addRow(...) larger than allowed max " + VoltType.humanReadableSize(maxColSize));
                                }
                                assert (this.testForUTF8Encoding((byte[])value));
                                this.writeStringOrVarbinaryToBuffer((byte[])value, this.m_buffer);
                                break;
                            }
                            if (((String)value).length() > maxColSize) {
                                throw new VoltOverflowException("Value in VoltTable.addRow(...) larger than allowed max " + VoltType.humanReadableSize(maxColSize));
                            }
                            this.writeStringToBuffer((String)value, ROWDATA_ENCODING, this.m_buffer);
                            break;
                        }
                        case VARBINARY: {
                            if (value instanceof String) {
                                value = Encoder.hexDecode((String)value);
                            }
                            if (!(value instanceof byte[])) continue block28;
                            if (((byte[])value).length > maxColSize) {
                                throw new VoltOverflowException("Value in VoltTable.addRow(...) larger than allowed max " + VoltType.humanReadableSize(maxColSize));
                            }
                            this.writeStringOrVarbinaryToBuffer((byte[])value, this.m_buffer);
                            break;
                        }
                        case TIMESTAMP: {
                            if (value instanceof BigDecimal) {
                                throw new ClassCastException();
                            }
                            long micros = value instanceof Date || value instanceof TimestampType ? ParameterSet.timestampToMicroseconds(value) : ((Number)value).longValue();
                            this.m_buffer.putLong(micros);
                            break;
                        }
                        case DECIMAL: {
                            VoltDecimalHelper.serializeBigDecimal((BigDecimal)value, this.m_buffer);
                            break;
                        }
                        default: {
                            throw new VoltTypeException("Unsupported type: " + (Object)((Object)columnType));
                        }
                    }
                    continue;
                }
                catch (VoltTypeException vte) {
                    this.m_buffer.position(pos);
                    throw vte;
                }
                catch (ClassCastException cce) {
                    this.m_buffer.position(pos);
                    throw new VoltTypeException("Value for column " + col + " (" + this.getColumnName(col) + ") is type " + value.getClass().getSimpleName() + " when type " + (Object)((Object)columnType) + " was expected.");
                }
            }
            ++this.m_rowCount;
            this.m_buffer.putInt(this.m_rowStart, this.m_rowCount);
            int rowsize = this.m_buffer.position() - pos - 4;
            if (rowsize > 0x200000) {
                throw new VoltOverflowException("Table row total length larger than allowed max " + VoltTableRow.MAX_TUPLE_LENGTH_STR);
            }
            this.m_buffer.limit(this.m_buffer.position());
            assert (rowsize >= 0);
            this.m_buffer.putInt(pos, rowsize);
        }
        catch (BufferOverflowException e) {
            this.m_buffer.position(pos);
            this.expandBuffer();
            this.addRow(values);
        }
        catch (IllegalArgumentException e) {
            if (this.m_buffer.limit() - this.m_buffer.position() < 32) {
                this.m_buffer.position(pos);
                this.expandBuffer();
                this.addRow(values);
            }
            throw e;
        }
        assert (this.verifyTableInvariants());
    }

    private final void expandBuffer() {
        int end = this.m_buffer.position();
        assert (end > this.m_rowStart);
        ByteBuffer buf2 = ByteBuffer.allocate(this.m_buffer.capacity() * 2);
        this.m_buffer.limit(end);
        this.m_buffer.position(0);
        buf2.put(this.m_buffer);
        this.m_buffer = buf2;
    }

    public final long asScalarLong() {
        this.verifyTableInvariants();
        if (this.m_rowCount != 1) {
            throw new IllegalStateException("table must contain exactly 1 tuple; tuples = " + this.m_rowCount);
        }
        if (this.m_colCount != 1) {
            throw new IllegalStateException("table must contain exactly 1 column; columns = " + this.m_colCount);
        }
        VoltType colType = this.getColumnType(0);
        switch (colType) {
            case TINYINT: {
                return this.m_buffer.get(this.m_rowStart + 8);
            }
            case SMALLINT: {
                return this.m_buffer.getShort(this.m_rowStart + 8);
            }
            case INTEGER: {
                return this.m_buffer.getInt(this.m_rowStart + 8);
            }
            case BIGINT: {
                return this.m_buffer.getLong(this.m_rowStart + 8);
            }
        }
        throw new IllegalStateException("table must contain exactly 1 integral value; column 1 is type = " + colType.name());
    }

    public String toString() {
        assert (this.verifyTableInvariants());
        StringBuilder buffer = new StringBuilder();
        buffer.append(" header size: ").append(this.m_buffer.getInt(0)).append("\n");
        byte statusCode = this.m_buffer.get(4);
        buffer.append(" status code: ").append(statusCode);
        int colCount = this.m_buffer.getShort(5);
        buffer.append(" column count: ").append(colCount).append("\n");
        assert (colCount == this.m_colCount);
        buffer.append(" cols ");
        for (int i = 0; i < colCount; ++i) {
            buffer.append("(").append(this.getColumnName(i)).append(":").append(this.getColumnType(i).name()).append("), ");
        }
        buffer.append("\n");
        buffer.append(" rows -\n");
        VoltTableRow r = this.cloneRow();
        r.resetRowPosition();
        while (r.advanceRow()) {
            buffer.append("  ");
            for (int i = 0; i < this.m_colCount; ++i) {
                switch (this.getColumnType(i)) {
                    case TINYINT: 
                    case SMALLINT: 
                    case INTEGER: 
                    case BIGINT: {
                        long lval = r.getLong(i);
                        if (r.wasNull()) {
                            buffer.append("NULL");
                            break;
                        }
                        buffer.append(lval);
                        break;
                    }
                    case FLOAT: {
                        double dval = r.getDouble(i);
                        if (r.wasNull()) {
                            buffer.append("NULL");
                            break;
                        }
                        buffer.append(dval);
                        break;
                    }
                    case TIMESTAMP: {
                        TimestampType tstamp = r.getTimestampAsTimestamp(i);
                        if (r.wasNull()) {
                            buffer.append("NULL");
                            assert (tstamp == null);
                            break;
                        }
                        buffer.append(tstamp);
                        break;
                    }
                    case STRING: {
                        String string = r.getString(i);
                        if (r.wasNull()) {
                            buffer.append("NULL");
                            assert (string == null);
                            break;
                        }
                        buffer.append(string);
                        break;
                    }
                    case VARBINARY: {
                        byte[] bin = r.getVarbinary(i);
                        if (r.wasNull()) {
                            buffer.append("NULL");
                            assert (bin == null);
                            break;
                        }
                        buffer.append(VoltType.varbinaryToPrintableString(bin));
                        break;
                    }
                    case DECIMAL: {
                        BigDecimal bd = r.getDecimalAsBigDecimal(i);
                        if (r.wasNull()) {
                            buffer.append("NULL");
                            assert (bd == null);
                            break;
                        }
                        buffer.append(bd.toString());
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Table column had unexpected type.");
                    }
                }
                if (i >= this.m_colCount - 1) continue;
                buffer.append(",");
            }
            buffer.append("\n");
        }
        assert (this.verifyTableInvariants());
        return buffer.toString();
    }

    public String toFormattedString() {
        int i;
        int MAX_PRINTABLE_CHARS = 30;
        String ELIPSIS = "...";
        StringBuffer sb = new StringBuffer();
        int columnCount = this.getColumnCount();
        int[] padding = new int[columnCount];
        String[] fmt = new String[columnCount];
        for (i = 0; i < columnCount; ++i) {
            padding[i] = this.getColumnName(i).length();
        }
        this.resetRowPosition();
        while (this.advanceRow()) {
            for (i = 0; i < columnCount; ++i) {
                Object v = this.get(i, this.getColumnType(i));
                if (this.wasNull()) {
                    v = "NULL";
                }
                int len = 0;
                len = this.getColumnType(i) == VoltType.VARBINARY && !this.wasNull() ? ((byte[])v).length * 2 : v.toString().length();
                if (len > 30) {
                    len = 30;
                }
                if (len <= padding[i]) continue;
                padding[i] = len;
            }
        }
        for (i = 0; i < columnCount; ++i) {
            int n = i;
            padding[n] = padding[n] + 1;
            fmt[i] = "%1$" + (this.getColumnType(i) == VoltType.STRING || this.getColumnType(i) == VoltType.TIMESTAMP || this.getColumnType(i) == VoltType.VARBINARY ? "-" : "") + padding[i] + "s";
        }
        for (i = 0; i < columnCount; ++i) {
            sb.append(String.format("%1$-" + padding[i] + "s", this.getColumnName(i)));
            if (i >= columnCount - 1) continue;
            sb.append(" ");
        }
        sb.append("\n");
        for (i = 0; i < columnCount; ++i) {
            char[] underline_array = new char[padding[i]];
            Arrays.fill(underline_array, '-');
            sb.append(new String(underline_array));
            if (i >= columnCount - 1) continue;
            sb.append(" ");
        }
        sb.append("\n");
        this.resetRowPosition();
        while (this.advanceRow()) {
            for (i = 0; i < columnCount; ++i) {
                Object value = this.get(i, this.getColumnType(i));
                String valueStr = this.wasNull() ? "NULL" : (this.getColumnType(i) == VoltType.VARBINARY ? Encoder.hexEncode((byte[])value) : value.toString());
                if (this.getColumnType(i) == VoltType.VARBINARY && valueStr.length() > 30) {
                    valueStr = valueStr.substring(0, 30 - "...".length()) + "...";
                }
                sb.append(String.format(fmt[i], valueStr));
                if (i >= columnCount - 1) continue;
                sb.append(" ");
            }
            sb.append("\n");
        }
        this.resetRowPosition();
        return sb.toString();
    }

    @Override
    public String toJSONString() {
        JSONStringer js = new JSONStringer();
        try {
            js.object();
            js.key(JSON_STATUS_KEY).value(this.getStatusCode());
            js.key(JSON_SCHEMA_KEY).array();
            for (int i = 0; i < this.getColumnCount(); ++i) {
                js.object();
                js.key(JSON_NAME_KEY).value(this.getColumnName(i));
                js.key(JSON_TYPE_KEY).value(this.getColumnType(i).getValue());
                js.endObject();
            }
            js.endArray();
            js.key(JSON_DATA_KEY).array();
            VoltTableRow row = this.cloneRow();
            row.resetRowPosition();
            while (row.advanceRow()) {
                js.array();
                for (int i = 0; i < this.getColumnCount(); ++i) {
                    row.putJSONRep(i, js);
                }
                js.endArray();
            }
            js.endArray();
            js.endObject();
        }
        catch (JSONException e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to serialized a table to JSON.", e);
        }
        return js.toString();
    }

    public static VoltTable fromJSONString(String json) throws JSONException, IOException {
        JSONObject jsonObj = new JSONObject(json);
        return VoltTable.fromJSONObject(jsonObj);
    }

    public static VoltTable fromJSONObject(JSONObject json) throws JSONException, IOException {
        JSONArray jsonCols = json.getJSONArray(JSON_SCHEMA_KEY);
        ColumnInfo[] columns = new ColumnInfo[jsonCols.length()];
        for (int i = 0; i < jsonCols.length(); ++i) {
            JSONObject jsonCol = jsonCols.getJSONObject(i);
            String name = jsonCol.getString(JSON_NAME_KEY);
            VoltType type = VoltType.get((byte)jsonCol.getInt(JSON_TYPE_KEY));
            columns[i] = new ColumnInfo(name, type);
        }
        VoltTable t = new VoltTable(columns);
        byte status = (byte)json.getInt(JSON_STATUS_KEY);
        t.setStatusCode(status);
        JSONArray data = json.getJSONArray(JSON_DATA_KEY);
        for (int i = 0; i < data.length(); ++i) {
            JSONArray jsonRow = data.getJSONArray(i);
            assert (jsonRow.length() == jsonCols.length());
            Object[] row = new Object[jsonRow.length()];
            block6: for (int j = 0; j < jsonRow.length(); ++j) {
                row[j] = jsonRow.get(j);
                if (row[j] == JSONObject.NULL) {
                    row[j] = null;
                }
                VoltType type = columns[j].type;
                if (row[j] == null) continue;
                switch (type) {
                    case TINYINT: 
                    case SMALLINT: 
                    case INTEGER: 
                    case TIMESTAMP: 
                    case BIGINT: {
                        if (row[j] instanceof String) {
                            row[j] = Long.parseLong((String)row[j]);
                        }
                        assert (row[j] instanceof Number);
                        continue block6;
                    }
                    case DECIMAL: {
                        String decVal = row[j] instanceof String ? (String)row[j] : row[j].toString();
                        if (decVal.compareToIgnoreCase("NULL") == 0) {
                            row[j] = null;
                            continue block6;
                        }
                        row[j] = VoltDecimalHelper.deserializeBigDecimalFromString(decVal);
                        continue block6;
                    }
                }
            }
            t.addRow(row);
        }
        return t;
    }

    public boolean hasSameContents(VoltTable other) {
        long checksum2;
        boolean checksum;
        int theirpos;
        assert (this.verifyTableInvariants());
        if (this == other) {
            return true;
        }
        int mypos = this.m_buffer.position();
        if (mypos != (theirpos = other.m_buffer.position())) {
            return false;
        }
        long checksum1 = ClientUtils.cheesyBufferCheckSum(this.m_buffer);
        boolean bl = checksum = checksum1 == (checksum2 = ClientUtils.cheesyBufferCheckSum(other.m_buffer));
        assert (this.verifyTableInvariants());
        return checksum;
    }

    @Deprecated
    public boolean equals(Object o) {
        if (!(o instanceof VoltTable)) {
            return false;
        }
        return this.hasSameContents((VoltTable)o);
    }

    @Deprecated
    public int hashCode() {
        throw new UnsupportedOperationException("unimplemented");
    }

    public final VoltTable clone(int extraBytes) {
        assert (this.verifyTableInvariants());
        VoltTable cloned = new VoltTable(this.m_extraMetadata);
        cloned.m_colCount = this.m_colCount;
        cloned.m_rowCount = 0;
        cloned.m_rowStart = this.m_rowStart;
        int pos = this.m_buffer.position();
        this.m_buffer.position(0);
        this.m_buffer.limit(this.m_rowStart);
        cloned.m_buffer = ByteBuffer.allocate(this.m_rowStart + extraBytes + 100);
        cloned.m_buffer.put(this.m_buffer);
        this.m_buffer.limit(this.m_buffer.capacity());
        this.m_buffer.position(pos);
        cloned.m_buffer.putInt(0);
        assert (this.verifyTableInvariants());
        assert (cloned.verifyTableInvariants());
        return cloned;
    }

    boolean testForUTF8Encoding(byte[] strbytes) {
        try {
            new String(strbytes, "UTF-8");
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return true;
    }

    private final void writeStringToBuffer(String s, Charset encoding, ByteBuffer b) {
        if (s == null) {
            b.putInt(-1);
            return;
        }
        int len = 0;
        byte[] strbytes = s.getBytes(encoding);
        assert (strbytes != null);
        len = strbytes.length;
        b.putInt(len);
        b.put(strbytes);
    }

    private final void writeStringOrVarbinaryToBuffer(byte[] s, ByteBuffer b) {
        if (s == null) {
            b.putInt(-1);
            return;
        }
        int len = s.length;
        b.putInt(len);
        b.put(s);
    }

    @Override
    public final int getRowCount() {
        return this.m_rowCount;
    }

    @Override
    protected final int getRowStart() {
        return this.m_rowStart;
    }

    @Override
    public final int getColumnCount() {
        return this.m_colCount;
    }

    private final boolean verifyTableInvariants() {
        assert (this.m_buffer != null);
        assert (this.m_rowCount >= 0);
        assert (this.m_colCount > 0);
        assert (this.m_rowStart > 0);
        int minsize = 16;
        assert (this.m_buffer.capacity() >= 16);
        assert (this.m_buffer.limit() >= 16);
        if (this.m_buffer.position() < 16) {
            System.err.printf("Buffer position %d is smaller than it should be.\n", this.m_buffer.position());
            return false;
        }
        int rowStart = this.m_buffer.getInt(0) + 4;
        if (rowStart < 12) {
            System.err.printf("rowStart with value %d is smaller than it should be.\n", rowStart);
            return false;
        }
        assert (this.m_buffer.position() > this.m_rowStart);
        short colCount = this.m_buffer.getShort(5);
        assert (colCount > 0);
        return true;
    }

    public byte getStatusCode() {
        return this.m_buffer.get(4);
    }

    public void setStatusCode(byte code) {
        this.m_buffer.put(4, code);
    }

    public int getSerializedSize() {
        return this.m_buffer.limit() + 4;
    }

    public void flattenToBuffer(ByteBuffer buf) {
        ByteBuffer dup = this.m_buffer.duplicate();
        buf.putInt(dup.limit());
        dup.position(0);
        buf.put(dup);
    }

    void initFromBuffer(ByteBuffer buf) {
        int len = buf.getInt();
        assert (len >= 4);
        int startLimit = buf.limit();
        buf.limit(buf.position() + len);
        this.m_buffer = buf.slice().asReadOnlyBuffer();
        buf.limit(startLimit);
        buf.position(buf.position() + len);
        this.m_buffer.position(this.m_buffer.limit());
        this.m_rowStart = this.m_buffer.getInt(0) + 4;
        this.m_colCount = this.m_buffer.getShort(5);
        this.m_rowCount = this.m_buffer.getInt(this.m_rowStart);
        assert (this.verifyTableInvariants());
    }

    public ByteBuffer getBuffer() {
        ByteBuffer buf = this.m_buffer.asReadOnlyBuffer();
        buf.position(0);
        return buf;
    }

    public ColumnInfo[] getTableSchema() {
        ColumnInfo[] schema = new ColumnInfo[this.m_colCount];
        for (int i = 0; i < this.m_colCount; ++i) {
            ColumnInfo col;
            schema[i] = col = new ColumnInfo(this.getColumnName(i), this.getColumnType(i));
        }
        return schema;
    }

    final class Row
    extends VoltTableRow {
        Row(int position) {
            this.m_buffer = VoltTable.this.m_buffer;
            assert (position < this.m_buffer.limit());
            this.m_position = position;
            this.m_offsets = new int[VoltTable.this.m_colCount];
            this.m_activeRowIndex = -1;
        }

        @Override
        protected int getColumnCount() {
            return VoltTable.this.getColumnCount();
        }

        @Override
        protected int getColumnIndex(String columnName) {
            return VoltTable.this.getColumnIndex(columnName);
        }

        @Override
        protected VoltType getColumnType(int columnIndex) {
            return VoltTable.this.getColumnType(columnIndex);
        }

        @Override
        protected int getRowCount() {
            return VoltTable.this.getRowCount();
        }

        @Override
        protected int getRowStart() {
            return VoltTable.this.getRowStart();
        }

        @Override
        public VoltTableRow cloneRow() {
            Row retval = new Row(this.m_position);
            retval.m_hasCalculatedOffsets = this.m_hasCalculatedOffsets;
            retval.m_wasNull = this.m_wasNull;
            for (int i = 0; i < VoltTable.this.m_colCount; ++i) {
                retval.m_offsets[i] = this.m_offsets[i];
            }
            retval.m_activeRowIndex = this.m_activeRowIndex;
            return retval;
        }
    }

    static class ExtraMetadata {
        final ColumnInfo[] originalColumnInfos;
        final String name;
        int partitionColIndex;
        int[] pkeyIndexes;

        ExtraMetadata(String name, int partitionColIndex, int[] pkeyIndexes, ColumnInfo ... originalColumnInfos) {
            this.name = name;
            this.partitionColIndex = partitionColIndex;
            this.pkeyIndexes = (int[])pkeyIndexes.clone();
            this.originalColumnInfos = (ColumnInfo[])originalColumnInfos.clone();
        }

        protected Object clone() {
            try {
                ExtraMetadata cloned = (ExtraMetadata)super.clone();
                for (int i = 0; i < this.originalColumnInfos.length; ++i) {
                    cloned.originalColumnInfos[i] = this.originalColumnInfos[i].clone();
                }
                return cloned;
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }

    public static class ColumnInfo
    implements Cloneable {
        final String name;
        final VoltType type;
        final int size;
        final boolean nullable;
        final boolean unique;
        final String defaultValue;
        static final String NO_DEFAULT_VALUE = "!@#$%^&*(!@#$%^&*(";

        public ColumnInfo(String name, VoltType type) {
            this.name = name;
            this.type = type;
            this.size = 0x100000;
            this.nullable = true;
            this.unique = false;
            this.defaultValue = NO_DEFAULT_VALUE;
        }

        ColumnInfo(String name, VoltType type, int size, boolean nullable, boolean unique, String defaultValue) {
            this.name = name;
            this.type = type;
            this.size = size;
            this.nullable = nullable;
            this.unique = unique;
            this.defaultValue = defaultValue;
        }

        ColumnInfo(JSONObject jsonCol) throws JSONException {
            this.name = jsonCol.getString(VoltTable.JSON_NAME_KEY);
            this.type = VoltType.get((byte)jsonCol.getInt(VoltTable.JSON_TYPE_KEY));
            this.size = 0x100000;
            this.nullable = true;
            this.unique = false;
            this.defaultValue = NO_DEFAULT_VALUE;
        }

        public ColumnInfo clone() {
            try {
                return (ColumnInfo)super.clone();
            }
            catch (CloneNotSupportedException e) {
                assert (false);
                throw new RuntimeException(e);
            }
        }

        public int hashCode() {
            throw new RuntimeException("Didn't expect you to hash this.");
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ColumnInfo)) {
                return false;
            }
            ColumnInfo other = (ColumnInfo)obj;
            if (this.nullable != other.nullable) {
                return false;
            }
            if (this.unique != other.unique) {
                return false;
            }
            if (this.defaultValue != other.defaultValue) {
                return false;
            }
            if (this.size != other.size) {
                return false;
            }
            if (this.type != other.type) {
                return false;
            }
            return this.name.equals(other.name);
        }
    }
}

