/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb;

import com.google_voltpatches.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop_voltpatches.util.PureJavaCrc32;
import org.voltdb.VoltTable;
import org.voltdb.VoltTypeException;
import org.voltdb.types.TimestampType;
import org.voltdb.utils.Encoder;

public final class VoltType
extends Enum<VoltType> {
    public static final /* enum */ VoltType INVALID = new VoltType(0, -1, null, new Class[0], null, '0');
    public static final /* enum */ VoltType NULL = new VoltType(1, -1, null, new Class[0], null, '0');
    public static final /* enum */ VoltType NUMERIC = new VoltType(2, 0, null, new Class[0], null, '0');
    public static final /* enum */ VoltType TINYINT = new VoltType(3, 1, "tinyint", new Class[]{Byte.TYPE, Byte.class}, byte[].class, 't', -6, null, null, null, false, 2, false, 0, 0, "java.lang.Byte");
    public static final /* enum */ VoltType SMALLINT = new VoltType(4, 2, "smallint", new Class[]{Short.TYPE, Short.class}, short[].class, 's', 5, null, null, null, false, 2, false, 0, 0, "java.lang.Short");
    public static final /* enum */ VoltType INTEGER = new VoltType(5, 4, "integer", new Class[]{Integer.TYPE, Integer.class, AtomicInteger.class}, int[].class, 'i', 4, null, null, null, false, 2, false, 0, 0, "java.lang.Integer");
    public static final /* enum */ VoltType BIGINT = new VoltType(6, 8, "bigint", new Class[]{Long.TYPE, Long.class, AtomicLong.class}, long[].class, 'b', -5, null, null, null, false, 2, false, 0, 0, "java.lang.Long");
    public static final /* enum */ VoltType FLOAT = new VoltType(8, 8, "float", new Class[]{Double.TYPE, Double.class, Float.TYPE, Float.class}, double[].class, 'f', 6, null, null, null, false, 2, false, null, null, "java.lang.Double");
    public static final /* enum */ VoltType TIMESTAMP = new VoltType(11, 8, "timestamp", new Class[]{TimestampType.class, java.util.Date.class, Date.class, Timestamp.class}, TimestampType[].class, 'p', 93, "'", "'", null, false, 2, null, null, null, "java.sql.Timestamp");
    public static final /* enum */ VoltType STRING = new VoltType(9, -1, "varchar", new Class[]{String.class}, String[].class, 'v', 12, "'", "'", "max_length", true, 3, null, null, null, "java.lang.String");
    public static final /* enum */ VoltType VOLTTABLE = new VoltType(21, -1, null, new Class[]{VoltTable.class}, VoltTable[].class, '0');
    public static final /* enum */ VoltType DECIMAL = new VoltType(22, 16, "decimal", new Class[]{BigDecimal.class}, BigDecimal[].class, 'd', 3, null, null, null, false, 2, false, 12, 12, "java.math.BigDecimal");
    public static final /* enum */ VoltType VARBINARY = new VoltType(25, -1, "varbinary", new Class[]{byte[].class, Byte[].class}, byte[][].class, 'l', -3, "'", "'", "max_length", false, 2, null, null, null, "java.lang.Byte[]");
    public static final /* enum */ VoltType BOOLEAN = new VoltType(23, 1, "boolean", new Class[]{Boolean.TYPE, Boolean.class}, boolean[].class, 'o', 16, null, null, null, false, 2, false, 0, 0, "java.lang.Boolean");
    public static final int MAX_VALUE_LENGTH = 0x100000;
    public static final int MAX_VALUE_LENGTH_IN_CHARACTERS = 262144;
    private final byte m_val;
    private final int m_lengthInBytes;
    private final String m_sqlString;
    private final Class<?>[] m_classes;
    private final Class<?> m_vectorClass;
    private final char m_signatureChar;
    private final boolean m_jdbcVisible;
    private final int m_dataType;
    private final String m_literalPrefix;
    private final String m_literalSuffix;
    private final String m_createParams;
    private final int m_nullable;
    private final boolean m_caseSensitive;
    private final int m_searchable;
    private final Boolean m_unsignedAttribute;
    private final Integer m_minimumScale;
    private final Integer m_maximumScale;
    private final String m_jdbcClass;
    private static final ImmutableMap<Class<?>, VoltType> s_classes;
    private static final VoltType[] s_types;
    public static final int NULL_STRING_LENGTH = -1;
    public static final byte NULL_TINYINT = -128;
    public static final short NULL_SMALLINT = Short.MIN_VALUE;
    public static final int NULL_INTEGER = Integer.MIN_VALUE;
    public static final long NULL_BIGINT = Long.MIN_VALUE;
    public static final double NULL_FLOAT = -1.7E308;
    public static final NullTimestampSigil NULL_TIMESTAMP;
    public static final NullStringOrVarbinarySigil NULL_STRING_OR_VARBINARY;
    public static final NullDecimalSigil NULL_DECIMAL;
    private static final /* synthetic */ VoltType[] $VALUES;

    public static VoltType[] values() {
        return (VoltType[])$VALUES.clone();
    }

    public static VoltType valueOf(String name) {
        return Enum.valueOf(VoltType.class, name);
    }

    public static String humanReadableSize(int size) {
        if (size > 9999) {
            return String.valueOf(size / 1024) + "K";
        }
        return String.valueOf(size) + "B";
    }

    private VoltType(byte val, int lengthInBytes, String sqlString, Class<?>[] classes, Class<?> vectorClass, char signatureChar) {
        this(val, lengthInBytes, sqlString, classes, vectorClass, signatureChar, false, 1111, null, null, null, 1, false, Integer.MIN_VALUE, null, null, null, null);
    }

    private VoltType(byte val, int lengthInBytes, String sqlString, Class<?>[] classes, Class<?> vectorClass, char signatureChar, int dataType, String literalPrefix, String literalSuffix, String createParams, boolean caseSensitive, int searchable, Boolean unsignedAttribute, Integer minimumScale, Integer maximumScale, String jdbcClass) {
        this(val, lengthInBytes, sqlString, classes, vectorClass, signatureChar, true, dataType, literalPrefix, literalSuffix, createParams, 1, caseSensitive, searchable, unsignedAttribute, minimumScale, maximumScale, jdbcClass);
    }

    private VoltType(byte val, int lengthInBytes, String sqlString, Class<?>[] classes, Class<?> vectorClass, char signatureChar, boolean jdbcVisible, int dataType, String literalPrefix, String literalSuffix, String createParams, int nullable, boolean caseSensitive, int searchable, Boolean unsignedAttribute, Integer minimumScale, Integer maximumScale, String jdbcClass) {
        this.m_val = val;
        this.m_lengthInBytes = lengthInBytes;
        this.m_sqlString = sqlString;
        this.m_classes = classes;
        this.m_vectorClass = vectorClass;
        this.m_signatureChar = signatureChar;
        this.m_jdbcVisible = jdbcVisible;
        this.m_dataType = dataType;
        this.m_literalPrefix = literalPrefix;
        this.m_literalSuffix = literalSuffix;
        this.m_createParams = createParams;
        this.m_nullable = nullable;
        this.m_caseSensitive = caseSensitive;
        this.m_searchable = searchable;
        this.m_unsignedAttribute = unsignedAttribute;
        this.m_minimumScale = minimumScale;
        this.m_maximumScale = maximumScale;
        this.m_jdbcClass = jdbcClass;
    }

    public byte getValue() {
        return this.m_val;
    }

    public Class<?> classFromType() {
        if (this.m_classes.length == 0) {
            throw new RuntimeException("Unsupported type " + (Object)((Object)this));
        }
        return this.m_classes[0];
    }

    public Class<?> vectorClassFromType() {
        if (this.m_vectorClass == null) {
            throw new RuntimeException("Unsupported type " + (Object)((Object)this));
        }
        return this.m_vectorClass;
    }

    public static VoltType get(byte val) {
        VoltType type;
        VoltType voltType = type = val < s_types.length ? s_types[val] : null;
        if (type == null) {
            throw new AssertionError((Object)("Unknown type: " + String.valueOf(val)));
        }
        return type;
    }

    private boolean matchesString(String str) {
        return str.toLowerCase().endsWith(this.name().toLowerCase());
    }

    public static VoltType typeFromString(String str) {
        if (str == null) {
            return NULL;
        }
        if (str.startsWith("VoltType.")) {
            str = str.substring("VoltType.".length());
        }
        if (str.compareToIgnoreCase("null") == 0) {
            return NULL;
        }
        for (VoltType type : VoltType.values()) {
            if (!type.matchesString(str)) continue;
            return type;
        }
        if (str.equalsIgnoreCase("DOUBLE")) {
            return FLOAT;
        }
        if (str.equalsIgnoreCase("CHARACTER") || str.equalsIgnoreCase("CHAR") || str.equalsIgnoreCase("VARCHAR")) {
            return STRING;
        }
        throw new RuntimeException("Can't find type: " + str);
    }

    public static VoltType typeFromObject(Object obj) {
        assert (obj != null);
        Class<?> cls = obj.getClass();
        return VoltType.typeFromClass(cls);
    }

    public static VoltType typeFromClass(Class<?> cls) {
        VoltType type = s_classes.get(cls);
        if (type == null) {
            throw new VoltTypeException("Unimplemented Object Type: " + cls);
        }
        return type;
    }

    public static VoltType typeFromSignature(char signature) {
        for (VoltType type : VoltType.values()) {
            if (type.m_signatureChar != signature) continue;
            return type;
        }
        throw new VoltTypeException("Unknown type signature: " + signature);
    }

    public String toString() {
        return "VoltType." + this.name();
    }

    public String getName() {
        return this.name();
    }

    public int getLengthInBytesForFixedTypes() {
        if (this.m_lengthInBytes == -1) {
            throw new RuntimeException("Asking for fixed size for non-fixed or unknown type.");
        }
        return this.m_lengthInBytes;
    }

    public int getLengthInBytesForFixedTypesWithoutCheck() {
        return this.m_lengthInBytes;
    }

    public int getMaxLengthInBytes() {
        if (this.m_lengthInBytes == -1) {
            return 0x100000;
        }
        return this.m_lengthInBytes;
    }

    public String toSQLString() {
        return this.m_sqlString;
    }

    public boolean isJdbcVisible() {
        return this.m_jdbcVisible;
    }

    public int getJdbcSqlType() {
        return this.m_dataType;
    }

    public String getLiteralPrefix() {
        return this.m_literalPrefix;
    }

    public String getLiteralSuffix() {
        return this.m_literalSuffix;
    }

    public String getCreateParams() {
        return this.m_createParams;
    }

    public int getNullable() {
        return this.m_nullable;
    }

    public boolean isCaseSensitive() {
        return this.m_caseSensitive;
    }

    public int getSearchable() {
        return this.m_searchable;
    }

    public Boolean isUnsigned() {
        return this.m_unsignedAttribute;
    }

    public Integer getMinimumScale() {
        return this.m_minimumScale;
    }

    public Integer getMaximumScale() {
        return this.m_maximumScale;
    }

    public String getJdbcClass() {
        return this.m_jdbcClass;
    }

    boolean wouldCastOverflow(Number value) {
        boolean retval = false;
        switch (this) {
            case TINYINT: {
                if (value.longValue() > -128L && value.longValue() <= 127L) break;
                retval = true;
                break;
            }
            case SMALLINT: {
                if (value.longValue() > -32768L && value.longValue() <= 32767L) break;
                retval = true;
                break;
            }
            case INTEGER: {
                if (value.longValue() > Integer.MIN_VALUE && value.longValue() <= Integer.MAX_VALUE) break;
                retval = true;
                break;
            }
            case BIGINT: {
                if (value.longValue() != Long.MIN_VALUE) break;
                retval = true;
                break;
            }
            case FLOAT: {
                if (value.doubleValue() != -1.7E308) break;
                retval = true;
                break;
            }
            default: {
                throw new VoltTypeException("Unhandled cast overflow case, casting to: " + this.toString());
            }
        }
        return retval;
    }

    public Object getNullValue() {
        switch (this) {
            case TINYINT: {
                return (byte)-128;
            }
            case SMALLINT: {
                return (short)Short.MIN_VALUE;
            }
            case INTEGER: {
                return Integer.MIN_VALUE;
            }
            case BIGINT: {
                return Long.MIN_VALUE;
            }
            case FLOAT: {
                return -1.7E308;
            }
            case STRING: {
                return NULL_STRING_OR_VARBINARY;
            }
            case TIMESTAMP: {
                return NULL_TIMESTAMP;
            }
            case DECIMAL: {
                return NULL_DECIMAL;
            }
            case VARBINARY: {
                return NULL_STRING_OR_VARBINARY;
            }
        }
        throw new VoltTypeException("No NULL value for " + this.toString());
    }

    public static boolean isNullVoltType(Object obj) {
        boolean retval = false;
        if (obj == null) {
            retval = true;
        } else if (obj == NULL_TIMESTAMP || obj == NULL_STRING_OR_VARBINARY || obj == NULL_DECIMAL) {
            retval = true;
        } else {
            switch (VoltType.typeFromObject(obj)) {
                case TINYINT: {
                    retval = ((Number)obj).byteValue() == -128;
                    break;
                }
                case SMALLINT: {
                    retval = ((Number)obj).shortValue() == Short.MIN_VALUE;
                    break;
                }
                case INTEGER: {
                    retval = ((Number)obj).intValue() == Integer.MIN_VALUE;
                    break;
                }
                case BIGINT: {
                    retval = ((Number)obj).longValue() == Long.MIN_VALUE;
                    break;
                }
                case FLOAT: {
                    retval = ((Number)obj).doubleValue() == -1.7E308;
                    break;
                }
                case TIMESTAMP: {
                    retval = obj == NULL_TIMESTAMP;
                    break;
                }
                case STRING: {
                    retval = obj == NULL_STRING_OR_VARBINARY;
                    break;
                }
                case VARBINARY: {
                    retval = obj == NULL_STRING_OR_VARBINARY;
                    break;
                }
                case DECIMAL: {
                    retval = obj == NULL_DECIMAL;
                    break;
                }
                default: {
                    throw new VoltTypeException("Unsupported type: " + (Object)((Object)VoltType.typeFromObject(obj)));
                }
            }
        }
        return retval;
    }

    public boolean isExactNumeric() {
        switch (this) {
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case DECIMAL: {
                return true;
            }
        }
        return false;
    }

    public boolean isInteger() {
        switch (this) {
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case TIMESTAMP: {
                return true;
            }
        }
        return false;
    }

    public boolean isMaxValuePaddable() {
        switch (this) {
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case FLOAT: 
            case TIMESTAMP: {
                return true;
            }
        }
        return false;
    }

    public static Object getPaddedMaxTypeValue(VoltType type) {
        switch (type) {
            case TINYINT: {
                return new Byte(127);
            }
            case SMALLINT: {
                return new Short(Short.MAX_VALUE);
            }
            case INTEGER: {
                return new Integer(Integer.MAX_VALUE);
            }
            case BIGINT: 
            case TIMESTAMP: {
                return new Long(Long.MAX_VALUE);
            }
            case FLOAT: {
                return new Float(Float.MAX_VALUE);
            }
        }
        return null;
    }

    public boolean isNumber() {
        switch (this) {
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case FLOAT: 
            case DECIMAL: {
                return true;
            }
        }
        return false;
    }

    public boolean isPartitionableNumber() {
        switch (this) {
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: {
                return true;
            }
        }
        return false;
    }

    public boolean canExactlyRepresentAnyValueOf(VoltType otherType) {
        if (this == otherType) {
            return true;
        }
        if (otherType.isInteger()) {
            if (this.isInteger()) {
                return this.getMaxLengthInBytes() >= otherType.getMaxLengthInBytes();
            }
            if (this == FLOAT && otherType != BIGINT) {
                return true;
            }
        }
        return false;
    }

    public char getSignatureChar() {
        assert (this.m_signatureChar != '0');
        return this.m_signatureChar;
    }

    public static String varbinaryToPrintableString(byte[] bin) {
        PureJavaCrc32 crc = new PureJavaCrc32();
        StringBuilder sb = new StringBuilder();
        sb.append("bin[crc:");
        crc.update(bin);
        sb.append(crc.getValue());
        sb.append(",value:0x");
        String hex = Encoder.hexEncode(bin);
        if (hex.length() > 13) {
            sb.append(hex.substring(0, 10));
            sb.append("...");
        } else {
            sb.append(hex);
        }
        sb.append("]");
        return sb.toString();
    }

    public Integer[] getTypePrecisionAndRadix() {
        Integer[] col_size_radix = new Integer[]{null, null};
        switch (this) {
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case TIMESTAMP: {
                col_size_radix[0] = this.getLengthInBytesForFixedTypes() * 8 - 1;
                col_size_radix[1] = 2;
                break;
            }
            case FLOAT: {
                col_size_radix[0] = 53;
                col_size_radix[1] = 2;
                break;
            }
            case STRING: {
                col_size_radix[0] = 0x100000;
                col_size_radix[1] = null;
                break;
            }
            case DECIMAL: {
                col_size_radix[0] = 38;
                col_size_radix[1] = 10;
                break;
            }
            case VARBINARY: {
                col_size_radix[0] = 0x100000;
                col_size_radix[1] = null;
                break;
            }
        }
        return col_size_radix;
    }

    static {
        $VALUES = new VoltType[]{INVALID, NULL, NUMERIC, TINYINT, SMALLINT, INTEGER, BIGINT, FLOAT, TIMESTAMP, STRING, VOLTTABLE, DECIMAL, VARBINARY, BOOLEAN};
        s_types = new VoltType[26];
        ImmutableMap.Builder<Class<?>, VoltType> b = ImmutableMap.builder();
        HashMap validation = new HashMap();
        VoltType[] arr$ = VoltType.values();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            VoltType type;
            VoltType.s_types[type.m_val] = type = arr$[i$];
            for (Class<?> cls : type.m_classes) {
                if (validation.get(cls) != null) {
                    throw new RuntimeException("Associate each java class with at most one VoltType.");
                }
                validation.put(cls, type);
                b.put(cls, type);
            }
        }
        s_classes = b.build();
        NULL_TIMESTAMP = new NullTimestampSigil();
        NULL_STRING_OR_VARBINARY = new NullStringOrVarbinarySigil();
        NULL_DECIMAL = new NullDecimalSigil();
    }

    private static final class NullDecimalSigil {
        private NullDecimalSigil() {
        }
    }

    private static final class NullStringOrVarbinarySigil {
        private NullStringOrVarbinarySigil() {
        }
    }

    private static final class NullTimestampSigil {
        private NullTimestampSigil() {
        }
    }
}

