/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.client;

import com.google_voltpatches.common.base.Predicate;
import com.google_voltpatches.common.collect.FluentIterable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import org.voltcore.logging.VoltLogger;
import org.voltdb.client.Client;
import org.voltdb.client.ClientAuthHashScheme;
import org.voltdb.client.ClientConfig;
import org.voltdb.client.ClientFactory;
import org.voltdb.client.ClientImpl;
import org.voltdb.client.ClientStatusListenerExt;

public class AuthenticatedConnectionCache {
    private static VoltLogger logger = new VoltLogger("HOST");
    private static final String ADMIN_SUFFIX = ":++__ADMIN__++";
    final String m_hostname;
    final String m_adminHostName;
    final int m_port;
    final int m_adminPort;
    final int m_targetSize;
    Map<String, Connection> m_connections = new TreeMap<String, Connection>();
    ClientImpl m_unauthClient = null;
    ClientImpl m_adminUnauthClient = null;
    private Predicate<InetSocketAddress> onAdminPort = new Predicate<InetSocketAddress>(){

        @Override
        public boolean apply(InetSocketAddress input) {
            return input.getPort() == AuthenticatedConnectionCache.this.m_adminPort;
        }
    };

    public AuthenticatedConnectionCache(int targetSize, String serverHostname, int serverPort, String adminHostName, int adminPort) {
        assert (serverHostname != null);
        assert (serverPort > 0);
        this.m_hostname = serverHostname;
        this.m_adminHostName = adminHostName;
        this.m_port = serverPort;
        this.m_adminPort = adminPort;
        this.m_targetSize = targetSize;
    }

    public synchronized ClientWithHashScheme getClient(String userName, String password, byte[] hashedPassword, boolean admin) throws IOException {
        String userNameWithAdminSuffix = null;
        if (userName != null && !userName.trim().isEmpty()) {
            if (userName.endsWith(ADMIN_SUFFIX)) {
                throw new IOException("User name cannot end with :++__ADMIN__++");
            }
            userNameWithAdminSuffix = userName + ADMIN_SUFFIX;
        }
        if (userName == null || userName.trim().isEmpty()) {
            if (hashedPassword != null && hashedPassword.length > 0) {
                throw new IOException("Username was null but password was not.");
            }
            if (this.m_unauthClient == null) {
                try {
                    this.m_unauthClient = (ClientImpl)ClientFactory.createClient();
                    this.m_unauthClient.createConnection(this.m_hostname, this.m_port);
                }
                catch (IOException e) {
                    try {
                        this.m_unauthClient.close();
                    }
                    catch (InterruptedException ex) {
                        throw new IOException("Unable to close rejected unauthenticated client connection", ex);
                    }
                    this.m_unauthClient = null;
                    throw e;
                }
            }
            if (this.m_adminUnauthClient == null) {
                try {
                    this.m_adminUnauthClient = (ClientImpl)ClientFactory.createClient();
                    this.m_adminUnauthClient.createConnection(this.m_hostname, this.m_adminPort);
                }
                catch (IOException e) {
                    try {
                        this.m_adminUnauthClient.close();
                    }
                    catch (InterruptedException ex) {
                        throw new IOException("Unable to close rejected unauthenticated admin client connection", ex);
                    }
                    this.m_adminUnauthClient = null;
                    throw e;
                }
            }
            assert (this.m_unauthClient != null);
            assert (this.m_adminUnauthClient != null);
            return new ClientWithHashScheme(admin ? this.m_adminUnauthClient : this.m_unauthClient, ClientAuthHashScheme.HASH_SHA256);
        }
        int passHash = 0;
        if (hashedPassword != null) {
            passHash = Arrays.hashCode(hashedPassword);
        }
        ClientAuthHashScheme scheme = hashedPassword == null ? ClientAuthHashScheme.HASH_SHA256 : ClientAuthHashScheme.getByUnencodedLength(hashedPassword.length);
        String ckey = (admin ? userNameWithAdminSuffix : userName) + (Object)((Object)scheme);
        Connection conn = this.m_connections.get(ckey);
        if (conn != null) {
            if (conn.passHash != passHash) {
                throw new IOException("Incorrect authorization credentials.");
            }
            ++conn.refCount;
        } else {
            conn = new Connection();
            conn.refCount = 1;
            conn.passHash = passHash;
            conn.hashedPassword = (byte[])(hashedPassword != null ? Arrays.copyOf(hashedPassword, hashedPassword.length) : null);
            ClientConfig config = new ClientConfig(userName, password, true, new StatusListener(conn), scheme);
            conn.user = userName;
            conn.client = (ClientImpl)ClientFactory.createClient(config);
            conn.scheme = scheme;
            try {
                conn.client.createConnectionWithHashedCredentials(this.m_hostname, admin ? this.m_adminPort : this.m_port, userName, hashedPassword);
            }
            catch (IOException ioe) {
                try {
                    conn.client.close();
                }
                catch (InterruptedException ex) {
                    throw new IOException("Unable to close rejected authenticated " + (admin ? "admin " : "") + "client connection.", ex);
                }
                conn = null;
                throw ioe;
            }
            this.m_connections.put(ckey, conn);
            this.attemptToShrinkPoolIfNeeded();
        }
        return new ClientWithHashScheme(conn.client, scheme);
    }

    public synchronized void releaseClient(Client client, ClientAuthHashScheme scheme, boolean force) {
        String ckey;
        Connection conn;
        ClientImpl ci = (ClientImpl)client;
        if (force) {
            if (client == this.m_unauthClient) {
                this.closeClient(this.m_unauthClient);
                this.m_unauthClient = null;
                return;
            }
            if (client == this.m_adminUnauthClient) {
                this.closeClient(this.m_adminUnauthClient);
                this.m_adminUnauthClient = null;
                return;
            }
        }
        if (ci.getUsername().length() == 0) {
            return;
        }
        StringBuilder userNameBuilder = new StringBuilder(ci.getUsername());
        if (FluentIterable.from(ci.getConnectedHostList()).allMatch(this.onAdminPort)) {
            userNameBuilder.append(ADMIN_SUFFIX);
        }
        if ((conn = this.m_connections.get(ckey = userNameBuilder.toString() + (Object)((Object)scheme))) == null) {
            throw new RuntimeException("Released client not in pool.");
        }
        conn.refCount = force ? 0 : --conn.refCount;
        this.attemptToShrinkPoolIfNeeded();
    }

    private synchronized void closeClient(Client client) {
        if (client == null) {
            return;
        }
        try {
            client.drain();
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            client.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void closeAll() {
        if (this.m_unauthClient != null) {
            this.closeClient(this.m_unauthClient);
            this.m_unauthClient = null;
        }
        if (this.m_adminUnauthClient != null) {
            this.closeClient(this.m_adminUnauthClient);
            this.m_adminUnauthClient = null;
        }
        for (Map.Entry<String, Connection> e : this.m_connections.entrySet()) {
            this.closeClient(e.getValue().client);
        }
        this.m_connections.clear();
    }

    private void attemptToShrinkPoolIfNeeded() {
        if (this.m_connections.size() > this.m_targetSize) {
            for (Map.Entry<String, Connection> e : this.m_connections.entrySet()) {
                if (e.getValue().refCount > 0) continue;
                this.m_connections.remove(e.getKey());
                this.closeClient(e.getValue().client);
                break;
            }
            return;
        }
    }

    public int getSize() {
        if (this.m_connections == null) {
            return 0;
        }
        return this.m_connections.size();
    }

    public Client getUnauthenticatedAdminClient() {
        return this.m_adminUnauthClient;
    }

    public Client getUnauthenticatedClient() {
        return this.m_unauthClient;
    }

    public class ClientWithHashScheme {
        public final Client m_client;
        public final ClientAuthHashScheme m_scheme;

        public ClientWithHashScheme(Client client, ClientAuthHashScheme scheme) {
            this.m_client = client;
            this.m_scheme = scheme;
        }
    }

    class StatusListener
    extends ClientStatusListenerExt {
        Connection m_conn = null;

        StatusListener(Connection conn) {
            this.m_conn = conn;
        }

        @Override
        public void connectionLost(String hostname, int port, int connectionsLeft, ClientStatusListenerExt.DisconnectCause cause) {
            logger.debug("Connection lost was reported for internal client.");
        }
    }

    class Connection {
        int refCount;
        ClientImpl client;
        String user;
        byte[] hashedPassword;
        int passHash;
        ClientAuthHashScheme scheme;

        Connection() {
        }
    }
}

