/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.client;

public enum ClientAuthHashScheme {
    HASH_SHA1(0),
    HASH_SHA256(1);

    private static final ClientAuthHashScheme[] theList;
    private final int value;

    private ClientAuthHashScheme(int v) {
        this.value = v;
    }

    public int getValue() {
        return this.value;
    }

    public static final ClientAuthHashScheme get(int i) {
        if (i >= theList.length) {
            throw new IllegalArgumentException("Invalid Hash Scheme");
        }
        return theList[i];
    }

    public static final ClientAuthHashScheme getByUnencodedLength(int i) {
        switch (i) {
            case 20: {
                return HASH_SHA1;
            }
            case 32: {
                return HASH_SHA256;
            }
        }
        throw new IllegalArgumentException("Invalid Hash Scheme for given length: " + i);
    }

    public static final int getDigestLength(ClientAuthHashScheme scheme) {
        switch (scheme) {
            case HASH_SHA1: {
                return 20;
            }
            case HASH_SHA256: {
                return 32;
            }
        }
        throw new IllegalArgumentException("Invalid Hash Scheme for Authentication.");
    }

    public static final int getHexencodedDigestLength(ClientAuthHashScheme scheme) {
        switch (scheme) {
            case HASH_SHA1: {
                return 40;
            }
            case HASH_SHA256: {
                return 64;
            }
        }
        throw new IllegalArgumentException("Invalid Hash Scheme for Authentication.");
    }

    public static final String getDigestScheme(ClientAuthHashScheme scheme) {
        switch (scheme) {
            case HASH_SHA1: {
                return "SHA-1";
            }
            case HASH_SHA256: {
                return "SHA-256";
            }
        }
        throw new IllegalArgumentException("Invalid Hash Digest Scheme for Authentication.");
    }

    static {
        theList = new ClientAuthHashScheme[]{HASH_SHA1, HASH_SHA256};
    }
}

