/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.client;

import java.math.RoundingMode;
import java.util.concurrent.TimeUnit;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.voltdb.client.ClientAuthHashScheme;
import org.voltdb.client.ClientStatusListener;
import org.voltdb.client.ClientStatusListenerExt;
import org.voltdb.client.ClientStatusListenerWrapper;
import org.voltdb.types.VoltDecimalHelper;

public class ClientConfig {
    static final long DEFAULT_PROCEDURE_TIMOUT_NANOS = TimeUnit.MINUTES.toNanos(2L);
    static final long DEFAULT_CONNECTION_TIMOUT_MS = 120000L;
    static final long DEFAULT_INITIAL_CONNECTION_RETRY_INTERVAL_MS = 1000L;
    static final long DEFAULT_MAX_CONNECTION_RETRY_INTERVAL_MS = 8000L;
    final ClientAuthHashScheme m_hashScheme;
    final String m_username;
    final String m_password;
    final boolean m_cleartext;
    final ClientStatusListenerExt m_listener;
    boolean m_heavyweight = false;
    int m_maxOutstandingTxns = 3000;
    int m_maxTransactionsPerSecond = Integer.MAX_VALUE;
    boolean m_autoTune = false;
    int m_autoTuneTargetInternalLatency = 5;
    long m_procedureCallTimeoutNanos = DEFAULT_PROCEDURE_TIMOUT_NANOS;
    long m_connectionResponseTimeoutMS = 120000L;
    boolean m_useClientAffinity = true;
    Subject m_subject = null;
    boolean m_reconnectOnConnectionLoss;
    long m_initialConnectionRetryIntervalMS = 1000L;
    long m_maxConnectionRetryIntervalMS = 8000L;

    public ClientConfig() {
        this.m_username = "";
        this.m_password = "";
        this.m_listener = null;
        this.m_cleartext = true;
        this.m_hashScheme = ClientAuthHashScheme.HASH_SHA256;
    }

    public ClientConfig(String username, String password) {
        this(username, password, true, null, ClientAuthHashScheme.HASH_SHA256);
    }

    @Deprecated
    public ClientConfig(String username, String password, ClientStatusListener listener, ClientAuthHashScheme scheme) {
        this(username, password, true, new ClientStatusListenerWrapper(listener), scheme);
    }

    public ClientConfig(String username, String password, ClientStatusListenerExt listener) {
        this(username, password, true, listener, ClientAuthHashScheme.HASH_SHA256);
    }

    public ClientConfig(String username, String password, ClientStatusListenerExt listener, ClientAuthHashScheme scheme) {
        this(username, password, true, listener, scheme);
    }

    public ClientConfig(String username, String password, boolean cleartext, ClientStatusListenerExt listener) {
        this(username, password, cleartext, listener, ClientAuthHashScheme.HASH_SHA256);
    }

    public ClientConfig(String username, String password, boolean cleartext, ClientStatusListenerExt listener, ClientAuthHashScheme scheme) {
        this.m_username = username == null ? "" : username;
        this.m_password = password == null ? "" : password;
        this.m_listener = listener;
        this.m_cleartext = cleartext;
        this.m_hashScheme = scheme;
    }

    public void setProcedureCallTimeout(long ms) {
        assert (ms >= 0L);
        if (ms < 0L) {
            ms = 0L;
        }
        if (ms == 0L) {
            ms = Long.MAX_VALUE;
        }
        this.m_procedureCallTimeoutNanos = TimeUnit.MILLISECONDS.toNanos(ms);
    }

    public void setConnectionResponseTimeout(long ms) {
        assert (ms >= 0L);
        if (ms < 0L) {
            ms = 0L;
        }
        if (ms == 0L) {
            ms = Long.MAX_VALUE;
        }
        this.m_connectionResponseTimeoutMS = ms;
    }

    @Deprecated
    public void setMaxArenaSizes(int[] maxArenaSizes) {
    }

    public void setHeavyweight(boolean heavyweight) {
        this.m_heavyweight = heavyweight;
    }

    @Deprecated
    public void setExpectedOutgoingMessageSize(int size) {
    }

    public void setMaxOutstandingTxns(int maxOutstanding) {
        if (maxOutstanding < 1) {
            throw new IllegalArgumentException("Max outstanding must be greater than 0, " + maxOutstanding + " was specified");
        }
        this.m_maxOutstandingTxns = maxOutstanding;
    }

    public void setMaxTransactionsPerSecond(int maxTxnsPerSecond) {
        if (maxTxnsPerSecond < 1) {
            throw new IllegalArgumentException("Max TPS must be greater than 0, " + maxTxnsPerSecond + " was specified");
        }
        this.m_maxTransactionsPerSecond = maxTxnsPerSecond;
    }

    public void enableAutoTune() {
        this.m_autoTune = true;
    }

    public void setClientAffinity(boolean on) {
        this.m_useClientAffinity = on;
    }

    public void setReconnectOnConnectionLoss(boolean on) {
        this.m_reconnectOnConnectionLoss = on;
    }

    public void setInitialConnectionRetryInterval(long ms) {
        this.m_initialConnectionRetryIntervalMS = ms;
    }

    public void setMaxConnectionRetryInterval(long ms) {
        this.m_maxConnectionRetryIntervalMS = ms;
    }

    public void setAutoTuneTargetInternalLatency(int targetLatency) {
        if (targetLatency < 1) {
            throw new IllegalArgumentException("Max auto tune latency must be greater than 0, " + targetLatency + " was specified");
        }
        this.m_autoTuneTargetInternalLatency = targetLatency;
    }

    public void enableKerberosAuthentication(Subject subject) {
        this.m_subject = subject;
    }

    public void enableKerberosAuthentication(String loginContextEntryKey) {
        try {
            LoginContext lc = new LoginContext(loginContextEntryKey);
            lc.login();
            this.m_subject = lc.getSubject();
        }
        catch (SecurityException ex) {
            throw new IllegalArgumentException("Cannot determine client consumer's credentials", ex);
        }
        catch (LoginException ex) {
            throw new IllegalArgumentException("Cannot determine client consumer's credentials", ex);
        }
    }

    public static void setRoundingConfig(boolean isEnabled, RoundingMode mode) {
        VoltDecimalHelper.setRoundingConfig(isEnabled, mode);
    }
}

