/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.client;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import org.voltdb.ClientResponseImpl;
import org.voltdb.VoltTable;
import org.voltdb.client.Client;
import org.voltdb.client.ClientAuthHashScheme;
import org.voltdb.client.ClientConfig;
import org.voltdb.client.ClientResponse;
import org.voltdb.client.ClientStats;
import org.voltdb.client.ClientStatsContext;
import org.voltdb.client.ClientStatusListenerExt;
import org.voltdb.client.ClientUtils;
import org.voltdb.client.ConnectionUtil;
import org.voltdb.client.Distributer;
import org.voltdb.client.HashinatorLite;
import org.voltdb.client.NoConnectionsException;
import org.voltdb.client.NullCallback;
import org.voltdb.client.ProcCallException;
import org.voltdb.client.ProcedureArgumentCacher;
import org.voltdb.client.ProcedureCallback;
import org.voltdb.client.ProcedureInvocation;
import org.voltdb.client.ReconnectStatusListener;
import org.voltdb.client.ReplicaProcCaller;
import org.voltdb.client.SyncCallback;
import org.voltdb.client.VoltBulkLoader.BulkLoaderFailureCallBack;
import org.voltdb.client.VoltBulkLoader.BulkLoaderState;
import org.voltdb.client.VoltBulkLoader.VoltBulkLoader;
import org.voltdb.common.Constants;
import org.voltdb.utils.Encoder;

public final class ClientImpl
implements Client,
ReplicaProcCaller {
    private final AtomicLong m_handle = new AtomicLong(0L);
    private boolean m_credentialsSet = false;
    private final ReentrantLock m_credentialComparisonLock = new ReentrantLock();
    private String m_createConnectionUsername = null;
    private byte[] m_hashedPassword = null;
    private int m_passwordHashCode = 0;
    final CSL m_listener = new CSL();
    private final String m_username;
    private final byte[] m_passwordHash;
    private final ClientAuthHashScheme m_hashScheme;
    private final CopyOnWriteArrayList<Long> m_blessedThreadIds = new CopyOnWriteArrayList();
    private BulkLoaderState m_vblGlobals = new BulkLoaderState(this);
    private volatile boolean m_isShutdown = false;
    static final Logger LOG = Logger.getLogger(ClientImpl.class.getName());
    private final Distributer m_distributer;
    private final Object m_backpressureLock = new Object();
    private boolean m_backpressure = false;
    private boolean m_blockingQueue = true;
    private final ReconnectStatusListener m_reconnectStatusListener;

    ClientImpl(ClientConfig config) {
        this.m_distributer = new Distributer(config.m_heavyweight, config.m_procedureCallTimeoutNanos, config.m_connectionResponseTimeoutMS, config.m_useClientAffinity, config.m_subject);
        this.m_distributer.addClientStatusListener(this.m_listener);
        String username = config.m_username;
        if (config.m_subject != null) {
            username = config.m_subject.getPrincipals().iterator().next().getName();
        }
        this.m_username = username;
        if (config.m_reconnectOnConnectionLoss) {
            this.m_reconnectStatusListener = new ReconnectStatusListener(this, config.m_initialConnectionRetryIntervalMS, config.m_maxConnectionRetryIntervalMS);
            this.m_distributer.addClientStatusListener(this.m_reconnectStatusListener);
        } else {
            this.m_reconnectStatusListener = null;
        }
        this.m_hashScheme = config.m_hashScheme;
        this.m_passwordHash = config.m_cleartext ? ConnectionUtil.getHashedPassword(this.m_hashScheme, config.m_password) : Encoder.hexDecode(config.m_password);
        if (config.m_listener != null) {
            this.m_distributer.addClientStatusListener(config.m_listener);
        }
        assert (config.m_maxOutstandingTxns > 0);
        this.m_blessedThreadIds.addAll(this.m_distributer.getThreadIds());
        if (config.m_autoTune) {
            this.m_distributer.m_rateLimiter.enableAutoTuning(config.m_autoTuneTargetInternalLatency);
        } else {
            this.m_distributer.m_rateLimiter.setLimits(config.m_maxTransactionsPerSecond, config.m_maxOutstandingTxns);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean verifyCredentialsAreAlwaysTheSame(String username, byte[] hashedPassword) {
        assert (username != null);
        this.m_credentialComparisonLock.lock();
        try {
            if (!this.m_credentialsSet) {
                this.m_credentialsSet = true;
                this.m_createConnectionUsername = username;
                if (hashedPassword != null) {
                    this.m_hashedPassword = Arrays.copyOf(hashedPassword, hashedPassword.length);
                    this.m_passwordHashCode = Arrays.hashCode(hashedPassword);
                }
                boolean bl = true;
                return bl;
            }
            if (!this.m_createConnectionUsername.equals(username)) {
                boolean bl = false;
                return bl;
            }
            if (hashedPassword == null) {
                boolean bl = this.m_hashedPassword == null;
                return bl;
            }
            for (int i = 0; i < hashedPassword.length; ++i) {
                if (hashedPassword[i] == this.m_hashedPassword[i]) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.m_credentialComparisonLock.unlock();
        }
    }

    public String getUsername() {
        return this.m_createConnectionUsername;
    }

    public int getPasswordHashCode() {
        return this.m_passwordHashCode;
    }

    public void createConnectionWithHashedCredentials(String host, int port, String program, byte[] hashedPassword) throws IOException {
        byte[] subPassword;
        if (this.m_isShutdown) {
            throw new IOException("Client instance is shutdown");
        }
        String subProgram = program == null ? "" : program;
        byte[] byArray = subPassword = hashedPassword == null ? ConnectionUtil.getHashedPassword(this.m_hashScheme, "") : hashedPassword;
        if (!this.verifyCredentialsAreAlwaysTheSame(subProgram, subPassword)) {
            throw new IOException("New connection authorization credentials do not match previous credentials for client.");
        }
        this.m_distributer.createConnectionWithHashedCredentials(host, subProgram, subPassword, port, this.m_hashScheme);
    }

    @Override
    public final ClientResponse callProcedure(String procName, Object ... parameters) throws IOException, NoConnectionsException, ProcCallException {
        return this.callProcedureWithTimeout(procName, 0L, TimeUnit.SECONDS, parameters);
    }

    public ClientResponse callProcedureWithTimeout(String procName, long timeout, TimeUnit unit, Object ... parameters) throws IOException, NoConnectionsException, ProcCallException {
        SyncCallback cb = new SyncCallback();
        cb.setArgs(parameters);
        ProcedureInvocation invocation = new ProcedureInvocation(this.m_handle.getAndIncrement(), procName, parameters);
        return this.callProcedure(cb, System.nanoTime(), unit.toNanos(timeout), invocation);
    }

    @Override
    public ClientResponse callProcedure(long originalTxnId, long originalUniqueId, String procName, Object ... parameters) throws IOException, NoConnectionsException, ProcCallException {
        SyncCallback cb = new SyncCallback();
        cb.setArgs(parameters);
        ProcedureInvocation invocation = new ProcedureInvocation(originalTxnId, originalUniqueId, this.m_handle.getAndIncrement(), procName, parameters);
        return this.callProcedure(cb, System.nanoTime(), 0L, invocation);
    }

    private final ClientResponse callProcedure(SyncCallback cb, long nowNanos, long timeout, ProcedureInvocation invocation) throws IOException, NoConnectionsException, ProcCallException {
        if (this.m_isShutdown) {
            throw new NoConnectionsException("Client instance is shutdown");
        }
        if (this.m_blessedThreadIds.contains(Thread.currentThread().getId())) {
            throw new IOException("Can't invoke a procedure synchronously from with the client callback thread  without deadlocking the client library");
        }
        this.m_distributer.queue(invocation, cb, true, nowNanos, timeout);
        try {
            cb.waitForResponse();
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException("Interrupted while waiting for response");
        }
        if (cb.getResponse().getStatus() != 1) {
            throw new ProcCallException(cb.getResponse(), cb.getResponse().getStatusString(), null);
        }
        return cb.getResponse();
    }

    @Override
    public final boolean callProcedure(ProcedureCallback callback, String procName, Object ... parameters) throws IOException, NoConnectionsException {
        return this.callProcedureWithTimeout(callback, procName, 0L, TimeUnit.NANOSECONDS, parameters);
    }

    public boolean callProcedureWithTimeout(ProcedureCallback callback, String procName, long timeout, TimeUnit unit, Object ... parameters) throws IOException, NoConnectionsException {
        if (this.m_isShutdown) {
            return false;
        }
        if (callback instanceof ProcedureArgumentCacher) {
            ((ProcedureArgumentCacher)((Object)callback)).setArgs(parameters);
        }
        ProcedureInvocation invocation = new ProcedureInvocation(this.m_handle.getAndIncrement(), procName, parameters);
        return this.private_callProcedure(callback, 0, invocation, unit.toNanos(timeout));
    }

    @Override
    public final boolean callProcedure(long originalTxnId, long originalUniqueId, ProcedureCallback callback, String procName, Object ... parameters) throws IOException, NoConnectionsException {
        if (callback instanceof ProcedureArgumentCacher) {
            ((ProcedureArgumentCacher)((Object)callback)).setArgs(parameters);
        }
        ProcedureInvocation invocation = new ProcedureInvocation(originalTxnId, originalUniqueId, this.m_handle.getAndIncrement(), procName, parameters);
        return this.private_callProcedure(callback, 0, invocation, 0L);
    }

    @Override
    public int calculateInvocationSerializedSize(String procName, Object ... parameters) {
        ProcedureInvocation invocation = new ProcedureInvocation(0L, procName, parameters);
        return invocation.getSerializedSize();
    }

    @Override
    public final boolean callProcedure(ProcedureCallback callback, int expectedSerializedSize, String procName, Object ... parameters) throws NoConnectionsException, IOException {
        if (callback instanceof ProcedureArgumentCacher) {
            ((ProcedureArgumentCacher)((Object)callback)).setArgs(parameters);
        }
        ProcedureInvocation invocation = new ProcedureInvocation(this.m_handle.getAndIncrement(), procName, parameters);
        return this.private_callProcedure(callback, expectedSerializedSize, invocation, 0L);
    }

    private final boolean private_callProcedure(ProcedureCallback callback, int expectedSerializedSize, ProcedureInvocation invocation, long timeoutNanos) throws IOException, NoConnectionsException {
        if (this.m_isShutdown) {
            return false;
        }
        if (callback == null) {
            callback = new NullCallback();
        }
        long nowNanos = System.nanoTime();
        boolean isBlessed = this.m_blessedThreadIds.contains(Thread.currentThread().getId());
        if (this.m_blockingQueue) {
            while (!this.m_distributer.queue(invocation, callback, isBlessed, nowNanos, timeoutNanos)) {
                long delta = Math.max(1L, System.nanoTime() - nowNanos);
                long timeout = timeoutNanos == 0L ? this.m_distributer.getProcedureTimeoutNanos() : timeoutNanos;
                try {
                    if (!this.backpressureBarrier(nowNanos, timeout - delta)) continue;
                    ClientResponseImpl r = new ClientResponseImpl(-6, -128, "", new VoltTable[0], String.format("No response received in the allotted time (set to %d ms).", TimeUnit.NANOSECONDS.toMillis(timeoutNanos)));
                    try {
                        callback.clientCallback(r);
                    }
                    catch (Throwable t) {
                        this.m_distributer.uncaughtException(callback, r, t);
                    }
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException("Interrupted while invoking procedure asynchronously");
                }
            }
            return true;
        }
        return this.m_distributer.queue(invocation, callback, isBlessed, nowNanos, timeoutNanos);
    }

    private Object[] getUpdateCatalogParams(File catalogPath, File deploymentPath) throws IOException {
        Object[] params = new Object[]{catalogPath != null ? (Object)ClientUtils.fileToBytes(catalogPath) : null, deploymentPath != null ? new String(ClientUtils.fileToBytes(deploymentPath), Constants.UTF8ENCODING) : null};
        return params;
    }

    @Override
    public ClientResponse updateApplicationCatalog(File catalogPath, File deploymentPath) throws IOException, NoConnectionsException, ProcCallException {
        Object[] params = this.getUpdateCatalogParams(catalogPath, deploymentPath);
        return this.callProcedure("@UpdateApplicationCatalog", params);
    }

    @Override
    public boolean updateApplicationCatalog(ProcedureCallback callback, File catalogPath, File deploymentPath) throws IOException, NoConnectionsException {
        Object[] params = this.getUpdateCatalogParams(catalogPath, deploymentPath);
        return this.callProcedure(callback, "@UpdateApplicationCatalog", params);
    }

    @Override
    public ClientResponse updateClasses(File jarPath, String classesToDelete) throws IOException, NoConnectionsException, ProcCallException {
        byte[] jarbytes = null;
        if (jarPath != null) {
            jarbytes = ClientUtils.fileToBytes(jarPath);
        }
        return this.callProcedure("@UpdateClasses", jarbytes, classesToDelete);
    }

    @Override
    public boolean updateClasses(ProcedureCallback callback, File jarPath, String classesToDelete) throws IOException, NoConnectionsException {
        byte[] jarbytes = null;
        if (jarPath != null) {
            jarbytes = ClientUtils.fileToBytes(jarPath);
        }
        return this.callProcedure(callback, "@UpdateClasses", jarbytes, classesToDelete);
    }

    @Override
    public void drain() throws InterruptedException {
        if (this.m_isShutdown) {
            return;
        }
        if (this.m_blessedThreadIds.contains(Thread.currentThread().getId())) {
            throw new RuntimeException("Can't invoke backpressureBarrier from within the client callback thread  without deadlocking the client library");
        }
        this.m_distributer.drain();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws InterruptedException {
        if (this.m_blessedThreadIds.contains(Thread.currentThread().getId())) {
            throw new RuntimeException("Can't invoke backpressureBarrier from within the client callback thread  without deadlocking the client library");
        }
        this.m_isShutdown = true;
        Object object = this.m_backpressureLock;
        synchronized (object) {
            this.m_backpressureLock.notifyAll();
        }
        if (this.m_reconnectStatusListener != null) {
            this.m_distributer.removeClientStatusListener(this.m_reconnectStatusListener);
        }
        this.m_distributer.shutdown();
    }

    @Override
    public void backpressureBarrier() throws InterruptedException {
        this.backpressureBarrier(0L, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean backpressureBarrier(long start, long timeoutNanos) throws InterruptedException {
        if (this.m_isShutdown) {
            return false;
        }
        if (this.m_blessedThreadIds.contains(Thread.currentThread().getId())) {
            throw new RuntimeException("Can't invoke backpressureBarrier from within the client callback thread  without deadlocking the client library");
        }
        if (this.m_backpressure) {
            Object object = this.m_backpressureLock;
            synchronized (object) {
                if (this.m_backpressure) {
                    while (this.m_backpressure && !this.m_isShutdown) {
                        if (start != 0L) {
                            this.m_backpressureLock.wait(timeoutNanos / TimeUnit.MILLISECONDS.toNanos(1L), (int)(timeoutNanos % TimeUnit.MILLISECONDS.toNanos(1L)));
                            if (!this.m_backpressure) break;
                            long nowNanos = System.nanoTime();
                            long deltaNanos = Math.max(1L, nowNanos - start);
                            if (deltaNanos >= timeoutNanos) {
                                return true;
                            }
                            timeoutNanos -= deltaNanos;
                            continue;
                        }
                        this.m_backpressureLock.wait();
                    }
                }
            }
        }
        return false;
    }

    @Override
    public void configureBlocking(boolean blocking) {
        this.m_blockingQueue = blocking;
    }

    @Override
    public ClientStatsContext createStatsContext() {
        return this.m_distributer.createStatsContext();
    }

    @Override
    public Object[] getInstanceId() {
        return this.m_distributer.getInstanceId();
    }

    public void resetInstanceId() {
        this.m_distributer.resetInstanceId();
    }

    @Override
    public String getBuildString() {
        return this.m_distributer.getBuildString();
    }

    @Override
    public boolean blocking() {
        return this.m_blockingQueue;
    }

    private static String getHostnameFromHostnameColonPort(String server) {
        String[] parts = (server = server.trim()).split(":");
        if (parts.length == 1) {
            return server;
        }
        assert (parts.length == 2);
        return parts[0].trim();
    }

    public static int getPortFromHostnameColonPort(String server, int defaultPort) {
        String[] parts = server.split(":");
        if (parts.length == 1) {
            return defaultPort;
        }
        assert (parts.length == 2);
        return Integer.parseInt(parts[1]);
    }

    @Override
    public void createConnection(String host) throws UnknownHostException, IOException {
        if (this.m_username == null) {
            throw new IllegalStateException("Attempted to use createConnection(String host) with a client that wasn't constructed with a username and password specified");
        }
        int port = ClientImpl.getPortFromHostnameColonPort(host, 21212);
        host = ClientImpl.getHostnameFromHostnameColonPort(host);
        this.createConnectionWithHashedCredentials(host, port, this.m_username, this.m_passwordHash);
    }

    @Override
    public void createConnection(String host, int port) throws UnknownHostException, IOException {
        if (this.m_username == null) {
            throw new IllegalStateException("Attempted to use createConnection(String host) with a client that wasn't constructed with a username and password specified");
        }
        this.createConnectionWithHashedCredentials(host, port, this.m_username, this.m_passwordHash);
    }

    @Override
    public List<InetSocketAddress> getConnectedHostList() {
        return this.m_distributer.getConnectedHostList();
    }

    @Override
    public int[] getThroughputAndOutstandingTxnLimits() {
        return this.m_distributer.m_rateLimiter.getLimits();
    }

    @Override
    public void writeSummaryCSV(ClientStats stats, String path) throws IOException {
        if (path == null || path.length() == 0) {
            return;
        }
        FileWriter fw = new FileWriter(path);
        fw.append(String.format("%d,%d,%d,%.2f,%.2f,%.2f,%.2f,%.2f,%.2f,%.2f,%d,%d,%d\n", stats.getStartTimestamp(), stats.getDuration(), stats.getInvocationsCompleted(), stats.kPercentileLatencyAsDouble(0.0), stats.kPercentileLatencyAsDouble(1.0), stats.kPercentileLatencyAsDouble(0.95), stats.kPercentileLatencyAsDouble(0.99), stats.kPercentileLatencyAsDouble(0.999), stats.kPercentileLatencyAsDouble(0.9999), stats.kPercentileLatencyAsDouble(0.99999), stats.getInvocationErrors(), stats.getInvocationAborts(), stats.getInvocationTimeouts()));
        fw.close();
    }

    public boolean isHashinatorInitialized() {
        return this.m_distributer.isHashinatorInitialized();
    }

    public long getPartitionForParameter(byte typeValue, Object value) {
        return this.m_distributer.getPartitionForParameter(typeValue, value);
    }

    public HashinatorLite.HashinatorLiteType getHashinatorType() {
        return this.m_distributer.getHashinatorType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VoltBulkLoader getNewBulkLoader(String tableName, int maxBatchSize, boolean upsertMode, BulkLoaderFailureCallBack blfcb) throws Exception {
        BulkLoaderState bulkLoaderState = this.m_vblGlobals;
        synchronized (bulkLoaderState) {
            return new VoltBulkLoader(this.m_vblGlobals, tableName, maxBatchSize, upsertMode, blfcb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VoltBulkLoader getNewBulkLoader(String tableName, int maxBatchSize, BulkLoaderFailureCallBack blfcb) throws Exception {
        BulkLoaderState bulkLoaderState = this.m_vblGlobals;
        synchronized (bulkLoaderState) {
            return new VoltBulkLoader(this.m_vblGlobals, tableName, maxBatchSize, blfcb);
        }
    }

    class CSL
    extends ClientStatusListenerExt {
        CSL() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void backpressure(boolean status) {
            Object object = ClientImpl.this.m_backpressureLock;
            synchronized (object) {
                if (status) {
                    ClientImpl.this.m_backpressure = true;
                } else {
                    ClientImpl.this.m_backpressure = false;
                    ClientImpl.this.m_backpressureLock.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void connectionLost(String hostname, int port, int connectionsLeft, ClientStatusListenerExt.DisconnectCause cause) {
            if (connectionsLeft == 0) {
                Object object = ClientImpl.this.m_backpressureLock;
                synchronized (object) {
                    ClientImpl.this.m_backpressure = false;
                    ClientImpl.this.m_backpressureLock.notifyAll();
                }
            }
        }
    }
}

