/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.client;

import com.google_voltpatches.common.base.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.zip.InflaterOutputStream;
import org.apache.cassandra_voltpatches.MurmurHash3;
import org.voltcore.utils.Bits;
import org.voltcore.utils.Pair;
import org.voltdb.ParameterConverter;
import org.voltdb.VoltType;
import org.voltdb.VoltTypeException;
import org.voltdb.common.Constants;

public class HashinatorLite {
    private int catalogPartitionCount;
    private long m_etokens = 0L;
    private int m_etokenCount;
    private final HashinatorLiteType m_type;

    public static byte[] getLegacyConfigureBytes(int catalogPartitionCount) {
        ByteBuffer buf = ByteBuffer.allocate(4);
        buf.putInt(catalogPartitionCount);
        return buf.array();
    }

    public HashinatorLiteType getType() {
        return this.m_type;
    }

    public HashinatorLite(HashinatorLiteType type, byte[] configBytes, boolean cooked) {
        this.m_type = type;
        if (type == HashinatorLiteType.ELASTIC) {
            Pair<Long, Integer> p = cooked ? this.updateCooked(configBytes) : this.updateRaw(configBytes);
            this.m_etokens = p.getFirst();
            this.m_etokenCount = p.getSecond();
        } else {
            this.catalogPartitionCount = ByteBuffer.wrap(configBytes).getInt();
        }
    }

    public HashinatorLite(int numPartitions) {
        this(HashinatorLiteType.LEGACY, HashinatorLite.getLegacyConfigureBytes(numPartitions), false);
    }

    public void finalize() {
        if (this.m_etokens != 0L) {
            Bits.unsafe.freeMemory(this.m_etokens);
        }
    }

    private Pair<Long, Integer> updateCooked(byte[] compressedData) {
        int ii;
        byte[] cookedBytes;
        try {
            cookedBytes = HashinatorLite.gunzipBytes(compressedData);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to decompress elastic hashinator data.");
        }
        int numEntries = cookedBytes.length >= 4 ? ByteBuffer.wrap(cookedBytes).getInt() : 0;
        int tokensSize = 4 * numEntries;
        int partitionsSize = 4 * numEntries;
        if (numEntries <= 0 || cookedBytes.length != 4 + tokensSize + partitionsSize) {
            throw new RuntimeException("Bad elastic hashinator cooked config size.");
        }
        long tokens = Bits.unsafe.allocateMemory(8 * numEntries);
        ByteBuffer tokenBuf = ByteBuffer.wrap(cookedBytes, 4, tokensSize);
        ByteBuffer partitionBuf = ByteBuffer.wrap(cookedBytes, 4 + tokensSize, partitionsSize);
        int[] tokensArray = new int[numEntries];
        for (int zz = 3; zz >= 0; --zz) {
            for (ii = 0; ii < numEntries; ++ii) {
                int value = tokenBuf.get();
                value = value << zz * 8 & 255 << zz * 8;
                tokensArray[ii] = tokensArray[ii] | value;
            }
        }
        int lastToken = Integer.MIN_VALUE;
        for (ii = 0; ii < numEntries; ++ii) {
            int token = tokensArray[ii];
            Preconditions.checkArgument(token >= lastToken);
            lastToken = token;
            long ptr = tokens + (long)(ii * 8);
            Bits.unsafe.putInt(ptr, token);
            int partitionId = partitionBuf.getInt();
            Bits.unsafe.putInt(ptr + 4L, partitionId);
        }
        return Pair.of(tokens, numEntries);
    }

    private Pair<Long, Integer> updateRaw(byte[] configBytes) {
        ByteBuffer buf = ByteBuffer.wrap(configBytes);
        int numEntries = buf.getInt();
        if (numEntries < 0) {
            throw new RuntimeException("Bad elastic hashinator config");
        }
        long tokens = Bits.unsafe.allocateMemory(8 * numEntries);
        int lastToken = Integer.MIN_VALUE;
        for (int ii = 0; ii < numEntries; ++ii) {
            long ptr = tokens + (long)(ii * 8);
            int token = buf.getInt();
            Preconditions.checkArgument(token >= lastToken);
            lastToken = token;
            Bits.unsafe.putInt(ptr, token);
            int partitionId = buf.getInt();
            Bits.unsafe.putInt(ptr + 4L, partitionId);
        }
        return Pair.of(tokens, numEntries);
    }

    int hashinateLong(long value) {
        if (this.m_type.equals((Object)HashinatorLiteType.ELASTIC)) {
            if (value == Long.MIN_VALUE) {
                return 0;
            }
            return this.partitionForToken(MurmurHash3.hash3_x64_128(value));
        }
        if (value == Long.MIN_VALUE) {
            return 0;
        }
        int index = (int)(value ^ value >>> 32);
        return Math.abs(index % this.catalogPartitionCount);
    }

    public int partitionForToken(int hash) {
        long token = this.getTokenPtr(hash);
        return Bits.unsafe.getInt(token + 4L);
    }

    int hashinateBytes(byte[] bytes) {
        if (bytes == null) {
            return 0;
        }
        if (this.m_type.equals((Object)HashinatorLiteType.ELASTIC)) {
            ByteBuffer buf = ByteBuffer.wrap(bytes);
            int hash = MurmurHash3.hash3_x64_128(buf, 0, bytes.length, 0L);
            long token = this.getTokenPtr(hash);
            return Bits.unsafe.getInt(token + 4L);
        }
        int hashCode = 0;
        int offset = 0;
        for (int ii = 0; ii < bytes.length; ++ii) {
            hashCode = 31 * hashCode + bytes[offset++];
        }
        return Math.abs(hashCode % this.catalogPartitionCount);
    }

    private long getTokenPtr(int hash) {
        int min = 0;
        int max = this.m_etokenCount - 1;
        while (min <= max) {
            int mid = min + max >>> 1;
            long midPtr = this.m_etokens + (long)(8 * mid);
            int midval = Bits.unsafe.getInt(midPtr);
            if (midval < hash) {
                min = mid + 1;
                continue;
            }
            if (midval > hash) {
                max = mid - 1;
                continue;
            }
            return midPtr;
        }
        return this.m_etokens + (long)((min - 1) * 8);
    }

    int hashToPartition(VoltType type, Object obj) {
        if (this.m_type.equals((Object)HashinatorLiteType.ELASTIC)) {
            return this.hashinateBytes(HashinatorLite.valueToBytes(obj));
        }
        if (obj == null || VoltType.isNullVoltType(obj)) {
            return 0;
        }
        if (obj instanceof Long) {
            long value = (Long)obj;
            return this.hashinateLong(value);
        }
        if (obj instanceof Integer) {
            long value = ((Integer)obj).intValue();
            return this.hashinateLong(value);
        }
        if (obj instanceof Short) {
            long value = ((Short)obj).shortValue();
            return this.hashinateLong(value);
        }
        if (obj instanceof Byte) {
            long value = ((Byte)obj).byteValue();
            return this.hashinateLong(value);
        }
        if (obj.getClass() == byte[].class) {
            obj = HashinatorLite.bytesToValue(type, (byte[])obj);
            return this.hashinateBytes(HashinatorLite.valueToBytes(obj));
        }
        return this.hashinateBytes(HashinatorLite.valueToBytes(obj));
    }

    public static byte[] valueToBytes(Object obj) {
        long value = 0L;
        byte[] retval = null;
        if (VoltType.isNullVoltType(obj)) {
            return null;
        }
        if (obj instanceof Long) {
            value = (Long)obj;
        } else if (obj instanceof String) {
            retval = ((String)obj).getBytes(Constants.UTF8ENCODING);
        } else if (obj instanceof Integer) {
            value = ((Integer)obj).intValue();
        } else if (obj instanceof Short) {
            value = ((Short)obj).shortValue();
        } else if (obj instanceof Byte) {
            value = ((Byte)obj).byteValue();
        } else if (obj instanceof byte[]) {
            retval = (byte[])obj;
        }
        if (retval == null) {
            ByteBuffer buf = ByteBuffer.allocate(8);
            buf.order(ByteOrder.LITTLE_ENDIAN);
            buf.putLong(value);
            retval = buf.array();
        }
        return retval;
    }

    protected static Object bytesToValue(VoltType type, byte[] value) {
        if (type == VoltType.NULL || value == null) {
            return null;
        }
        ByteBuffer buf = ByteBuffer.wrap(value);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        switch (type) {
            case BIGINT: {
                return buf.getLong();
            }
            case STRING: {
                return new String(value, Constants.UTF8ENCODING);
            }
            case INTEGER: {
                return buf.getInt();
            }
            case SMALLINT: {
                return buf.getShort();
            }
            case TINYINT: {
                return buf.get();
            }
            case VARBINARY: {
                return value;
            }
        }
        throw new RuntimeException("TheHashinator#bytesToValue failed to convert a non-partitionable type.");
    }

    public int getHashedPartitionForParameter(int partitionValueType, Object partitionValue) throws VoltTypeException {
        VoltType partitionParamType = VoltType.get((byte)partitionValueType);
        if (partitionValue != null && partitionParamType.isPartitionableNumber()) {
            if (partitionValue.getClass() == String.class) {
                Object tempParam = ParameterConverter.stringToLong(partitionValue, partitionParamType.classFromType());
                if (tempParam != null) {
                    partitionValue = tempParam;
                }
            } else if (partitionValue.getClass() == byte[].class) {
                partitionValue = HashinatorLite.bytesToValue(partitionParamType, (byte[])partitionValue);
            }
        }
        return this.hashToPartition(partitionParamType, partitionValue);
    }

    public HashinatorLiteType getConfigurationType() {
        return this.m_type;
    }

    public static byte[] gunzipBytes(byte[] compressedBytes) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream((int)((double)compressedBytes.length * 1.5));
        InflaterOutputStream dos = new InflaterOutputStream(bos);
        dos.write(compressedBytes);
        dos.close();
        return bos.toByteArray();
    }

    public static enum HashinatorLiteType {
        LEGACY(0),
        ELASTIC(1);

        public final int typeId;

        private HashinatorLiteType(int typeId) {
            this.typeId = typeId;
        }
    }
}

