/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.client;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.voltdb.ParameterSet;
import org.voltdb.client.ProcedureInvocationType;
import org.voltdb.utils.SerializationHelper;

public class ProcedureInvocation {
    private final long m_clientHandle;
    private final String m_procName;
    private byte[] m_procNameBytes;
    private final ParameterSet m_parameters;
    private final long m_originalTxnId;
    private final long m_originalUniqueId;
    private final ProcedureInvocationType m_type;

    public ProcedureInvocation(long handle, String procName, Object ... parameters) {
        this(-1L, -1L, handle, procName, parameters);
    }

    ProcedureInvocation(long originalTxnId, long originalUniqueId, long handle, String procName, Object ... parameters) {
        this.m_originalTxnId = originalTxnId;
        this.m_originalUniqueId = originalUniqueId;
        this.m_clientHandle = handle;
        this.m_procName = procName;
        this.m_parameters = parameters != null ? ParameterSet.fromArrayWithCopy(parameters) : ParameterSet.emptyParameterSet();
        this.m_type = this.m_originalTxnId == -1L && this.m_originalUniqueId == -1L ? ProcedureInvocationType.ORIGINAL : ProcedureInvocationType.REPLICATED;
    }

    long getHandle() {
        return this.m_clientHandle;
    }

    public String getProcName() {
        return this.m_procName;
    }

    public int getSerializedSize() {
        try {
            this.m_procNameBytes = this.m_procName.getBytes("UTF-8");
        }
        catch (Exception e) {
            // empty catch block
        }
        int size = 1 + (this.m_type == ProcedureInvocationType.REPLICATED ? 16 : 0) + this.m_procNameBytes.length + 4 + 8 + this.m_parameters.getSerializedSize();
        return size;
    }

    public int getPassedParamCount() {
        return this.m_parameters.size();
    }

    public Object getPartitionParamValue(int index) {
        return this.m_parameters.getParam(index);
    }

    public ByteBuffer flattenToBuffer(ByteBuffer buf) throws IOException {
        buf.put(this.m_type.getValue());
        if (this.m_type == ProcedureInvocationType.REPLICATED) {
            buf.putLong(this.m_originalTxnId);
            buf.putLong(this.m_originalUniqueId);
        }
        SerializationHelper.writeVarbinary(this.m_procNameBytes, buf);
        buf.putLong(this.m_clientHandle);
        this.m_parameters.flattenToBuffer(buf);
        return buf;
    }
}

