/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.client;

import java.util.concurrent.Semaphore;
import org.voltdb.client.AbstractProcedureArgumentCacher;
import org.voltdb.client.ClientResponse;
import org.voltdb.client.ProcedureCallback;

public final class SyncCallback
extends AbstractProcedureArgumentCacher
implements ProcedureCallback {
    private final Semaphore m_lock = new Semaphore(1);
    private ClientResponse m_response = null;

    public SyncCallback() {
        this.m_lock.acquireUninterruptibly();
    }

    @Override
    public void clientCallback(ClientResponse clientResponse) {
        this.m_response = clientResponse;
        this.m_lock.release();
    }

    public boolean checkForResponse() {
        return this.m_lock.tryAcquire();
    }

    public ClientResponse getResponse() {
        return this.m_response;
    }

    public void waitForResponse() throws InterruptedException {
        this.m_lock.acquire();
        this.m_lock.release();
    }

    @Override
    public Object[] args() {
        return super.args();
    }
}

