/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.client.exampleutils;

import java.util.Set;
import java.util.TreeSet;

public class AppHelper {
    private final Set<Argument> Arguments = new TreeSet<Argument>();
    private final String Name;

    public AppHelper(String name) {
        this.Name = name;
        this.add("statsfile", "statsfile", "File to save statistics to", "");
    }

    public AppHelper add(String name, String description) {
        this.add(name, null, description, null);
        return this;
    }

    public AppHelper add(String name, String displayValue, String description) {
        this.add(name, displayValue, description, null);
        return this;
    }

    public AppHelper add(String name, String displayValue, String description, Object defaultValue) {
        this.add(name, displayValue, description, defaultValue.toString());
        return this;
    }

    public AppHelper add(String name, String displayValue, String description, String defaultValue) {
        this.Arguments.add(new Argument(name, displayValue, description, defaultValue));
        return this;
    }

    public void printUsage() {
        System.out.printf("Usage: %s --help\n   or: %s ", this.Name, this.Name);
        for (Argument a : this.Arguments) {
            if (a.Optional) {
                System.out.printf("[--%s=%s]\n           ", a.Name, a.DisplayValue == null ? "value" : a.DisplayValue);
                continue;
            }
            System.out.printf("--%s=%s\n           ", a.Name, a.DisplayValue == null ? "value" : a.DisplayValue);
        }
        for (Argument a : this.Arguments) {
            if (a.Optional) {
                System.out.printf("\n[--%s=%s]\n", a.Name, a.DisplayValue == null ? "value" : a.DisplayValue);
            } else {
                System.out.printf("\n--%s=%s\n", a.Name, a.DisplayValue == null ? "value" : a.DisplayValue);
            }
            System.out.printf("  %s\n", a.Description);
            if (!a.Optional) continue;
            System.out.printf("  Default: %s\n", a.DefaultValue);
        }
    }

    private void printErrorAndQuit(String message) {
        System.out.println(message + "\n-------------------------------------------------------------------------------------\n");
        this.printUsage();
        System.exit(-1);
    }

    public AppHelper printActualUsage() {
        System.out.println("-------------------------------------------------------------------------------------");
        int maxLength = 24;
        for (Argument a : this.Arguments) {
            if (maxLength >= a.Name.length()) continue;
            maxLength = a.Name.length();
        }
        for (Argument a : this.Arguments) {
            String template = "%1$" + String.valueOf(maxLength - 1) + "s : ";
            System.out.printf(template, a.Name);
            System.out.println(a.Value);
        }
        System.out.println("-------------------------------------------------------------------------------------");
        return this;
    }

    public AppHelper validate(String name, boolean valid) {
        if (!valid) {
            this.printErrorAndQuit("Invalid parameter value: " + name);
        }
        return this;
    }

    public AppHelper setArguments(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("--help")) {
                this.printUsage();
                System.exit(0);
                continue;
            }
            boolean isValid = false;
            for (Argument a : this.Arguments) {
                if (args[i].startsWith("--" + a.Name + "=")) {
                    a.Value = args[i].split("=")[1];
                    isValid = true;
                    continue;
                }
                if (!args[i].equals("--" + a.Name)) continue;
                a.Value = args[++i];
                isValid = true;
            }
            if (isValid) continue;
            this.printErrorAndQuit("Invalid Parameter: " + args[i]);
        }
        for (Argument a : this.Arguments) {
            if (a.Value != null) continue;
            if (a.Optional) {
                a.Value = a.DefaultValue;
                continue;
            }
            this.printErrorAndQuit("Missing Required Parameter: " + a.Name);
        }
        return this;
    }

    private Argument getArgumentByName(String name) {
        for (Argument a : this.Arguments) {
            if (!a.Name.equals(name)) continue;
            return a;
        }
        return null;
    }

    public byte byteValue(String name) {
        try {
            return Byte.valueOf(this.getArgumentByName((String)name).Value);
        }
        catch (NullPointerException npe) {
            this.printErrorAndQuit(String.format("Argument '%s' was not provided.", name));
        }
        catch (Exception x) {
            this.printErrorAndQuit(String.format("Argument '%s' could not be cast to type: 'byte'.", name));
        }
        return -1;
    }

    public short shortValue(String name) {
        try {
            return Short.valueOf(this.getArgumentByName((String)name).Value);
        }
        catch (NullPointerException npe) {
            this.printErrorAndQuit(String.format("Argument '%s' was not provided.", name));
        }
        catch (Exception x) {
            this.printErrorAndQuit(String.format("Argument '%s' could not be cast to type: 'short'.", name));
        }
        return -1;
    }

    public int intValue(String name) {
        try {
            return Integer.valueOf(this.getArgumentByName((String)name).Value);
        }
        catch (NullPointerException npe) {
            this.printErrorAndQuit(String.format("Argument '%s' was not provided.", name));
        }
        catch (Exception x) {
            this.printErrorAndQuit(String.format("Argument '%s' could not be cast to type: 'int'.", name));
        }
        return -1;
    }

    public long longValue(String name) {
        try {
            return Long.valueOf(this.getArgumentByName((String)name).Value);
        }
        catch (NullPointerException npe) {
            this.printErrorAndQuit(String.format("Argument '%s' was not provided.", name));
        }
        catch (Exception x) {
            this.printErrorAndQuit(String.format("Argument '%s' could not be cast to type: 'long'.", name));
        }
        return -1L;
    }

    public double doubleValue(String name) {
        try {
            return Double.valueOf(this.getArgumentByName((String)name).Value);
        }
        catch (NullPointerException npe) {
            this.printErrorAndQuit(String.format("Argument '%s' was not provided.", name));
        }
        catch (Exception x) {
            this.printErrorAndQuit(String.format("Argument '%s' could not be cast to type: 'double'.", name));
        }
        return -1.0;
    }

    public String stringValue(String name) {
        try {
            return this.getArgumentByName((String)name).Value;
        }
        catch (Exception npe) {
            this.printErrorAndQuit(String.format("Argument '%s' was not provided.", name));
            return null;
        }
    }

    public boolean booleanValue(String name) {
        try {
            return Boolean.valueOf(this.getArgumentByName((String)name).Value);
        }
        catch (NullPointerException npe) {
            this.printErrorAndQuit(String.format("Argument '%s' was not provided.", name));
        }
        catch (Exception x) {
            this.printErrorAndQuit(String.format("Argument '%s' could not be cast to type: 'boolean'.", name));
        }
        return false;
    }

    private static class Argument
    implements Comparable<Argument> {
        private static int ArgumentCounter = 0;
        private final int ArgumentOrder = ArgumentCounter++;
        public final String Name;
        public final String DisplayValue;
        public final String Description;
        public final String DefaultValue;
        public final boolean Optional;
        public String Value = null;

        public Argument(String name, String displayValue, String description, String defaultValue) {
            this.Name = name;
            this.DisplayValue = displayValue;
            this.Description = description;
            this.DefaultValue = defaultValue;
            this.Optional = defaultValue != null;
        }

        @Override
        public int compareTo(Argument a) {
            if (this.ArgumentOrder < a.ArgumentOrder) {
                return -1;
            }
            if (this.ArgumentOrder == a.ArgumentOrder) {
                return 0;
            }
            return 1;
        }
    }
}

