/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.client.exampleutils;

import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.voltdb.client.ClientResponse;

public class ExecutionFuture
implements Future<ClientResponse> {
    private final CountDownLatch latch = new CountDownLatch(1);
    private final long timeout;
    private AtomicInteger status = new AtomicInteger(0);
    private static final int STATUS_RUNNING = 0;
    private static final int STATUS_SUCCESS = 1;
    private static final int STATUS_TIMEOUT = 2;
    private static final int STATUS_FAILURE = 3;
    private static final int STATUS_ABORTED = 4;
    private ClientResponse response = null;

    protected ExecutionFuture(long timeout) {
        this.timeout = timeout;
    }

    protected void set(ClientResponse response) {
        if (!this.status.compareAndSet(0, 1)) {
            return;
        }
        this.response = response;
        this.latch.countDown();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public ClientResponse get() throws InterruptedException, ExecutionException {
        try {
            return this.get(this.timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException to) {
            this.status.compareAndSet(0, 2);
            throw new ExecutionException(to);
        }
    }

    @Override
    public ClientResponse get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (!this.latch.await(timeout, unit)) {
            this.status.compareAndSet(0, 2);
            throw new TimeoutException();
        }
        if (this.isCancelled()) {
            throw new CancellationException();
        }
        if (this.response.getStatus() != 1) {
            this.status.compareAndSet(0, 3);
            throw new ExecutionException(new Exception(this.response.getStatusString()));
        }
        this.status.compareAndSet(0, 1);
        return this.response;
    }

    @Override
    public boolean isCancelled() {
        return this.status.get() == 4;
    }

    @Override
    public boolean isDone() {
        return this.status.get() != 0;
    }
}

