/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.client.exampleutils;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.voltdb.client.ClientResponse;

public class PerfCounter
implements Cloneable {
    private static final Lock lock = new ReentrantLock();
    private long StartTime = Long.MAX_VALUE;
    private long EndTime = Long.MIN_VALUE;
    private long min = 999999999L;
    private long max = -1L;
    private long tot = 0L;
    private long cnt = 0L;
    private long err = 0L;
    private long[] lat = new long[109];

    public PerfCounter() {
        this(true);
    }

    public PerfCounter(boolean start) {
        if (start) {
            this.StartTime = System.currentTimeMillis();
        }
    }

    public long getStartTime() {
        return this.StartTime;
    }

    public long getEndTime() {
        return this.EndTime;
    }

    public long getMinLatency() {
        return this.min;
    }

    public long getMaxLatency() {
        return this.max;
    }

    public long getTotalExecutionDuration() {
        return this.tot;
    }

    public long getExecutionCount() {
        return this.cnt;
    }

    public long getErrorCount() {
        return this.err;
    }

    public long[] getLatencyBuckets() {
        return this.lat;
    }

    public long getElapsedDuration() {
        return this.EndTime - this.StartTime;
    }

    public double getTransactionRatePerSecond() {
        return (double)this.getExecutionCount() * 1000.0 / (double)this.getElapsedDuration();
    }

    public double getAverageLatency() {
        return (double)this.getTotalExecutionDuration() / (double)this.getExecutionCount();
    }

    public void update(ClientResponse response) {
        this.update(response.getClientRoundtrip(), response.getStatus() == 1);
    }

    public void update(long executionDuration) {
        this.update(executionDuration, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(long executionDuration, boolean success) {
        lock.lock();
        try {
            this.EndTime = System.currentTimeMillis();
            if (this.StartTime == Long.MAX_VALUE) {
                this.StartTime = this.EndTime - executionDuration;
            }
            ++this.cnt;
            this.tot += executionDuration;
            if (this.min > executionDuration) {
                this.min = executionDuration;
            }
            if (this.max < executionDuration) {
                this.max = executionDuration;
            }
            int bucket = (int)executionDuration;
            if (executionDuration > 100L) {
                bucket = Math.min((int)((executionDuration - 100L) / 50L), 8) + 100;
            }
            int n = bucket;
            this.lat[n] = this.lat[n] + 1L;
            if (!success) {
                ++this.err;
            }
        }
        finally {
            lock.unlock();
        }
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean useSimpleFormat) {
        int i;
        long elapsedDuration;
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        long l = elapsedDuration = this.StartTime == Long.MAX_VALUE ? 1L : this.EndTime - this.StartTime;
        if (useSimpleFormat) {
            return String.format("%8s | Txn.: %,11d%s @ %,11.1f TPS | Lat. = %7d <  %7.2f < %7d\n", dateFormat.format(new Date(Math.round((double)elapsedDuration / 1000.0) * 1000L)), this.cnt, this.err > 0L ? String.format(" [!%,11d]", this.err) : "", (double)this.cnt * 1000.0 / (double)elapsedDuration, this.min == 999999999L ? 0L : this.min, (double)this.tot / (double)this.cnt, this.max == -1L ? 0L : this.max);
        }
        long[] coarseLat = new long[9];
        for (i = 0; i < 4; ++i) {
            for (int j = 0; j < 25; ++j) {
                int n = i;
                coarseLat[n] = coarseLat[n] + this.lat[i * 25 + j];
            }
        }
        for (i = 4; i < 8; ++i) {
            coarseLat[i] = this.lat[100 + i - 4];
        }
        for (int j = 104; j < this.lat.length; ++j) {
            coarseLat[8] = coarseLat[8] + this.lat[j];
        }
        return String.format("-------------------------------------------------------------------------------------\nFinal:   | Txn.: %,11d%s @ %,11.1f TPS | Lat. = %7d <  %7.2f < %7d\n-------------------------------------------------------------------------------------\nLat.:     25 <     50 <     75 <    100 <    150 <    200 <    250 <    300 <    300+\n-------------------------------------------------------------------------------------\n%%     %6.2f | %6.2f | %6.2f | %6.2f | %6.2f | %6.2f | %6.2f | %6.2f | %6.2f\n", this.cnt, this.err > 0L ? String.format(" [!%,11d]", this.err) : "", (double)this.cnt * 1000.0 / (double)elapsedDuration, this.min == 999999999L ? 0L : this.min, (double)this.tot / (double)this.cnt, this.max == -1L ? 0L : this.max, 100.0 * (double)coarseLat[0] / (double)this.cnt, 100.0 * (double)coarseLat[1] / (double)this.cnt, 100.0 * (double)coarseLat[2] / (double)this.cnt, 100.0 * (double)coarseLat[3] / (double)this.cnt, 100.0 * (double)coarseLat[4] / (double)this.cnt, 100.0 * (double)coarseLat[5] / (double)this.cnt, 100.0 * (double)coarseLat[6] / (double)this.cnt, 100.0 * (double)coarseLat[7] / (double)this.cnt, 100.0 * (double)coarseLat[8] / (double)this.cnt);
    }

    public String toRawString(char delimiter) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getStartTime()).append(delimiter).append(this.getEndTime()).append(delimiter).append(this.getExecutionCount()).append(delimiter).append(this.getMinLatency()).append(delimiter).append(this.getMaxLatency());
        for (long latency : this.getLatencyBuckets()) {
            sb.append(delimiter).append(latency);
        }
        return sb.toString();
    }

    public PerfCounter clone() {
        PerfCounter counter = new PerfCounter(false);
        counter.StartTime = this.StartTime;
        counter.EndTime = this.EndTime;
        counter.min = this.min;
        counter.max = this.max;
        counter.tot = this.tot;
        counter.cnt = this.cnt;
        counter.err = this.err;
        for (int i = 0; i < 9; ++i) {
            counter.lat[i] = this.lat[i];
        }
        return counter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PerfCounter merge(PerfCounter other) {
        lock.lock();
        try {
            this.StartTime = Math.min(this.StartTime, other.StartTime);
            this.EndTime = Math.max(this.EndTime, other.EndTime);
            this.min = Math.min(this.min, other.min);
            this.max = Math.max(this.max, other.max);
            this.tot += other.tot;
            this.cnt += other.cnt;
            this.err += other.err;
            for (int i = 0; i < 109; ++i) {
                this.lat[i] = this.lat[i] + other.lat[i];
            }
        }
        finally {
            lock.unlock();
        }
        return this;
    }

    public static PerfCounter merge(PerfCounter[] counters) {
        PerfCounter counter = counters[0].clone();
        for (int i = 1; i < counters.length; ++i) {
            counter.merge(counters[i]);
        }
        return counter;
    }

    public PerfCounter difference(PerfCounter previous) {
        PerfCounter diff = this.clone();
        if (previous != null) {
            diff.StartTime = previous.EndTime;
            diff.tot = this.tot - previous.tot;
            diff.cnt = this.cnt - previous.cnt;
            diff.err = this.err - previous.err;
            for (int i = 0; i < 109; ++i) {
                diff.lat[i] = this.lat[i] - previous.lat[i];
            }
        }
        return diff;
    }
}

