/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.importer;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Set;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.voltdb.client.ProcedureCallback;
import org.voltdb.importer.ChannelChangeCallback;
import org.voltdb.importer.ImportContext;
import org.voltdb.importer.ImporterChannelAssignment;
import org.voltdb.importer.Invocation;
import org.voltdb.importer.VersionedOperationMode;

public abstract class ImportHandlerProxy
implements ImportContext,
ChannelChangeCallback {
    public static final int SMALL_STACK_SIZE = 262144;
    public static final int MEDIUM_STACK_SIZE = 524288;
    private static final AtomicLong m_createdThreadCount = new AtomicLong(0L);
    private Object m_handler = null;
    private Method m_callProcMethod;
    private Method m_asyncCallProcMethod;
    private Method m_hasTableMethod;
    private Method m_info_log;
    private Method m_error_log;
    private Method m_warn_log;
    private Method m_error_log_withT;
    private Method m_error_log_rateLimited;
    private Method m_warn_log_rateLimited;
    private Method m_debug_log;
    private Method m_trace_log;
    private Method m_debug_enabled;
    private Method m_trace_enabled;
    private Method m_info_enabled;

    @Override
    public boolean canContinue() {
        return true;
    }

    public boolean hasTable(String name) {
        try {
            return (Boolean)this.m_hasTableMethod.invoke(this.m_handler, name);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean callProcedure(String proc, Object ... fieldList) {
        try {
            return (Boolean)this.m_callProcMethod.invoke(this.m_handler, this, proc, fieldList);
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public boolean callProcedure(Invocation invocation) {
        try {
            Object[] params = invocation.getParams();
            return (Boolean)this.m_callProcMethod.invoke(this.m_handler, this, invocation.getProcedure(), params);
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public boolean callProcedure(ProcedureCallback cb, Invocation invocation) {
        try {
            Object[] params = invocation.getParams();
            return (Boolean)this.m_asyncCallProcMethod.invoke(this.m_handler, this, cb, invocation.getProcedure(), params);
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public void setHandler(Object handler) throws Exception {
        this.m_handler = handler;
        this.m_callProcMethod = this.m_handler.getClass().getMethod("callProcedure", ImportContext.class, String.class, Object[].class);
        this.m_asyncCallProcMethod = this.m_handler.getClass().getMethod("callProcedure", ImportContext.class, ProcedureCallback.class, String.class, Object[].class);
        this.m_hasTableMethod = this.m_handler.getClass().getMethod("hasTable", String.class);
        this.m_info_log = this.m_handler.getClass().getMethod("info", String.class);
        this.m_error_log = this.m_handler.getClass().getMethod("error", String.class);
        this.m_warn_log = this.m_handler.getClass().getMethod("warn", String.class);
        this.m_debug_log = this.m_handler.getClass().getMethod("debug", String.class);
        this.m_trace_log = this.m_handler.getClass().getMethod("debug", String.class);
        this.m_error_log_rateLimited = this.m_handler.getClass().getMethod("error", Throwable.class, String.class, Object[].class);
        this.m_error_log_withT = this.m_handler.getClass().getMethod("error", String.class, Throwable.class);
        this.m_debug_enabled = this.m_handler.getClass().getMethod("isDebugEnabled", null);
        this.m_info_enabled = this.m_handler.getClass().getMethod("isInfoEnabled", null);
        this.m_trace_enabled = this.m_handler.getClass().getMethod("isTraceEnabled", null);
        this.m_warn_log_rateLimited = this.m_handler.getClass().getMethod("warn", Throwable.class, String.class, Object[].class);
    }

    @Override
    public void info(String message) {
        try {
            if (this.m_info_log != null) {
                this.m_info_log.invoke(this.m_handler, message);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void error(Throwable t, String format, Object ... args) {
        try {
            if (this.m_error_log != null) {
                this.m_error_log_rateLimited.invoke(this.m_handler, t, format, args);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    @Override
    public void warn(Throwable t, String format, Object ... args) {
        try {
            if (this.m_warn_log_rateLimited != null) {
                this.m_warn_log_rateLimited.invoke(this.m_handler, t, format, args);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    @Override
    public void error(String message) {
        try {
            if (this.m_error_log != null) {
                this.m_error_log.invoke(this.m_handler, message);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void error(String message, Throwable t) {
        try {
            if (this.m_error_log != null) {
                this.m_error_log_withT.invoke(this.m_handler, message, t);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void warn(String message) {
        try {
            if (this.m_error_log != null) {
                this.m_warn_log.invoke(this.m_handler, message);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void debug(String message) {
        try {
            if (this.m_debug_log != null) {
                this.m_debug_log.invoke(this.m_handler, message);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void trace(String message) {
        try {
            if (this.m_debug_log != null) {
                this.m_trace_log.invoke(this.m_handler, message);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean isDebugEnabled() {
        try {
            if (this.m_debug_enabled != null) {
                return (Boolean)this.m_debug_enabled.invoke(this.m_handler, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean isTraceEnabled() {
        try {
            if (this.m_debug_enabled != null) {
                return (Boolean)this.m_trace_enabled.invoke(this.m_handler, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean isInfoEnabled() {
        try {
            if (this.m_debug_enabled != null) {
                return (Boolean)this.m_info_enabled.invoke(this.m_handler, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public long getBackpressureTimeout() {
        return TimeUnit.MINUTES.toNanos(2L);
    }

    @Override
    public boolean isRunEveryWhere() {
        return true;
    }

    @Override
    public Set<URI> getAllResponsibleResources() {
        throw new UnsupportedOperationException("For Distributed Importer this must be implemented.");
    }

    @Override
    public void onChange(ImporterChannelAssignment assignment) {
        throw new UnsupportedOperationException("For Distributed Importer this must be implemented.");
    }

    @Override
    public void onClusterStateChange(VersionedOperationMode mode) {
        throw new UnsupportedOperationException("For Distributed Importer this must be implemented.");
    }

    public static ThreadFactory getThreadFactory(String groupName, final String name, final int stackSize) {
        final ThreadGroup group = new ThreadGroup(Thread.currentThread().getThreadGroup(), groupName);
        return new ThreadFactory(){

            @Override
            public synchronized Thread newThread(Runnable r) {
                String threadName = name + " - " + m_createdThreadCount.getAndIncrement();
                Thread t = new Thread(group, r, threadName, stackSize);
                t.setDaemon(true);
                return t;
            }
        };
    }
}

