/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.importer;

import java.net.URI;
import java.util.Set;

public class ImporterChannelAssignment {
    final int version;
    final String importer;
    final Set<URI> added;
    final Set<URI> removed;
    final Set<URI> assigned;

    ImporterChannelAssignment(String importer, Set<URI> added, Set<URI> removed, Set<URI> assigned, int version) {
        if (importer == null || importer.trim().isEmpty()) {
            throw new IllegalArgumentException("null or empty or blank importer");
        }
        if (version < 0) {
            throw new IllegalArgumentException("version is less than 0");
        }
        if (added == null) {
            throw new IllegalArgumentException("added is null");
        }
        if (removed == null) {
            throw new IllegalArgumentException("removed is null");
        }
        if (assigned == null) {
            throw new IllegalArgumentException("assigned is null");
        }
        this.version = version;
        this.importer = importer;
        this.added = added;
        this.removed = removed;
        this.assigned = assigned;
    }

    public int getVersion() {
        return this.version;
    }

    public String getImporter() {
        return this.importer;
    }

    public Set<URI> getAdded() {
        return this.added;
    }

    public Set<URI> getRemoved() {
        return this.removed;
    }

    public Set<URI> getAssigned() {
        return this.assigned;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.added == null ? 0 : this.added.hashCode());
        result = 31 * result + (this.assigned == null ? 0 : this.assigned.hashCode());
        result = 31 * result + (this.importer == null ? 0 : this.importer.hashCode());
        result = 31 * result + (this.removed == null ? 0 : this.removed.hashCode());
        result = 31 * result + this.version;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImporterChannelAssignment other = (ImporterChannelAssignment)obj;
        if (this.added == null ? other.added != null : !this.added.equals(other.added)) {
            return false;
        }
        if (this.assigned == null ? other.assigned != null : !this.assigned.equals(other.assigned)) {
            return false;
        }
        if (this.importer == null ? other.importer != null : !this.importer.equals(other.importer)) {
            return false;
        }
        if (this.removed == null ? other.removed != null : !this.removed.equals(other.removed)) {
            return false;
        }
        return this.version == other.version;
    }

    public String toString() {
        return "ImporterChannelAssignment [importer=" + this.importer + ", added=" + this.added + ", removed=" + this.removed + ", assigned=" + this.assigned + ", version=" + this.version + "]";
    }
}

